/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdbuilder.script;

import com.google.common.base.Preconditions;
import com.mcsimonflash.sponge.cmdbuilder.internal.Scripts;
import com.mcsimonflash.sponge.cmdbuilder.miscellaneous.ExecutorContainer;
import com.mcsimonflash.sponge.cmdbuilder.miscellaneous.Source;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueTypeEntry;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.configuration.NodeUtils;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.SimpleConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;

public class Executor {
    private long delay = 0L;
    private String command;
    private Source source;
    private ConfigurationNode meta;

    private Executor(long delay, String command, Source source, ConfigurationNode meta) {
        this.delay = delay;
        this.command = command;
        this.source = source;
        this.meta = meta;
    }

    public ExecutorContainer buildExecutor(CommandSource src, Map<String, ValueTypeEntry> arguments) throws IllegalArgumentException {
        CommandSource modifiedSource = src;
        if (this.source == Source.PLAYER) {
            Preconditions.checkArgument((boolean)(src instanceof Player), (String)"This executed requested a Player source, but instead found %s.", (Object)src.getClass().getSimpleName());
        } else if (this.source == Source.INJECT) {
            String iden = this.meta.getNode(new Object[]{"player"}).getString("");
            modifiedSource = (CommandSource)Sponge.getServer().getPlayer(Scripts.insertArguments(iden, src, arguments)).orElseThrow(() -> new IllegalArgumentException("Unable to inject source from meta#player '" + iden + "'."));
        } else if (this.source == Source.SERVER) {
            modifiedSource = Sponge.getServer().getConsole();
        }
        return new ExecutorContainer(this.delay, Scripts.insertArguments(this.command, src, arguments), modifiedSource);
    }

    public long getDelay() {
        return this.delay;
    }

    public String getCommand() {
        return this.command;
    }

    public Source getSource() {
        return this.source;
    }

    public ConfigurationNode getMeta() {
        return this.meta;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long delay = 0L;
        private String command;
        private Source source;
        private ConfigurationNode meta = SimpleConfigurationNode.root();

        public Builder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder meta(ConfigurationNode meta) {
            this.meta = NodeUtils.copy((ConfigurationNode)meta);
            return this;
        }

        public Executor build() throws IllegalArgumentException {
            Preconditions.checkArgument((this.command != null ? 1 : 0) != 0, (Object)"'command' must be defined.");
            Preconditions.checkArgument((this.source != null ? 1 : 0) != 0, (Object)"'source' must be defined.");
            return new Executor(this.delay, this.command, this.source, this.meta);
        }
    }
}

