/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdbuilder.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mcsimonflash.sponge.cmdbuilder.CmdBuilder;
import com.mcsimonflash.sponge.cmdbuilder.internal.Config;
import com.mcsimonflash.sponge.cmdbuilder.internal.Util;
import com.mcsimonflash.sponge.cmdbuilder.miscellaneous.ExecutorContainer;
import com.mcsimonflash.sponge.cmdbuilder.miscellaneous.Source;
import com.mcsimonflash.sponge.cmdbuilder.script.Argument;
import com.mcsimonflash.sponge.cmdbuilder.script.Executor;
import com.mcsimonflash.sponge.cmdbuilder.script.Metadata;
import com.mcsimonflash.sponge.cmdbuilder.type.ParserTypes;
import com.mcsimonflash.sponge.cmdbuilder.type.ValueTypeEntry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;

public class Script {
    private final String name;
    private final ImmutableList<Argument> arguments;
    private final ImmutableList<Executor> executors;
    private final Metadata metadata;
    private final CommandSpec spec;

    public Script(String name, ImmutableList<Argument> arguments, ImmutableList<Executor> executors, Metadata metadata) {
        this.name = name;
        this.arguments = arguments;
        this.executors = executors;
        this.metadata = metadata;
        this.spec = CommandSpec.builder().executor(this::execute).arguments((CommandElement[])arguments.stream().map(Argument::getElement).toArray(CommandElement[]::new)).permission("cmdbuilder.scripts." + name + ".base").build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        try {
            if (src instanceof User) {
                if (this.metadata.getCooldown() > 0L && !src.hasPermission("cmdbuilder.scripts." + this.name + ".nocooldown")) {
                    long time = this.metadata.getCooldown() - (System.currentTimeMillis() - Config.getCooldown(((User)src).getUniqueId(), this));
                    Preconditions.checkArgument((time <= 0L ? 1 : 0) != 0, (String)"You must wait '%s' seconds before using this script.", (long)(time / 1000L));
                }
                if (this.metadata.getCost() > 0.0 && !src.hasPermission("cmdbuilder.scripts." + this.name + ".nocost")) {
                    EconomyService service = (EconomyService)Sponge.getServiceManager().provide(EconomyService.class).orElseThrow(() -> new IllegalArgumentException("An economy plugin is required to use this script."));
                    UniqueAccount account = (UniqueAccount)service.getOrCreateAccount(((User)src).getUniqueId()).orElseThrow(() -> new IllegalArgumentException("An unexpected error occurred attempting to locate your economy account."));
                    TransactionResult result = account.withdraw(service.getDefaultCurrency(), BigDecimal.valueOf(this.metadata.getCost()), Sponge.getCauseStackManager().getCurrentCause());
                    Preconditions.checkArgument((result.getResult() == ResultType.SUCCESS ? 1 : 0) != 0, (String)"You cannot afford the cost of '%s' to use this script.", (Object)this.metadata.getCost());
                }
            } else {
                Preconditions.checkArgument((boolean)this.executors.stream().noneMatch(e -> e.getSource() == Source.PLAYER), (Object)"Only a player may run this script.");
            }
            Map<String, ValueTypeEntry> arguments = this.arguments.stream().collect(Collectors.toMap(Argument::getName, a -> a.collectArg(args)));
            List executors = this.executors.stream().map(e -> e.buildExecutor(src, arguments)).collect(Collectors.toList());
            if (src instanceof User && this.metadata.getCooldown() > 0L && !Config.setCooldown(((User)src).getUniqueId(), this, System.currentTimeMillis())) {
                throw new IllegalArgumentException("Unable to save cooldown - please contact an administrator");
            }
            for (ExecutorContainer executor : executors) {
                if (executor.getDelay() > 0L) {
                    Task.builder().name("Script '" + this.name + "' Executor for Source '" + src.getName() + "'").execute(executor::execute).delay(executor.getDelay(), TimeUnit.MILLISECONDS).submit((Object)CmdBuilder.get().getContainer());
                    continue;
                }
                executor.execute();
            }
            return CommandResult.success();
        }
        catch (IllegalArgumentException e2) {
            src.sendMessage(CmdBuilder.get().getPrefix().concat(Util.toText(e2.getMessage())));
            return CommandResult.empty();
        }
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<Argument> getArguments() {
        return this.arguments;
    }

    public ImmutableList<Executor> getExecutors() {
        return this.executors;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public CommandSpec getSpec() {
        return this.spec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private ImmutableList<Argument> arguments = ImmutableList.of();
        private ImmutableList<Executor> executors = ImmutableList.of();
        private Metadata metadata = Metadata.DEFAULT;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder arguments(List<Argument> arguments) {
            this.arguments = ImmutableList.copyOf(arguments);
            return this;
        }

        public Builder executors(List<Executor> executors) {
            this.executors = ImmutableList.copyOf(executors);
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Script build() throws IllegalArgumentException {
            Preconditions.checkArgument((this.name != null && !this.name.isEmpty() ? 1 : 0) != 0, (Object)"'name' must be defined");
            ArrayList names = Lists.newArrayList();
            for (int i = 0; i < this.arguments.size(); ++i) {
                Argument argument = (Argument)this.arguments.get(i);
                Preconditions.checkArgument((!names.contains(argument.getName()) ? 1 : 0) != 0, (String)"Found duplicate argument named '%s'.", (Object)argument.getName());
                Preconditions.checkArgument((argument.getParser() != ParserTypes.JOINED_STRINGS || i == this.arguments.size() - 1 ? 1 : 0) != 0, (String)"Found intermediate JoinedStrings argument named '%s'", (Object)argument.getName());
                names.add(argument.getName());
            }
            return new Script(this.name, this.arguments, this.executors, this.metadata);
        }
    }
}

