/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.lottery.commands;

import de.randombyte.lottery.Config;
import de.randombyte.lottery.LotteryKt;
import de.randombyte.lottery.shaded.kosp.config.ConfigManager;
import de.randombyte.lottery.shaded.kotlin.Metadata;
import de.randombyte.lottery.shaded.kotlin.TuplesKt;
import de.randombyte.lottery.shaded.kotlin.collections.MapsKt;
import de.randombyte.lottery.shaded.kotlin.jvm.functions.Function0;
import de.randombyte.lottery.shaded.kotlin.jvm.internal.Intrinsics;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.text.Text;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lde/randombyte/lottery/commands/InfoCommand;", "Lorg/spongepowered/api/command/spec/CommandExecutor;", "configManager", "Lde/randombyte/lottery/shaded/kosp/config/ConfigManager;", "Lde/randombyte/lottery/Config;", "durationUntilDraw", "Lde/randombyte/lottery/shaded/kotlin/Function0;", "Ljava/time/Duration;", "(Lde/randombyte/kosp/config/ConfigManager;Lkotlin/jvm/functions/Function0;)V", "getConfigManager", "()Lde/randombyte/kosp/config/ConfigManager;", "getDurationUntilDraw", "()Lkotlin/jvm/functions/Function0;", "execute", "Lorg/spongepowered/api/command/CommandResult;", "src", "Lorg/spongepowered/api/command/CommandSource;", "args", "Lorg/spongepowered/api/command/args/CommandContext;", "lottery"})
public final class InfoCommand
implements CommandExecutor {
    @NotNull
    private final ConfigManager<Config> configManager;
    @NotNull
    private final Function0<Duration> durationUntilDraw;

    @NotNull
    public CommandResult execute(@NotNull CommandSource src, @NotNull CommandContext args) {
        Intrinsics.checkParameterIsNotNull(src, "src");
        Intrinsics.checkParameterIsNotNull(args, "args");
        Config config = this.configManager.get();
        Currency currency = LotteryKt.getDefaultCurrency();
        if (src instanceof Player) {
            Text infoText = config.getMessages().getInfoMessagePlayer().apply(MapsKt.mapOf(TuplesKt.to("boughtTickets", config.getInternalData().getBoughtTickets((Player)src)), TuplesKt.to("pot", config.calculatePot()), TuplesKt.to("currencySymbol", currency.getSymbol()), TuplesKt.to("currencyName", currency.getName()), TuplesKt.to("minutesUntilDraw", this.durationUntilDraw.invoke().toMinutes()), TuplesKt.to("ticketCosts", config.getTicketCosts()))).build();
            src.sendMessage(infoText);
        } else {
            Text infoText = config.getMessages().getInfoMessageConsole().apply(MapsKt.mapOf(TuplesKt.to("pot", config.calculatePot()), TuplesKt.to("currencySymbol", currency.getSymbol()), TuplesKt.to("currencyName", currency.getName()), TuplesKt.to("minutesUntilDraw", this.durationUntilDraw.invoke().toMinutes()), TuplesKt.to("ticketCosts", config.getTicketCosts()))).build();
            src.sendMessage(infoText);
        }
        CommandResult commandResult = CommandResult.success();
        Intrinsics.checkExpressionValueIsNotNull(commandResult, "CommandResult.success()");
        return commandResult;
    }

    @NotNull
    public final ConfigManager<Config> getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final Function0<Duration> getDurationUntilDraw() {
        return this.durationUntilDraw;
    }

    public InfoCommand(@NotNull ConfigManager<Config> configManager, @NotNull Function0<Duration> durationUntilDraw) {
        Intrinsics.checkParameterIsNotNull(configManager, "configManager");
        Intrinsics.checkParameterIsNotNull(durationUntilDraw, "durationUntilDraw");
        this.configManager = configManager;
        this.durationUntilDraw = durationUntilDraw;
    }
}

