/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.backwardCompat.VersionCompat;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.XMLPlanetLoader;
import zmaster587.advancedRocketry.world.provider.WorldProviderAsteroid;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;

public class DimensionManager
implements IGalaxy {
    public static Logger logger = AdvancedRocketry.logger;
    private Random random;
    private static DimensionManager instance;
    public static final String workingPath = "advRocketry";
    public static final String tempFile = "/temp.dat";
    public static final String worldXML = "/planetDefs.xml";
    public static int dimOffset;
    public static final DimensionType PlanetDimensionType;
    public static final DimensionType spaceDimensionType;
    public static final DimensionType AsteroidDimensionType;
    private boolean hasBeenInitiallized = false;
    public static String prevBuild;
    public static boolean hasReachedMoon;
    public static boolean hasReachedWarp;
    public static Class<? extends WorldProvider> planetWorldProvider;
    private HashMap<Integer, DimensionProperties> dimensionList = new HashMap();
    private HashMap<Integer, StellarBody> starList = new HashMap();
    public static final int GASGIANT_DIMID_OFFSET = 256;
    private static long nextSatelliteId;
    private static StellarBody sol;
    public Set<Integer> knownPlanets;
    public static DimensionProperties overworldProperties;
    public static DimensionProperties defaultSpaceDimensionProperties;

    @Deprecated
    public static StellarBody getSol() {
        return DimensionManager.getInstance().getStar(0);
    }

    public static DimensionManager getInstance() {
        return AdvancedRocketry.proxy.getDimensionManager();
    }

    public DimensionManager() {
        sol = new StellarBody();
        sol.setTemperature(100);
        sol.setId(0);
        sol.setName("Sol");
        overworldProperties = new DimensionProperties(0);
        overworldProperties.setAtmosphereDensityDirect(100);
        DimensionManager.overworldProperties.averageTemperature = 100;
        DimensionManager.overworldProperties.gravitationalMultiplier = 1.0f;
        DimensionManager.overworldProperties.orbitalDist = 100;
        DimensionManager.overworldProperties.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        overworldProperties.setName("Earth");
        DimensionManager.overworldProperties.isNativeDimension = false;
        defaultSpaceDimensionProperties = new DimensionProperties(Integer.MIN_VALUE, false);
        defaultSpaceDimensionProperties.setAtmosphereDensityDirect(0);
        DimensionManager.defaultSpaceDimensionProperties.averageTemperature = 0;
        DimensionManager.defaultSpaceDimensionProperties.gravitationalMultiplier = 0.1f;
        DimensionManager.defaultSpaceDimensionProperties.orbitalDist = 100;
        DimensionManager.defaultSpaceDimensionProperties.skyColor = new float[]{0.0f, 0.0f, 0.0f};
        defaultSpaceDimensionProperties.setName("Space");
        DimensionManager.defaultSpaceDimensionProperties.fogColor = new float[]{0.0f, 0.0f, 0.0f};
        DimensionManager.defaultSpaceDimensionProperties.orbitalDist = 1;
        this.random = new Random(System.currentTimeMillis());
        this.knownPlanets = new HashSet<Integer>();
    }

    @Override
    public Integer[] getRegisteredDimensions() {
        Integer[] ret = new Integer[this.dimensionList.size()];
        return this.dimensionList.keySet().toArray(ret);
    }

    public Integer[] getLoadedDimensions() {
        return this.getRegisteredDimensions();
    }

    public long getNextSatelliteId() {
        return nextSatelliteId++;
    }

    @Override
    public SatelliteBase getSatellite(long satId) {
        SatelliteBase satellite;
        if (!this.hasBeenInitiallized && FMLCommonHandler.instance().getSide().isServer()) {
            DimensionManager.getInstance().loadDimensions(workingPath);
        }
        if ((satellite = overworldProperties.getSatellite(satId)) != null) {
            return satellite;
        }
        Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            satellite = DimensionManager.getInstance().getDimensionProperties(i2).getSatellite(satId);
            if (satellite == null) continue;
            return satellite;
        }
        return null;
    }

    private String getNextName(int dimId) {
        return "Sol-" + dimId;
    }

    public void tickDimensions() {
        overworldProperties.tick();
        Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            DimensionManager.getInstance().getDimensionProperties(i2).tick();
        }
    }

    public void tickDimensionsClient() {
        overworldProperties.updateOrbit();
        Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            DimensionManager.getInstance().getDimensionProperties(i2).updateOrbit();
        }
    }

    public void setDimProperties(int dimId, DimensionProperties properties) {
        this.dimensionList.put(new Integer(dimId), properties);
    }

    public int getNextFreeDim(int startingValue) {
        for (int i = startingValue; i < 10000; ++i) {
            if (net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)i) || this.dimensionList.containsKey(i)) continue;
            return i;
        }
        return -2147483647;
    }

    public int getNextFreeStarId() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.starList.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    public int getTemperature(StellarBody star, int orbitalDistance, int atmPressure) {
        return (star.getTemperature() + (100 - orbitalDistance) * 15 + atmPressure * 18) / 20;
    }

    public DimensionProperties generateRandom(int starId, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, 100, 100, 100, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandom(int starId, String name, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, name, 100, 100, 100, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandom(int starId, String name, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        double minDistance;
        DimensionProperties properties = new DimensionProperties(this.getNextFreeDim(dimOffset));
        if (properties.getId() == -2147483647) {
            return null;
        }
        if (name == "") {
            properties.setName(this.getNextName(properties.getId()));
        } else {
            properties.setName(name);
        }
        properties.setAtmosphereDensityDirect(MathHelper.func_76125_a((int)(baseAtmosphere + this.random.nextInt(atmosphereFactor) - atmosphereFactor / 2), (int)0, (int)200));
        int newDist = properties.orbitalDist = MathHelper.func_76125_a((int)(baseDistance + this.random.nextInt(distanceFactor)), (int)0, (int)200);
        properties.gravitationalMultiplier = Math.min(Math.max(0.05f, (float)(baseGravity + this.random.nextInt(gravityFactor) - gravityFactor / 2) / 100.0f), 1.3f);
        int walkDist = 0;
        do {
            minDistance = Double.MAX_VALUE;
            for (IDimensionProperties properties2 : this.getStar(starId).getPlanets()) {
                int dist = Math.abs(((DimensionProperties)properties2).orbitalDist - newDist);
                if (!(minDistance > (double)dist)) continue;
                minDistance = dist;
            }
            newDist = properties.orbitalDist + walkDist;
            walkDist = walkDist > -1 ? -walkDist - 1 : -walkDist;
        } while (minDistance < 4.0);
        properties.orbitalDist = newDist;
        properties.orbitalPhi = (this.random.nextGaussian() - 0.5) * 180.0;
        properties.rotationalPhi = (this.random.nextGaussian() - 0.5) * 180.0;
        properties.setStar(this.getStar(starId));
        properties.averageTemperature = this.getTemperature(properties.getStar(), properties.orbitalDist, properties.getAtmosphereDensity());
        if (DimensionProperties.AtmosphereTypes.getAtmosphereTypeFromValue(properties.getAtmosphereDensity()) == DimensionProperties.AtmosphereTypes.NONE && this.random.nextInt() % 5 == 0) {
            properties.setOceanBlock(AdvancedRocketryBlocks.blockOxygenFluid.func_176223_P());
            properties.setSeaLevel(this.random.nextInt(6) + 72);
        }
        if (this.random.nextInt() % 10 == 0) {
            properties.setSeaLevel(this.random.nextInt(40) + 43);
        }
        properties.skyColor[0] = properties.skyColor[0] * (1.0f - MathHelper.func_76131_a((float)(this.random.nextFloat() * 0.1f + (float)(70 - properties.averageTemperature) / 100.0f), (float)0.2f, (float)1.0f));
        properties.skyColor[1] = properties.skyColor[1] * (1.0f - this.random.nextFloat() * 0.5f);
        properties.skyColor[2] = properties.skyColor[2] * (1.0f - MathHelper.func_76131_a((float)(this.random.nextFloat() * 0.1f + (float)(properties.averageTemperature - 70) / 100.0f), (float)0.0f, (float)1.0f));
        if (this.random.nextInt() % 50 == 0) {
            properties.setHasRings(true);
            properties.ringColor[0] = properties.skyColor[0];
            properties.ringColor[1] = properties.skyColor[1];
            properties.ringColor[2] = properties.skyColor[2];
        }
        properties.rotationalPeriod = (int)(Math.pow(1.0f / properties.gravitationalMultiplier, 3.0) * 24000.0);
        properties.addBiomes(properties.getViableBiomes());
        properties.initDefaultAttributes();
        this.registerDim(properties, true);
        return properties;
    }

    public DimensionProperties generateRandom(int starId, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, "", baseAtmosphere, baseDistance, baseGravity, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandomGasGiant(int starId, String name, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        double minDistance;
        DimensionProperties properties = new DimensionProperties(this.getNextFreeDim(dimOffset));
        if (name == "") {
            properties.setName(this.getNextName(properties.getId()));
        } else {
            properties.setName(name);
        }
        properties.setAtmosphereDensityDirect(MathHelper.func_76125_a((int)(baseAtmosphere + this.random.nextInt(atmosphereFactor) - atmosphereFactor / 2), (int)0, (int)200));
        properties.orbitalDist = MathHelper.func_76125_a((int)(baseDistance + this.random.nextInt(distanceFactor)), (int)0, (int)200);
        properties.gravitationalMultiplier = Math.min(Math.max(0.05f, (float)(baseGravity + this.random.nextInt(gravityFactor) - gravityFactor / 2) / 100.0f), 1.3f);
        do {
            minDistance = Double.MAX_VALUE;
            properties.orbitTheta = (double)this.random.nextInt(360) * (Math.PI * 2) / 360.0;
            for (IDimensionProperties properties2 : this.getStar(starId).getPlanets()) {
                double dist = Math.abs(((DimensionProperties)properties2).orbitTheta - properties.orbitTheta);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
            }
        } while (minDistance < 0.07853981633974483);
        properties.setStar(this.getStar(starId));
        properties.averageTemperature = this.getTemperature(properties.getStar(), properties.orbitalDist, properties.getAtmosphereDensity());
        properties.setGasGiant(true);
        for (Fluid gas : AdvancedRocketryFluids.getGasGiantGasses()) {
            properties.getHarvestableGasses().add(gas);
        }
        this.registerDim(properties, true);
        return properties;
    }

    @Override
    public boolean canTravelTo(int dimId) {
        return net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dimId) && dimId != -2147483647 && this.getDimensionProperties(dimId).hasSurface();
    }

    public boolean registerDim(DimensionProperties properties, boolean registerWithForge) {
        boolean bool = this.registerDimNoUpdate(properties, registerWithForge);
        if (bool) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(properties.getId(), properties));
        }
        return bool;
    }

    public boolean registerDimNoUpdate(DimensionProperties properties, boolean registerWithForge) {
        int dimId = properties.getId();
        Integer dim = new Integer(dimId);
        if (this.dimensionList.containsKey(dim)) {
            return false;
        }
        if (registerWithForge && properties.hasSurface() && !net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dim)) {
            if (properties.isAsteroid()) {
                net.minecraftforge.common.DimensionManager.registerDimension((int)dimId, (DimensionType)AsteroidDimensionType);
            } else {
                net.minecraftforge.common.DimensionManager.registerDimension((int)dimId, (DimensionType)PlanetDimensionType);
            }
        }
        this.dimensionList.put(dimId, properties);
        return true;
    }

    public void unregisterAllDimensions() {
        for (Map.Entry<Integer, DimensionProperties> dimSet : this.dimensionList.entrySet()) {
            if (!dimSet.getValue().isNativeDimension || !dimSet.getValue().hasSurface() || !net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dimSet.getKey())) continue;
            net.minecraftforge.common.DimensionManager.unregisterDimension((int)dimSet.getKey());
        }
        this.dimensionList.clear();
        this.starList.clear();
    }

    public void deleteDimension(int dimId) {
        if (net.minecraftforge.common.DimensionManager.getWorld((int)dimId) != null) {
            AdvancedRocketry.logger.warn("Cannot delete dimension " + dimId + " it is still loaded");
            return;
        }
        DimensionProperties properties = this.dimensionList.get(dimId);
        if (properties == null) {
            return;
        }
        if (properties.getStar() != null) {
            properties.getStar().removePlanet(properties);
        }
        if (properties.isMoon()) {
            properties.getParentProperties().removeChild(properties.getId());
        }
        if (properties.hasChildren()) {
            Iterator<Integer> iterator = properties.getChildPlanets().iterator();
            while (iterator.hasNext()) {
                Integer child = iterator.next();
                iterator.remove();
                this.deleteDimension(child);
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(child, null));
            }
        }
        if (properties.isNativeDimension && net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dimId)) {
            if (net.minecraftforge.common.DimensionManager.getWorld((int)dimId) != null) {
                net.minecraftforge.common.DimensionManager.unloadWorld((int)dimId);
            }
            net.minecraftforge.common.DimensionManager.unregisterDimension((int)dimId);
        }
        this.dimensionList.remove(new Integer(dimId));
        File file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), "advRocketry/DIM" + dimId);
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isInitialized() {
        return this.hasBeenInitiallized;
    }

    public void onServerStopped() {
        this.unregisterAllDimensions();
        this.knownPlanets.clear();
        overworldProperties.resetProperties();
        this.hasBeenInitiallized = false;
    }

    @Override
    public DimensionProperties getDimensionProperties(int dimId) {
        if (dimId >= 10000) {
            StellarBody star = this.getStar(dimId - 10000);
            if (star == null) {
                return overworldProperties;
            }
            DimensionProperties newprops = new DimensionProperties(dimId);
            newprops.setName(star.getName());
            return newprops;
        }
        DimensionProperties properties = this.dimensionList.get(new Integer(dimId));
        if (dimId == ARConfiguration.getCurrentConfig().spaceDimId || dimId == Integer.MIN_VALUE) {
            return defaultSpaceDimensionProperties;
        }
        return properties == null ? overworldProperties : properties;
    }

    @Override
    public StellarBody getStar(int id) {
        return this.starList.get(new Integer(id));
    }

    public Set<Integer> getStarIds() {
        return this.starList.keySet();
    }

    @Override
    public Collection<StellarBody> getStars() {
        return this.starList.values();
    }

    public void addStar(StellarBody star) {
        this.starList.put(star.getId(), star);
    }

    public void removeStar(int id) {
        this.starList.remove(id);
    }

    public void saveDimensions(String filePath) throws Exception {
        if (this.starList.isEmpty() || this.dimensionList.isEmpty()) {
            throw new Exception("Missing Stars");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound dimListnbt = new NBTTagCompound();
        NBTTagCompound solarSystem = new NBTTagCompound();
        for (Map.Entry<Integer, StellarBody> entry : this.starList.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            entry.getValue().writeToNBT(nBTTagCompound);
            solarSystem.func_74782_a(entry.getKey().toString(), (NBTBase)nBTTagCompound);
        }
        nbt.func_74782_a("starSystems", (NBTBase)solarSystem);
        nbt.func_74772_a("nextSatelliteId", nextSatelliteId);
        NBTTagCompound dimNbt = new NBTTagCompound();
        for (Map.Entry<Integer, DimensionProperties> entry : this.dimensionList.entrySet()) {
            dimNbt = new NBTTagCompound();
            entry.getValue().writeToNBT(dimNbt);
            dimListnbt.func_74782_a(entry.getKey().toString(), (NBTBase)dimNbt);
        }
        nbt.func_74782_a("dimList", (NBTBase)dimListnbt);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74757_a("hasReachedMoon", hasReachedMoon);
        nBTTagCompound.func_74757_a("hasReachedWarp", hasReachedWarp);
        nbt.func_74782_a("stat", (NBTBase)nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        SpaceObjectManager.getSpaceManager().writeToNBT(nBTTagCompound2);
        nbt.func_74782_a("spaceObjects", (NBTBase)nBTTagCompound2);
        String xmlOutput = XMLPlanetLoader.writeXML(this);
        try {
            File planetXMLOutput = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), filePath + worldXML);
            if (!planetXMLOutput.exists()) {
                planetXMLOutput.createNewFile();
            }
            File tmpFileXml = File.createTempFile("ARXMLdata_", ".DAT", net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory());
            FileOutputStream bufoutStream = new FileOutputStream(tmpFileXml);
            bufoutStream.write(xmlOutput.getBytes());
            bufoutStream.flush();
            bufoutStream.getFD().sync();
            bufoutStream.close();
            Files.copy((File)tmpFileXml, (File)planetXMLOutput);
            tmpFileXml.delete();
            File file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), filePath + tempFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            File tmpFile = File.createTempFile("dimprops", ".DAT", net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory());
            FileOutputStream tmpFileOut = new FileOutputStream(tmpFile);
            DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(tmpFileOut)));
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)outStream);
                outStream.flush();
                tmpFileOut.getFD().sync();
                outStream.close();
                Files.copy((File)tmpFile, (File)file);
                tmpFile.delete();
            }
            catch (Exception e) {
                AdvancedRocketry.logger.error("Cannot save advanced rocketry planet file, you may be able to find backups in " + net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory());
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            AdvancedRocketry.logger.error("Cannot save advanced rocketry planet files, you may be able to find backups in " + net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory());
            e.printStackTrace();
        }
    }

    @Override
    public boolean isDimensionCreated(int dimId) {
        return this.dimensionList.containsKey(new Integer(dimId)) || dimId == ARConfiguration.getCurrentConfig().spaceDimId;
    }

    private List<DimensionProperties> generateRandomPlanets(StellarBody star, int numRandomGeneratedPlanets, int numRandomGeneratedGasGiants) {
        DimensionProperties moonProperties;
        int ii;
        int numMoons;
        DimensionProperties properties;
        int baseDistance;
        int baseAtm;
        int i;
        LinkedList<DimensionProperties> dimPropList = new LinkedList<DimensionProperties>();
        Random random = new Random(System.currentTimeMillis());
        for (i = 0; i < numRandomGeneratedGasGiants; ++i) {
            baseAtm = 180;
            baseDistance = 100;
            properties = DimensionManager.getInstance().generateRandomGasGiant(star.getId(), "", baseDistance + 50, baseAtm, 125, 100, 100, 75);
            dimPropList.add(properties);
            if (!(properties.gravitationalMultiplier >= 1.0f)) continue;
            numMoons = random.nextInt(8);
            for (ii = 0; ii < numMoons; ++ii) {
                moonProperties = DimensionManager.getInstance().generateRandom(star.getId(), properties.getName() + ": " + ii, 25, 100, (int)(properties.gravitationalMultiplier / 0.02f), 25, 100, 50);
                if (moonProperties == null) continue;
                dimPropList.add(moonProperties);
                moonProperties.setParentPlanet(properties);
                star.removePlanet(moonProperties);
            }
        }
        for (i = 0; i < numRandomGeneratedPlanets; ++i) {
            baseAtm = 75;
            baseDistance = 100;
            if (i % 4 == 0) {
                baseAtm = 0;
            } else if (i != 6 && (i + 2) % 4 == 0) {
                baseAtm = 120;
            }
            if (i % 3 == 0) {
                baseDistance = 170;
            } else if ((i + 1) % 3 == 0) {
                baseDistance = 30;
            }
            properties = DimensionManager.getInstance().generateRandom(star.getId(), baseDistance, baseAtm, 125, 100, 100, 75);
            if (properties == null) continue;
            dimPropList.add(properties);
            if (!(properties.gravitationalMultiplier >= 1.0f)) continue;
            numMoons = random.nextInt(4);
            for (ii = 0; ii < numMoons; ++ii) {
                moonProperties = DimensionManager.getInstance().generateRandom(star.getId(), properties.getName() + ": " + ii, 25, 100, (int)(properties.gravitationalMultiplier / 0.02f), 25, 100, 50);
                if (moonProperties == null) continue;
                dimPropList.add(moonProperties);
                moonProperties.setParentPlanet(properties);
                star.removePlanet(moonProperties);
            }
        }
        return dimPropList;
    }

    public void createAndLoadDimensions(boolean resetFromXml) {
        Map<Integer, IDimensionProperties> loadedPlanets;
        File file;
        int dimOffset = DimensionManager.dimOffset;
        XMLPlanetLoader.DimensionPropertyCoupling dimCouplingList = null;
        XMLPlanetLoader loader = null;
        boolean loadedFromXML = false;
        File localFile = file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory() + "/" + workingPath + worldXML);
        logger.info("Checking for config at " + file.getAbsolutePath());
        if (!file.exists() || resetFromXml) {
            String newFilePath = "./config/advRocketry/planetDefs.xml";
            if (!file.exists()) {
                logger.info("File not found.  Now checking for config at " + newFilePath);
            }
            if ((file = new File(newFilePath)).exists()) {
                logger.info("Advanced Planet Config file Found!  Copying to world specific directory");
                try {
                    File dir = new File(localFile.getAbsolutePath().substring(0, localFile.getAbsolutePath().length() - localFile.getName().length()));
                    if ((dir.exists() || dir.mkdir()) && localFile.createNewFile()) {
                        char[] buffer = new char[1024];
                        FileReader reader = new FileReader(file);
                        FileWriter writer = new FileWriter(localFile);
                        int numChars = 0;
                        while ((numChars = reader.read(buffer)) > 0) {
                            writer.write(buffer, 0, numChars);
                        }
                        reader.close();
                        writer.close();
                        logger.info("Copy success!");
                    } else {
                        logger.warn("Unable to create file " + localFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    logger.warn("Unable to write file " + localFile.getAbsolutePath());
                }
            }
        }
        if (file.exists()) {
            logger.info("Advanced Planet Config file Found!  Loading from file.");
            loader = new XMLPlanetLoader();
            try {
                loader.loadFile(file);
                if (!loader.isValid()) {
                    throw new Exception("Cannot read XML");
                }
                dimCouplingList = loader.readAllPlanets();
                DimensionManager.dimOffset += dimCouplingList.dims.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.fatal("A serious error has occured while loading the planetDefs XML");
                FMLCommonHandler.instance().exitJava(-1, false);
            }
        }
        if ((loadedPlanets = this.loadDimensions(workingPath)).isEmpty()) {
            int numRandomGeneratedPlanets = 9;
            int numRandomGeneratedGasGiants = 1;
            if (dimCouplingList != null) {
                logger.info("Loading initial planet config!");
                for (StellarBody star : dimCouplingList.stars) {
                    DimensionManager.getInstance().addStar(star);
                }
                for (DimensionProperties properties : dimCouplingList.dims) {
                    DimensionManager.getInstance().registerDimNoUpdate(properties, properties.isNativeDimension);
                    properties.setStar(properties.getStarId());
                }
                for (StellarBody star : dimCouplingList.stars) {
                    numRandomGeneratedPlanets = loader.getMaxNumPlanets(star);
                    numRandomGeneratedGasGiants = loader.getMaxNumGasGiants(star);
                    dimCouplingList.dims.addAll(this.generateRandomPlanets(star, numRandomGeneratedPlanets, numRandomGeneratedGasGiants));
                }
                loadedFromXML = true;
            }
            if (!loadedFromXML) {
                StellarBody star;
                StellarBody sol = new StellarBody();
                sol.setTemperature(100);
                sol.setId(0);
                sol.setName("Sol");
                DimensionManager.getInstance().addStar(sol);
                DimensionManager.getInstance().registerDimNoUpdate(overworldProperties, false);
                sol.addPlanet(overworldProperties);
                if (ARConfiguration.getCurrentConfig().MoonId == -2147483647) {
                    ARConfiguration.getCurrentConfig().MoonId = DimensionManager.getInstance().getNextFreeDim(dimOffset);
                }
                if (ARConfiguration.getCurrentConfig().MoonId != -2147483647) {
                    DimensionProperties dimensionProperties = new DimensionProperties(ARConfiguration.getCurrentConfig().MoonId);
                    dimensionProperties.setAtmosphereDensityDirect(0);
                    dimensionProperties.averageTemperature = 20;
                    dimensionProperties.rotationalPeriod = 128000;
                    dimensionProperties.gravitationalMultiplier = 0.166f;
                    dimensionProperties.setName("Luna");
                    dimensionProperties.orbitalDist = 150;
                    dimensionProperties.addBiome(AdvancedRocketryBiomes.moonBiome);
                    dimensionProperties.addBiome(AdvancedRocketryBiomes.moonBiomeDark);
                    dimensionProperties.setParentPlanet(overworldProperties);
                    dimensionProperties.setStar(DimensionManager.getSol());
                    dimensionProperties.isNativeDimension = !Loader.isModLoaded((String)"GalacticraftCore");
                    dimensionProperties.initDefaultAttributes();
                    DimensionManager.getInstance().registerDimNoUpdate(dimensionProperties, !Loader.isModLoaded((String)"GalacticraftCore"));
                }
                this.generateRandomPlanets(DimensionManager.getSol(), numRandomGeneratedPlanets, numRandomGeneratedGasGiants);
                star = new StellarBody();
                star.setTemperature(10);
                star.setPosX(300);
                star.setPosZ(-200);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Wolf 12");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 5, 0);
                star = new StellarBody();
                star.setTemperature(170);
                star.setPosX(-200);
                star.setPosZ(80);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Epsilon ire");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 7, 0);
                star = new StellarBody();
                star.setTemperature(200);
                star.setPosX(-150);
                star.setPosZ(250);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Proxima Centaurs");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 3, 0);
                star = new StellarBody();
                star.setTemperature(70);
                star.setPosX(-150);
                star.setPosZ(-250);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Magnis Vulpes");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 2, 0);
                star = new StellarBody();
                star.setTemperature(200);
                star.setPosX(50);
                star.setPosZ(-250);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Ma-Roo");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 6, 0);
                star = new StellarBody();
                star.setTemperature(120);
                star.setPosX(75);
                star.setPosZ(200);
                star.setId(DimensionManager.getInstance().getNextFreeStarId());
                star.setName("Alykitt");
                DimensionManager.getInstance().addStar(star);
                this.generateRandomPlanets(star, 3, 1);
            }
        } else {
            VersionCompat.upgradeDimensionManagerPostLoad(prevBuild);
        }
        if (dimCouplingList != null) {
            for (StellarBody star : dimCouplingList.stars) {
                if (DimensionManager.getInstance().getStar(star.getId()) == null) {
                    DimensionManager.getInstance().addStar(star);
                }
                DimensionManager.getInstance().getStar(star.getId()).setName(star.getName());
                DimensionManager.getInstance().getStar(star.getId()).setPosX(star.getPosX());
                DimensionManager.getInstance().getStar(star.getId()).setPosZ(star.getPosZ());
                DimensionManager.getInstance().getStar(star.getId()).setSize(star.getSize());
                DimensionManager.getInstance().getStar(star.getId()).setTemperature(star.getTemperature());
                DimensionManager.getInstance().getStar((int)star.getId()).subStars = star.subStars;
                DimensionManager.getInstance().getStar(star.getId()).setBlackHole(star.isBlackHole());
            }
            for (DimensionProperties properties : dimCouplingList.dims) {
                DimensionProperties loadedProps;
                DimensionProperties loadedDim;
                if (!properties.isNativeDimension && properties.getStar() != null && !DimensionManager.getInstance().isDimensionCreated(properties.getId())) {
                    for (StellarBody star : dimCouplingList.stars) {
                        for (StellarBody loadedStar : DimensionManager.getInstance().getStars()) {
                            if (star.getId() != properties.getStarId() || !star.getName().equals(loadedStar.getName())) continue;
                            DimensionManager.getInstance().registerDimNoUpdate(properties, false);
                            properties.setStar(loadedStar);
                        }
                    }
                }
                if (loadedPlanets.containsKey(properties.getId()) && (loadedDim = (DimensionProperties)loadedPlanets.get(properties.getId())) != null) {
                    properties.copySatellites(loadedDim);
                    properties.copyTerraformedBiomes(loadedDim);
                }
                if (properties.isNativeDimension) {
                    DimensionManager.getInstance().registerDim(properties, properties.isNativeDimension);
                }
                if (!properties.customIcon.isEmpty() && DimensionManager.getInstance().isDimensionCreated(properties.getId())) {
                    loadedProps = DimensionManager.getInstance().getDimensionProperties(properties.getId());
                    loadedProps.customIcon = properties.customIcon;
                }
                if (DimensionManager.getInstance().isDimensionCreated(properties.getId())) {
                    loadedProps = DimensionManager.getInstance().getDimensionProperties(properties.getId());
                    LinkedList<ItemStack> list = new LinkedList<ItemStack>(properties.getRequiredArtifacts());
                    loadedProps.getRequiredArtifacts().clear();
                    loadedProps.getRequiredArtifacts().addAll(list);
                    LinkedList<SpawnListEntryNBT> list2 = new LinkedList<SpawnListEntryNBT>(properties.getSpawnListEntries());
                    loadedProps.getSpawnListEntries().clear();
                    loadedProps.getSpawnListEntries().addAll(list2);
                }
                if (properties.oreProperties == null || (loadedProps = DimensionManager.getInstance().getDimensionProperties(properties.getId())) == null) continue;
                loadedProps.oreProperties = properties.oreProperties;
            }
            if (!loadedFromXML) {
                for (StellarBody star : dimCouplingList.stars) {
                    int numRandomGeneratedPlanets = loader.getMaxNumPlanets(star);
                    int numRandomGeneratedGasGiants = loader.getMaxNumGasGiants(star);
                    this.generateRandomPlanets(star, numRandomGeneratedPlanets, numRandomGeneratedGasGiants);
                }
            }
        }
        DimensionManager.dimOffset = dimOffset;
        DimensionManager.getInstance().knownPlanets.addAll(ARConfiguration.getCurrentConfig().initiallyKnownPlanets);
        for (ISpaceObject i : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            int orbitingId = i.getOrbitingPlanetId();
            if (this.isDimensionCreated(orbitingId) || orbitingId == 0 || orbitingId == Integer.MIN_VALUE || orbitingId >= 10000) continue;
            AdvancedRocketry.logger.warn("Dimension ID " + i.getOrbitingPlanetId() + " is not registered and a space station is orbiting it, moving to dimid 0");
            i.setOrbitingBody(0);
        }
    }

    public Map<Integer, IDimensionProperties> loadDimensions(String filePath) {
        NBTTagCompound nbt;
        this.hasBeenInitiallized = true;
        HashMap<Integer, IDimensionProperties> loadedDimProps = new HashMap<Integer, IDimensionProperties>();
        try {
            File file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), filePath + tempFile);
            if (!file.exists()) {
                new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - file.getName().length())).mkdirs();
                file.createNewFile();
                return loadedDimProps;
            }
            FileInputStream inStream = new FileInputStream(file);
            nbt = CompressedStreamTools.func_74796_a((InputStream)inStream);
            inStream.close();
        }
        catch (EOFException e) {
            return loadedDimProps;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return loadedDimProps;
        }
        catch (IOException e) {
            e.printStackTrace();
            return loadedDimProps;
        }
        NBTTagCompound solarSystem = nbt.func_74775_l("starSystems");
        if (solarSystem.func_82582_d()) {
            return loadedDimProps;
        }
        NBTTagCompound stats = nbt.func_74775_l("stat");
        hasReachedMoon = stats.func_74767_n("hasReachedMoon");
        hasReachedWarp = stats.func_74767_n("hasReachedWarp");
        for (Object key : solarSystem.func_150296_c()) {
            NBTTagCompound solarNBT = solarSystem.func_74775_l((String)key);
            StellarBody star = new StellarBody();
            star.readFromNBT(solarNBT);
            this.starList.put(star.getId(), star);
        }
        nbt.func_74782_a("starSystems", (NBTBase)solarSystem);
        nextSatelliteId = nbt.func_74763_f("nextSatelliteId");
        NBTTagCompound dimListNbt = nbt.func_74775_l("dimList");
        for (Object key : dimListNbt.func_150296_c()) {
            String keyString = (String)key;
            DimensionProperties propeties = DimensionProperties.createFromNBT(Integer.parseInt(keyString), dimListNbt.func_74775_l(keyString));
            if (propeties != null) {
                int keyInt = Integer.parseInt(keyString);
                loadedDimProps.put(new Integer(keyInt), propeties);
                continue;
            }
            logger.warn("Null Dimension Properties Recieved");
        }
        if (nbt.func_74764_b("spaceObjects")) {
            NBTTagCompound nbtTag = nbt.func_74775_l("spaceObjects");
            SpaceObjectManager.getSpaceManager().readFromNBT(nbtTag);
        }
        prevBuild = nbt.func_74779_i("prevVersion");
        nbt.func_74778_a("prevVersion", "1.7.0-209");
        return loadedDimProps;
    }

    @Override
    public boolean areDimensionsInSamePlanetMoonSystem(int destinationDimId, int dimension) {
        if (dimension == Integer.MIN_VALUE || destinationDimId == Integer.MIN_VALUE) {
            return false;
        }
        DimensionProperties properties = this.getDimensionProperties(dimension);
        DimensionProperties properties2 = this.getDimensionProperties(destinationDimId);
        while (properties.getParentProperties() != null) {
            properties = properties.getParentProperties();
        }
        while (properties2.getParentProperties() != null) {
            properties2 = properties2.getParentProperties();
        }
        return this.areDimensionsInSamePlanetMoonSystem(properties, destinationDimId) || this.areDimensionsInSamePlanetMoonSystem(properties2, dimension);
    }

    private boolean areDimensionsInSamePlanetMoonSystem(DimensionProperties properties, int id) {
        if (properties.getId() == id) {
            return true;
        }
        for (int child : properties.getChildPlanets()) {
            if (!this.areDimensionsInSamePlanetMoonSystem(this.getDimensionProperties(child), id)) continue;
            return true;
        }
        return false;
    }

    public static DimensionProperties getEffectiveDimId(int dimId, BlockPos pos) {
        if (dimId == ARConfiguration.getCurrentConfig().spaceDimId) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
            if (obj != null) {
                return (DimensionProperties)obj.getProperties().getParentProperties();
            }
            return defaultSpaceDimensionProperties;
        }
        return DimensionManager.getInstance().getDimensionProperties(dimId);
    }

    public static DimensionProperties getEffectiveDimId(World world, BlockPos pos) {
        int dimId = world.field_73011_w.getDimension();
        if (dimId == ARConfiguration.getCurrentConfig().spaceDimId) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
            if (obj != null) {
                return (DimensionProperties)obj.getProperties().getParentProperties();
            }
            return defaultSpaceDimensionProperties;
        }
        return DimensionManager.getInstance().getDimensionProperties(dimId);
    }

    static {
        AdvancedRocketryAPI.dimensionManager = new DimensionManager();
        instance = AdvancedRocketryAPI.dimensionManager;
        dimOffset = 0;
        PlanetDimensionType = DimensionType.register((String)"planet", (String)"planet", (int)2, WorldProviderPlanet.class, (boolean)false);
        spaceDimensionType = DimensionType.register((String)"space", (String)"space", (int)3, WorldProviderSpace.class, (boolean)false);
        AsteroidDimensionType = DimensionType.register((String)"asteroid", (String)"asteroid", (int)4, WorldProviderAsteroid.class, (boolean)false);
    }
}

