/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.lang3.ArrayUtils;
import scala.util.Random;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.VulpineMath;
import zmaster587.libVulpes.util.ZUtils;

public class DimensionProperties
implements Cloneable,
IDimensionProperties {
    public static final ResourceLocation atmosphere = new ResourceLocation("advancedrocketry:textures/planets/Atmosphere2.png");
    public static final ResourceLocation atmosphereLEO = new ResourceLocation("advancedrocketry:textures/planets/AtmosphereLEO.png");
    public static final ResourceLocation atmGlow = new ResourceLocation("advancedrocketry:textures/planets/atmGlow.png");
    public static final ResourceLocation planetRings = new ResourceLocation("advancedrocketry:textures/planets/rings.png");
    public static final ResourceLocation planetRingShadow = new ResourceLocation("advancedrocketry:textures/planets/ringShadow.png");
    public static final ResourceLocation shadow = new ResourceLocation("advancedrocketry:textures/planets/shadow.png");
    public static final ResourceLocation shadow3 = new ResourceLocation("advancedrocketry:textures/planets/shadow3.png");
    public static final int MAX_ATM_PRESSURE = 1600;
    public static final int MIN_ATM_PRESSURE = 0;
    public static final int MAX_DISTANCE = 200;
    public static final int MIN_DISTANCE = 0;
    public static final int MAX_GRAVITY = 200;
    public static final int MIN_GRAVITY = 0;
    public boolean isNativeDimension;
    public float[] skyColor;
    public float[] fogColor;
    public float[] ringColor;
    public float gravitationalMultiplier;
    public int orbitalDist;
    private int originalAtmosphereDensity;
    private int atmosphereDensity;
    public int averageTemperature;
    public int rotationalPeriod;
    public double orbitTheta;
    public double prevOrbitalTheta;
    public double orbitalPhi;
    public double rotationalPhi;
    public OreGenProperties oreProperties = null;
    public String customIcon;
    IAtmosphere atmosphereType;
    StellarBody star;
    int starId;
    private String name = "Temp";
    public float[] sunriseSunsetColors;
    private LinkedList<BiomeManager.BiomeEntry> allowedBiomes;
    private LinkedList<BiomeManager.BiomeEntry> terraformedBiomes;
    private boolean isRegistered = false;
    private boolean isTerraformed = false;
    public boolean hasRings = false;
    public List<ItemStack> requiredArtifacts;
    private HashSet<Integer> childPlanets;
    private int parentPlanet;
    private int planetId;
    private boolean isStation;
    private boolean isGasGiant;
    private boolean canGenerateCraters;
    private boolean generateCratersSet;
    private boolean canGenerateGeodes;
    private boolean generateGeodesSet;
    private boolean canGenerateVolcanos;
    private boolean generateVolcanosSet;
    private boolean canGenerateStructures;
    private boolean generateStructuresSet;
    private float craterFrequencyMultiplier;
    private float volcanoFrequencyMultiplier;
    private float geodeFrequencyMultiplier;
    private HashMap<Long, SatelliteBase> satallites;
    private HashMap<Long, SatelliteBase> tickingSatallites;
    private List<Fluid> harvestableAtmosphere;
    private List<SpawnListEntryNBT> spawnableEntities;
    private HashSet<HashedBlockPosition> beaconLocations;
    private IBlockState oceanBlock;
    private IBlockState fillerBlock;
    private int sealevel;
    private int generatorType;

    public DimensionProperties(int id) {
        this.resetProperties();
        this.planetId = id;
        this.parentPlanet = -2147483647;
        this.childPlanets = new HashSet();
        this.orbitalPhi = 0.0;
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.oceanBlock = null;
        this.fillerBlock = null;
        this.allowedBiomes = new LinkedList();
        this.terraformedBiomes = new LinkedList();
        this.satallites = new HashMap();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.tickingSatallites = new HashMap();
        this.isNativeDimension = true;
        this.isGasGiant = false;
        this.hasRings = false;
        this.canGenerateCraters = false;
        this.canGenerateGeodes = false;
        this.canGenerateStructures = false;
        this.canGenerateVolcanos = false;
        this.generateCratersSet = false;
        this.generateGeodesSet = false;
        this.generateVolcanosSet = false;
        this.generateStructuresSet = false;
        this.craterFrequencyMultiplier = 1.0f;
        this.volcanoFrequencyMultiplier = 1.0f;
        this.geodeFrequencyMultiplier = 1.0f;
        this.customIcon = "";
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.spawnableEntities = new LinkedList<SpawnListEntryNBT>();
        this.beaconLocations = new HashSet();
        this.sealevel = 63;
        this.generatorType = 0;
    }

    public DimensionProperties(int id, String name) {
        this(id);
        this.name = name;
    }

    public DimensionProperties(int id, boolean shouldRegister) {
        this(id);
        this.isStation = !shouldRegister;
    }

    public void copySatellites(DimensionProperties props) {
        this.satallites = props.satallites;
    }

    public void copyTerraformedBiomes(DimensionProperties props) {
        this.terraformedBiomes = props.terraformedBiomes;
        this.isTerraformed = props.isTerraformed;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public OreGenProperties getOreGenProperties(World world) {
        if (this.oreProperties != null) {
            return this.oreProperties;
        }
        return OreGenProperties.getOresForPressure(AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity), Temps.getTempFromValue(this.getAverageTemp()));
    }

    public void resetProperties() {
        this.fogColor = new float[]{1.0f, 1.0f, 1.0f};
        this.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        this.sunriseSunsetColors = new float[]{0.7f, 0.2f, 0.2f, 1.0f};
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.gravitationalMultiplier = 1.0f;
        this.rotationalPeriod = 24000;
        this.orbitalDist = 100;
        this.atmosphereDensity = 100;
        this.originalAtmosphereDensity = 100;
        this.childPlanets = new HashSet();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.parentPlanet = -2147483647;
        this.starId = 0;
        this.averageTemperature = 100;
        this.hasRings = false;
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.spawnableEntities = new LinkedList<SpawnListEntryNBT>();
        this.beaconLocations = new HashSet();
        this.sealevel = 63;
        this.oceanBlock = null;
        this.fillerBlock = null;
        this.generatorType = 0;
    }

    public List<Fluid> getHarvestableGasses() {
        return this.harvestableAtmosphere;
    }

    public List<ItemStack> getRequiredArtifacts() {
        return this.requiredArtifacts;
    }

    @Override
    public float getGravitationalMultiplier() {
        return this.gravitationalMultiplier;
    }

    @Override
    public void setGravitationalMultiplier(float mult) {
        this.gravitationalMultiplier = mult;
    }

    public List<SpawnListEntryNBT> getSpawnListEntries() {
        return this.spawnableEntities;
    }

    @Override
    public float[] getSunColor() {
        return this.getStar().getColor();
    }

    public void setStar(StellarBody star) {
        this.starId = star.getId();
        this.star = star;
        if (!this.isMoon() && !this.isStation()) {
            this.star.addPlanet(this);
        }
    }

    public void setStar(int id) {
        this.starId = id;
        if (DimensionManager.getInstance().getStar(id) != null) {
            this.setStar(DimensionManager.getInstance().getStar(id));
        }
    }

    @Override
    public StellarBody getStar() {
        if (this.isStar()) {
            return this.getStarData();
        }
        if (this.star == null) {
            this.star = DimensionManager.getInstance().getStar(this.starId);
        }
        return this.star;
    }

    public boolean hasSurface() {
        return !this.isGasGiant() && !this.isStar();
    }

    @Override
    public boolean isGasGiant() {
        return this.isGasGiant;
    }

    public boolean isStar() {
        return this.planetId >= 10000;
    }

    public StellarBody getStarData() {
        return DimensionManager.getInstance().getStar(this.planetId - 10000);
    }

    public void setGasGiant(boolean gas) {
        this.isGasGiant = gas;
    }

    @Override
    public boolean hasRings() {
        return this.hasRings;
    }

    public void setHasRings(boolean value) {
        this.hasRings = value;
    }

    public void addBeaconLocation(World world, HashedBlockPosition pos) {
        this.beaconLocations.add(pos);
        DimensionManager.getInstance().knownPlanets.add(this.getId());
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    public HashSet<HashedBlockPosition> getBeacons() {
        return this.beaconLocations;
    }

    public void removeBeaconLocation(World world, HashedBlockPosition pos) {
        this.beaconLocations.remove(pos);
        if (this.beaconLocations.isEmpty() && !ARConfiguration.getCurrentConfig().initiallyKnownPlanets.contains(this.getId())) {
            DimensionManager.getInstance().knownPlanets.remove(this.getId());
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    @Override
    public ResourceLocation getPlanetIcon() {
        if (!this.customIcon.isEmpty()) {
            try {
                String resource_location = "advancedrocketry:textures/planets/" + this.customIcon.toLowerCase() + ".png";
                if (TextureResources.planetResources.containsKey(resource_location)) {
                    return TextureResources.planetResources.get(resource_location);
                }
                ResourceLocation new_resource = new ResourceLocation(resource_location);
                TextureResources.planetResources.put(resource_location, new_resource);
                return new_resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.getAverageTemp());
        if (this.isStar() && this.getStarData().isBlackHole()) {
            return TextureResources.locationBlackHole_icon;
        }
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resource;
        }
        if (this.isAsteroid()) {
            return PlanetIcons.ASTEROID.resource;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resource;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resource;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resource;
            }
            return PlanetIcons.ICEWORLD.resource;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resource;
            }
            return PlanetIcons.MOON.resource;
        }
        return PlanetIcons.LAVA.resource;
    }

    @Override
    public ResourceLocation getPlanetIconLEO() {
        if (!this.customIcon.isEmpty()) {
            try {
                String resource_location = "advancedrocketry:textures/planets/" + this.customIcon.toLowerCase() + "leo.jpg";
                if (TextureResources.planetResources.containsKey(resource_location)) {
                    return TextureResources.planetResources.get(resource_location);
                }
                ResourceLocation new_resource = new ResourceLocation(resource_location);
                TextureResources.planetResources.put(resource_location, new_resource);
                return new_resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.getAverageTemp());
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resourceLEO;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resourceLEO;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resourceLEO;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resourceLEO;
            }
            return PlanetIcons.ICEWORLD.resourceLEO;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resourceLEO;
            }
            return PlanetIcons.MOON.resourceLEO;
        }
        return PlanetIcons.LAVA.resourceLEO;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getId() {
        return this.planetId;
    }

    @Override
    public int getParentPlanet() {
        return this.parentPlanet;
    }

    @Override
    public DimensionProperties getParentProperties() {
        if (this.parentPlanet != -2147483647) {
            return DimensionManager.getInstance().getDimensionProperties(this.parentPlanet);
        }
        return null;
    }

    @Override
    public int getParentOrbitalDistance() {
        return this.orbitalDist;
    }

    @Override
    public int getSolarOrbitalDistance() {
        if (this.parentPlanet != -2147483647) {
            return this.getParentProperties().getSolarOrbitalDistance();
        }
        return this.orbitalDist;
    }

    public double getSolarTheta() {
        if (this.parentPlanet != -2147483647) {
            return this.getParentProperties().getSolarTheta();
        }
        return this.orbitTheta;
    }

    public void setParentPlanet(DimensionProperties parent) {
        this.setParentPlanet(parent, true);
    }

    public void setParentPlanet(DimensionProperties parent, boolean update) {
        if (update) {
            if (this.parentPlanet != -2147483647) {
                this.getParentProperties().childPlanets.remove(new Integer(this.getId()));
            }
            if (parent == null) {
                this.parentPlanet = -2147483647;
            } else {
                this.parentPlanet = parent.getId();
                this.star = parent.getStar();
                if (parent.getId() != -2147483647) {
                    parent.childPlanets.add(this.getId());
                }
            }
        } else if (parent == null) {
            this.parentPlanet = -2147483647;
        } else {
            this.star = parent.getStar();
            this.starId = this.star.getId();
            this.parentPlanet = parent.getId();
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.childPlanets.isEmpty();
    }

    @Override
    public boolean isMoon() {
        return this.parentPlanet != -2147483647 && this.parentPlanet != Integer.MIN_VALUE;
    }

    @Override
    public boolean isTerraformed() {
        return this.isTerraformed;
    }

    @Override
    public int getAtmosphereDensity() {
        return this.atmosphereDensity;
    }

    @Override
    public void setAtmosphereDensity(int atmosphereDensity) {
        int prevAtm = this.atmosphereDensity;
        this.atmosphereDensity = atmosphereDensity;
        if (AtmosphereTypes.getAtmosphereTypeFromValue(prevAtm) != AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity)) {
            this.setTerraformedBiomes(this.getViableBiomes());
            this.isTerraformed = true;
            ((ChunkManagerPlanet)((WorldProviderPlanet)net.minecraftforge.common.DimensionManager.getProvider((int)this.getId())).chunkMgrTerraformed).resetCache();
        }
        PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
    }

    public void setAtmosphereDensityDirect(int atmosphereDensity) {
        this.originalAtmosphereDensity = this.atmosphereDensity = atmosphereDensity;
    }

    public boolean isStation() {
        return this.isStation;
    }

    @Override
    public IAtmosphere getAtmosphere() {
        if (this.hasAtmosphere()) {
            if (Temps.getTempFromValue(this.getAverageTemp()) == Temps.TOOHOT) {
                return AtmosphereType.VERYHOT;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.SUPERHIGHPRESSURE) {
                return AtmosphereType.SUPERHIGHPRESSURE;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.HIGHPRESSURE) {
                return AtmosphereType.HIGHPRESSURE;
            }
            return AtmosphereType.AIR;
        }
        return AtmosphereType.VACUUM;
    }

    public static ResourceLocation getAtmosphereResource() {
        return atmosphere;
    }

    public static ResourceLocation getShadowResource() {
        return shadow;
    }

    public static ResourceLocation getAtmosphereLEOResource() {
        return atmosphereLEO;
    }

    @Override
    public boolean hasAtmosphere() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity).compareTo(AtmosphereTypes.NONE) < 0;
    }

    public boolean isAsteroid() {
        return this.generatorType == 2;
    }

    public boolean hasDecorators() {
        return !this.isAsteroid() && !this.isStar();
    }

    @Override
    public Set<Integer> getChildPlanets() {
        return this.childPlanets;
    }

    @Override
    public int getPathLengthToStar() {
        if (this.isMoon()) {
            return 1 + this.getParentProperties().getPathLengthToStar();
        }
        return 1;
    }

    public boolean addChildPlanet(DimensionProperties child) {
        if (child == this) {
            return false;
        }
        this.childPlanets.add(child.getId());
        child.setParentPlanet(this);
        return true;
    }

    public void removeChild(int id) {
        this.childPlanets.remove(id);
    }

    @Override
    public void addSatallite(SatelliteBase satellite, World world) {
        if (this.satallites.containsKey(satellite.getId())) {
            this.satallites.remove(satellite.getId());
            this.tickingSatallites.remove(satellite.getId());
        }
        this.satallites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatallites.put(satellite.getId(), satellite);
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    public void addSatallite(SatelliteBase satellite, int world, boolean isRemote) {
        if (this.satallites.containsKey(satellite.getId())) {
            this.satallites.remove(satellite.getId());
            this.tickingSatallites.remove(satellite.getId());
        }
        this.satallites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatallites.put(satellite.getId(), satellite);
        }
        if (!isRemote) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    @Override
    public void addSatallite(SatelliteBase satallite) {
        if (this.satallites.containsKey(satallite.getId())) {
            this.satallites.remove(satallite.getId());
            this.tickingSatallites.remove(satallite.getId());
        }
        this.satallites.put(satallite.getId(), satallite);
        if (satallite.canTick()) {
            this.tickingSatallites.put(satallite.getId(), satallite);
        }
    }

    @Override
    public SatelliteBase removeSatellite(long satalliteId) {
        SatelliteBase satallite = this.satallites.remove(satalliteId);
        if (satallite != null && satallite.canTick() && this.tickingSatallites.containsKey(satalliteId)) {
            this.tickingSatallites.get(satalliteId).setDead();
        }
        return satallite;
    }

    @Override
    public SatelliteBase getSatellite(long id) {
        return this.satallites.get(id);
    }

    public void tick() {
        Iterator<SatelliteBase> iterator = this.tickingSatallites.values().iterator();
        while (iterator.hasNext()) {
            SatelliteBase satallite = iterator.next();
            satallite.tickEntity();
            if (!satallite.isDead()) continue;
            iterator.remove();
            this.satallites.remove(satallite.getId());
        }
        this.updateOrbit();
    }

    public void updateOrbit() {
        this.prevOrbitalTheta = this.orbitTheta;
        this.orbitTheta = (double)(AdvancedRocketry.proxy.getWorldTimeUniversal(0) * (long)(201 - this.orbitalDist)) * 2.0E-6 % (Math.PI * 2);
    }

    public boolean hasRivers() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity).compareTo(AtmosphereTypes.LOW) <= 0 && Temps.getTempFromValue(this.getAverageTemp()).isInRange(Temps.COLD, Temps.HOT);
    }

    public List<BiomeManager.BiomeEntry> getBiomes() {
        return this.allowedBiomes;
    }

    public List<BiomeManager.BiomeEntry> getTerraformedBiomes() {
        return this.terraformedBiomes;
    }

    public boolean isBiomeblackListed(Biome biome) {
        return AdvancedRocketryBiomes.instance.getBlackListedBiomes().contains(Biome.func_185362_a((Biome)biome));
    }

    public List<Biome> getViableBiomes() {
        Random random = new Random(System.nanoTime());
        ArrayList<Biome> viableBiomes = new ArrayList<Biome>();
        if (this.atmosphereDensity > AtmosphereTypes.LOW.value && random.nextInt(3) == 0) {
            LinkedList<Biome> list = new LinkedList<Biome>(AdvancedRocketryBiomes.instance.getSingleBiome());
            while (list.size() > 1) {
                Biome biome = (Biome)list.get(random.nextInt(list.size()));
                Temps temp = Temps.getTempFromValue(this.averageTemperature);
                if (biome.func_150561_m() == Biome.TempCategory.COLD && temp.isInRange(Temps.FRIGID, Temps.NORMAL) || (biome.func_150561_m() == Biome.TempCategory.MEDIUM || biome.func_150561_m() == Biome.TempCategory.OCEAN) && temp.isInRange(Temps.COLD, Temps.HOT) || biome.func_150561_m() == Biome.TempCategory.WARM && temp.isInRange(Temps.NORMAL, Temps.HOT)) {
                    viableBiomes.add(biome);
                    return viableBiomes;
                }
                list.remove(biome);
            }
        }
        if (this.atmosphereDensity <= AtmosphereTypes.LOW.value) {
            viableBiomes.add(AdvancedRocketryBiomes.moonBiome);
            viableBiomes.add(AdvancedRocketryBiomes.moonBiomeDark);
        } else if (this.averageTemperature > Temps.TOOHOT.getTemp()) {
            viableBiomes.add(AdvancedRocketryBiomes.hotDryBiome);
            viableBiomes.add(AdvancedRocketryBiomes.volcanic);
            viableBiomes.add(AdvancedRocketryBiomes.volcanicBarren);
        } else if (this.averageTemperature > Temps.HOT.getTemp()) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HOT) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.OCEAN) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        } else if (this.averageTemperature > Temps.NORMAL.getTemp()) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
            viableBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        } else if (this.averageTemperature > Temps.COLD.getTemp()) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HOT) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
            viableBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        } else if (this.averageTemperature > Temps.FRIGID.getTemp()) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        } else {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        }
        if (viableBiomes.size() > 5) {
            viableBiomes = ZUtils.copyRandomElements(viableBiomes, (int)5);
        }
        if (this.atmosphereDensity > AtmosphereTypes.HIGHPRESSURE.value && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.NORMAL, Temps.HOT)) {
            viableBiomes.addAll(AdvancedRocketryBiomes.instance.getHighPressureBiomes());
        }
        return viableBiomes;
    }

    public void addBiome(Biome biome) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        biomes.add(biome);
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public boolean addBiome(int biomeId) {
        Biome biome = Biome.func_150568_d((int)biomeId);
        if (biomeId == 0 || Biome.func_185362_a((Biome)biome) != 0) {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            biomes.add(biome);
            this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
            return true;
        }
        return false;
    }

    public void addBiomes(List<Biome> biomes) {
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public void setBiomes(List<Biome> biomes) {
        this.allowedBiomes.clear();
        this.addBiomes(biomes);
    }

    public void setBiomeEntries(List<BiomeManager.BiomeEntry> biomes) {
        if (biomes != this.allowedBiomes) {
            this.allowedBiomes.clear();
            this.allowedBiomes.addAll(biomes);
        }
    }

    public void setTerraformedBiomes(List<Biome> biomes) {
        this.terraformedBiomes.clear();
        this.terraformedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public void addBiomeType(BiomeDictionary.Type type) {
        ArrayList<Biome> entryList = new ArrayList<Biome>();
        entryList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        entryList.remove(Biome.func_150568_d((int)8));
        entryList.remove(Biome.func_150568_d((int)9));
        Iterator iter = entryList.iterator();
        while (iter.hasNext()) {
            Biome nextbiome = (Biome)iter.next();
            for (BiomeManager.BiomeEntry entry : this.allowedBiomes) {
                if (!BiomeDictionary.areSimilar((Biome)entry.biome, (Biome)nextbiome)) continue;
                iter.remove();
            }
        }
        this.allowedBiomes.addAll(this.getBiomesEntries(entryList));
    }

    public void removeBiomeType(BiomeDictionary.Type type) {
        ArrayList entryList = new ArrayList();
        entryList.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        for (Biome biome : Biome.field_185377_q) {
            Iterator iterator = this.allowedBiomes.iterator();
            while (iterator.hasNext()) {
                if (!BiomeDictionary.areSimilar((Biome)((BiomeManager.BiomeEntry)iterator.next()).biome, (Biome)biome)) continue;
                iterator.remove();
            }
        }
    }

    private ArrayList<BiomeManager.BiomeEntry> getBiomesEntries(List<Biome> biomeIds) {
        ArrayList<BiomeManager.BiomeEntry> biomeEntries = new ArrayList<BiomeManager.BiomeEntry>();
        for (Biome biomes : biomeIds) {
            boolean notFound = true;
            block1: for (BiomeManager.BiomeType types : BiomeManager.BiomeType.values()) {
                for (BiomeManager.BiomeEntry entry : BiomeManager.getBiomes((BiomeManager.BiomeType)types)) {
                    if (biomes == null) {
                        AdvancedRocketry.logger.warn("Null biomes loaded for DIMID: " + this.getId());
                        continue;
                    }
                    if (!entry.biome.equals(biomes)) continue;
                    biomeEntries.add(entry);
                    notFound = false;
                    break block1;
                }
            }
            if (!notFound || biomes == null) continue;
            biomeEntries.add(new BiomeManager.BiomeEntry(biomes, 30));
        }
        return biomeEntries;
    }

    public void initDefaultAttributes() {
        if (this.averageTemperature > 100) {
            this.setOceanBlock(Blocks.field_150353_l.func_176223_P());
        }
        this.setGenerateCraters(AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()).lessDenseThan(AtmosphereTypes.NORMAL));
        this.setGenerateVolcanos(Temps.getTempFromValue(this.averageTemperature).hotterThan(Temps.HOT));
        this.setGenerateStructures(this.isHabitable());
        this.setGenerateGeodes(this.getAtmosphereDensity() > 125);
    }

    private void readFromTechnicalNBT(NBTTagCompound nbt) {
        this.isTerraformed = nbt.func_74767_n("terraformed");
        if (nbt.func_74764_b("beaconLocations")) {
            NBTTagList list = nbt.func_150295_c("beaconLocations", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] location = list.func_150306_c(i);
                this.beaconLocations.add(new HashedBlockPosition(location[0], location[1], location[2]));
            }
            DimensionManager.getInstance().knownPlanets.add(this.getId());
        } else {
            this.beaconLocations.clear();
        }
        if (nbt.func_74764_b("biomesTerra")) {
            this.terraformedBiomes.clear();
            int[] biomeIds = nbt.func_74759_k("biomesTerra");
            ArrayList<Biome> biomesList = new ArrayList<Biome>();
            for (int i = 0; i < biomeIds.length; ++i) {
                biomesList.add(AdvancedRocketryBiomes.instance.getBiomeById(biomeIds[i]));
            }
            this.terraformedBiomes.addAll(this.getBiomesEntries(biomesList));
        }
        if (nbt.func_74764_b("satallites")) {
            NBTTagCompound allSatalliteNbt = nbt.func_74775_l("satallites");
            for (Object keyObject : allSatalliteNbt.func_150296_c()) {
                String key = (String)keyObject;
                Long longKey = Long.parseLong(key);
                NBTTagCompound satalliteNbt = allSatalliteNbt.func_74775_l(key);
                if (this.satallites.containsKey(longKey)) {
                    this.satallites.get(longKey).readFromNBT(satalliteNbt);
                    continue;
                }
                try {
                    SatelliteBase satallite = SatelliteRegistry.createFromNBT(satalliteNbt);
                    this.satallites.put(longKey, satallite);
                    if (!satallite.canTick()) continue;
                    this.tickingSatallites.put(satallite.getId(), satallite);
                }
                catch (NullPointerException e) {
                    AdvancedRocketry.logger.warn("Satellite with bad NBT detected, Removing");
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int f;
        NBTTagList list;
        if (nbt.func_74764_b("skyColor")) {
            list = nbt.func_150295_c("skyColor", 5);
            this.skyColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.skyColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("ringColor")) {
            list = nbt.func_150295_c("ringColor", 5);
            this.ringColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.ringColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("sunriseSunsetColors")) {
            list = nbt.func_150295_c("sunriseSunsetColors", 5);
            this.sunriseSunsetColors = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.sunriseSunsetColors[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("fogColor")) {
            list = nbt.func_150295_c("fogColor", 5);
            this.fogColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.fogColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("biomes")) {
            this.allowedBiomes.clear();
            int[] biomeIds = nbt.func_74759_k("biomes");
            ArrayList<Biome> biomesList = new ArrayList<Biome>();
            for (int i = 0; i < biomeIds.length; ++i) {
                biomesList.add(AdvancedRocketryBiomes.instance.getBiomeById(biomeIds[i]));
            }
            this.allowedBiomes.addAll(this.getBiomesEntries(biomesList));
        }
        this.gravitationalMultiplier = nbt.func_74760_g("gravitationalMultiplier");
        this.orbitalDist = nbt.func_74762_e("orbitalDist");
        this.orbitTheta = nbt.func_74769_h("orbitTheta");
        this.orbitalPhi = nbt.func_74769_h("orbitPhi");
        this.rotationalPhi = nbt.func_74769_h("rotationalPhi");
        this.atmosphereDensity = nbt.func_74762_e("atmosphereDensity");
        this.originalAtmosphereDensity = nbt.func_74764_b("originalAtmosphereDensity") ? nbt.func_74762_e("originalAtmosphereDensity") : this.atmosphereDensity;
        this.averageTemperature = nbt.func_74762_e("avgTemperature");
        this.rotationalPeriod = nbt.func_74762_e("rotationalPeriod");
        this.name = nbt.func_74779_i("name");
        this.isNativeDimension = nbt.func_74764_b("isNative") ? nbt.func_74767_n("isNative") : true;
        this.isGasGiant = nbt.func_74767_n("isGasGiant");
        this.hasRings = nbt.func_74767_n("hasRings");
        this.sealevel = nbt.func_74762_e("sealevel");
        this.generatorType = nbt.func_74762_e("genType");
        this.canGenerateCraters = nbt.func_74767_n("canGenerateCraters");
        this.canGenerateGeodes = nbt.func_74767_n("canGenerateGeodes");
        this.canGenerateStructures = nbt.func_74767_n("canGenerateStructures");
        this.canGenerateVolcanos = nbt.func_74767_n("canGenerateVolcanos");
        this.geodeFrequencyMultiplier = nbt.func_74760_g("geodeFrequencyMultiplier");
        this.craterFrequencyMultiplier = nbt.func_74760_g("craterFrequencyMultiplier");
        this.volcanoFrequencyMultiplier = nbt.func_74760_g("volcanoFrequencyMultiplier");
        if (nbt.func_74764_b("childrenPlanets")) {
            for (int i : nbt.func_74759_k("childrenPlanets")) {
                this.childPlanets.add(i);
            }
        }
        this.parentPlanet = nbt.func_74762_e("parentPlanet");
        this.setStar(DimensionManager.getInstance().getStar(nbt.func_74762_e("starId")));
        if (this.isGasGiant) {
            NBTTagList fluidList = nbt.func_150295_c("fluids", 8);
            this.getHarvestableGasses().clear();
            for (int i = 0; i < fluidList.func_74745_c(); ++i) {
                Fluid f2 = FluidRegistry.getFluid((String)fluidList.func_150307_f(i));
                if (f2 == null) continue;
                this.getHarvestableGasses().add(f2);
            }
            if (this.getHarvestableGasses().isEmpty()) {
                this.getHarvestableGasses().addAll(AtmosphereRegister.getInstance().getHarvestableGasses());
            }
        }
        if (nbt.func_74764_b("oceanBlock")) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("oceanBlock")));
            if (block == Blocks.field_150350_a) {
                this.oceanBlock = null;
            } else {
                int meta = nbt.func_74762_e("oceanBlockMeta");
                this.oceanBlock = block.func_176203_a(meta);
            }
        } else {
            this.oceanBlock = null;
        }
        if (nbt.func_74764_b("fillBlock")) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("fillBlock")));
            if (block == Blocks.field_150350_a) {
                this.fillerBlock = null;
            } else {
                int meta = nbt.func_74762_e("fillBlockMeta");
                this.fillerBlock = block.func_176203_a(meta);
            }
        } else {
            this.fillerBlock = null;
        }
        this.readFromTechnicalNBT(nbt);
    }

    private void writeTechnicalNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("terraformed", this.isTerraformed);
        if (!this.beaconLocations.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (HashedBlockPosition pos : this.beaconLocations) {
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.x, pos.y, pos.z}));
            }
            nbt.func_74782_a("beaconLocations", (NBTBase)list);
        }
        if (!this.terraformedBiomes.isEmpty()) {
            int[] biomeId = new int[this.terraformedBiomes.size()];
            for (int i = 0; i < this.terraformedBiomes.size(); ++i) {
                biomeId[i] = Biome.func_185362_a((Biome)this.terraformedBiomes.get((int)i).biome);
            }
            nbt.func_74783_a("biomesTerra", biomeId);
        }
        if (!this.satallites.isEmpty()) {
            NBTTagCompound allSatalliteNbt = new NBTTagCompound();
            for (Map.Entry<Long, SatelliteBase> entry : this.satallites.entrySet()) {
                NBTTagCompound satalliteNbt = new NBTTagCompound();
                entry.getValue().writeToNBT(satalliteNbt);
                allSatalliteNbt.func_74782_a(entry.getKey().toString(), (NBTBase)satalliteNbt);
            }
            nbt.func_74782_a("satallites", (NBTBase)allSatalliteNbt);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list;
        if (this.skyColor != null) {
            list = new NBTTagList();
            for (float f : this.skyColor) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("skyColor", (NBTBase)list);
        }
        if (this.sunriseSunsetColors != null) {
            list = new NBTTagList();
            for (float f : this.sunriseSunsetColors) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("sunriseSunsetColors", (NBTBase)list);
        }
        list = new NBTTagList();
        for (float f : this.fogColor) {
            list.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        nbt.func_74782_a("fogColor", (NBTBase)list);
        if (this.hasRings) {
            list = new NBTTagList();
            for (float f : this.ringColor) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("ringColor", (NBTBase)list);
        }
        if (!this.allowedBiomes.isEmpty()) {
            int[] biomeId = new int[this.allowedBiomes.size()];
            for (int i = 0; i < this.allowedBiomes.size(); ++i) {
                biomeId[i] = Biome.func_185362_a((Biome)this.allowedBiomes.get((int)i).biome);
            }
            nbt.func_74783_a("biomes", biomeId);
        }
        nbt.func_74768_a("starId", this.starId);
        nbt.func_74776_a("gravitationalMultiplier", this.gravitationalMultiplier);
        nbt.func_74768_a("orbitalDist", this.orbitalDist);
        nbt.func_74780_a("orbitTheta", this.orbitTheta);
        nbt.func_74780_a("orbitPhi", this.orbitalPhi);
        nbt.func_74780_a("rotationalPhi", this.rotationalPhi);
        nbt.func_74768_a("atmosphereDensity", this.atmosphereDensity);
        nbt.func_74768_a("originalAtmosphereDensity", this.originalAtmosphereDensity);
        nbt.func_74768_a("avgTemperature", this.averageTemperature);
        nbt.func_74768_a("rotationalPeriod", this.rotationalPeriod);
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("isNative", this.isNativeDimension);
        nbt.func_74757_a("isGasGiant", this.isGasGiant);
        nbt.func_74757_a("hasRings", this.hasRings);
        nbt.func_74768_a("sealevel", this.sealevel);
        nbt.func_74768_a("genType", this.generatorType);
        nbt.func_74757_a("canGenerateCraters", this.canGenerateCraters);
        nbt.func_74757_a("canGenerateGeodes", this.canGenerateGeodes);
        nbt.func_74757_a("canGenerateStructures", this.canGenerateStructures);
        nbt.func_74757_a("canGenerateVolcanos", this.canGenerateVolcanos);
        nbt.func_74776_a("geodeFrequencyMultiplier", this.geodeFrequencyMultiplier);
        nbt.func_74776_a("craterFrequencyMultiplier", this.craterFrequencyMultiplier);
        nbt.func_74776_a("volcanoFrequencyMultiplier", this.volcanoFrequencyMultiplier);
        if (!this.childPlanets.isEmpty()) {
            Integer[] intList = new Integer[this.childPlanets.size()];
            NBTTagIntArray childArray = new NBTTagIntArray(ArrayUtils.toPrimitive((Integer[])this.childPlanets.toArray(intList)));
            nbt.func_74782_a("childrenPlanets", (NBTBase)childArray);
        }
        nbt.func_74768_a("parentPlanet", this.parentPlanet);
        if (this.isGasGiant) {
            NBTTagList fluidList = new NBTTagList();
            for (Fluid f : this.getHarvestableGasses()) {
                fluidList.func_74742_a((NBTBase)new NBTTagString(f.getName()));
            }
            nbt.func_74782_a("fluids", (NBTBase)fluidList);
        }
        if (this.oceanBlock != null) {
            nbt.func_74778_a("oceanBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.oceanBlock.func_177230_c())).toString());
            nbt.func_74768_a("oceanBlockMeta", this.oceanBlock.func_177230_c().func_176201_c(this.oceanBlock));
        }
        if (this.fillerBlock != null) {
            nbt.func_74778_a("fillBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.fillerBlock.func_177230_c())).toString());
            nbt.func_74768_a("fillBlockMeta", this.fillerBlock.func_177230_c().func_176201_c(this.fillerBlock));
        }
        this.writeTechnicalNBT(nbt);
    }

    public int getAverageTemp() {
        this.averageTemperature = DimensionManager.getInstance().getTemperature(this.getStar(), this.orbitalDist, this.getAtmosphereDensity());
        return this.averageTemperature;
    }

    public IBlockState getOceanBlock() {
        return this.oceanBlock;
    }

    public void setOceanBlock(IBlockState block) {
        this.oceanBlock = block;
    }

    public IBlockState getStoneBlock() {
        return this.fillerBlock;
    }

    public void setStoneBlock(IBlockState block) {
        this.fillerBlock = block;
    }

    public static DimensionProperties createFromNBT(int id, NBTTagCompound nbt) {
        DimensionProperties properties = new DimensionProperties(id);
        properties.readFromNBT(nbt);
        properties.planetId = id;
        return properties;
    }

    @Override
    public float getAtmosphereDensityAtHeight(double y) {
        return (float)this.atmosphereDensity * MathHelper.func_76131_a((float)((float)(1.0 + (256.0 - y) / 200.0)), (float)0.0f, (float)1.0f) / 100.0f;
    }

    public float[] getFogColorAtHeight(double y, Vec3d fogColor) {
        float atmDensity = this.getAtmosphereDensityAtHeight(y);
        return new float[]{(float)((double)atmDensity * fogColor.field_72450_a), (float)((double)atmDensity * fogColor.field_72448_b), (float)((double)atmDensity * fogColor.field_72449_c)};
    }

    public boolean isHabitable() {
        return this.getAtmosphere().isBreathable() && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.COLD, Temps.HOT);
    }

    public void setId(int id) {
        this.planetId = id;
    }

    @Override
    public void setParentOrbitalDistance(int distance) {
        this.orbitalDist = distance;
    }

    public double[] getPlanetPositon() {
        double orbitalDistance = this.orbitalDist;
        double theta = this.orbitTheta;
        double phi = this.orbitalPhi;
        double[] coords = new double[]{orbitalDistance * Math.cos(theta), orbitalDistance * Math.sin(phi), orbitalDistance * Math.sin(theta)};
        return coords;
    }

    @Override
    public int getStarId() {
        return this.starId;
    }

    public String toString() {
        return String.format("Dimension ID: %d.  Dimension Name: %s.  Parent Star %d ", this.getId(), this.getName(), this.getStarId());
    }

    @Override
    public double getOrbitTheta() {
        return this.orbitTheta;
    }

    @Override
    public int getOrbitalDist() {
        return this.orbitalDist;
    }

    public int getSeaLevel() {
        return this.sealevel;
    }

    public void setSeaLevel(int sealevel) {
        this.sealevel = MathHelper.func_76125_a((int)sealevel, (int)0, (int)255);
    }

    public void setGenType(int genType) {
        this.generatorType = genType;
    }

    public int getGenType() {
        return this.generatorType;
    }

    public void setGenerateCraters(boolean canGenerateCraters) {
        this.canGenerateCraters = canGenerateCraters;
    }

    public boolean canGenerateCraters() {
        return this.canGenerateCraters;
    }

    public float getCraterMultiplier() {
        return this.craterFrequencyMultiplier;
    }

    public void setCraterMultiplier(float craterFrequencyMultiplier) {
        this.craterFrequencyMultiplier = craterFrequencyMultiplier;
    }

    public void setGenerateGeodes(boolean canGenerateGeodes) {
        this.canGenerateGeodes = canGenerateGeodes;
    }

    public boolean canGenerateGeodes() {
        return this.canGenerateGeodes;
    }

    public float getGeodeMultiplier() {
        return this.volcanoFrequencyMultiplier;
    }

    public void setGeodeMultiplier(float geodeFrequencyMultiplier) {
        this.geodeFrequencyMultiplier = geodeFrequencyMultiplier;
    }

    public void setGenerateVolcanos(boolean canGenerateVolcanos) {
        this.canGenerateVolcanos = canGenerateVolcanos;
    }

    public boolean canGenerateVolcanos() {
        return this.canGenerateVolcanos;
    }

    public float getVolcanoMultiplier() {
        return this.volcanoFrequencyMultiplier;
    }

    public void setVolcanoMultiplier(float volcanoFrequencyMultiplier) {
        this.volcanoFrequencyMultiplier = volcanoFrequencyMultiplier;
    }

    public void setGenerateStructures(boolean canGenerateStructures) {
        this.canGenerateStructures = canGenerateStructures;
    }

    public boolean canGenerateStructures() {
        return this.canGenerateStructures;
    }

    @Override
    public float getRenderSizePlanetView() {
        return (this.isMoon() ? 8.0f : 10.0f) * Math.max(this.getGravitationalMultiplier() * this.getGravitationalMultiplier(), 0.5f) * 100.0f;
    }

    @Override
    public float getRenderSizeSolarView() {
        return (this.isMoon() ? 0.2f : 1.0f) * Math.max(this.getGravitationalMultiplier() * this.getGravitationalMultiplier(), 0.5f) * 100.0f;
    }

    @Override
    public SpacePosition getSpacePosition() {
        float distanceMultiplier = this.isMoon() ? 75.0f : 100.0f;
        SpacePosition spacePosition = new SpacePosition();
        spacePosition.star = this.getStar();
        spacePosition.world = this;
        spacePosition.isInInterplanetarySpace = this.isMoon();
        spacePosition.pitch = 0.0;
        spacePosition.roll = 0.0;
        spacePosition.yaw = 0.0;
        spacePosition = spacePosition.getFromSpherical(distanceMultiplier * (float)this.orbitalDist + (float)(this.isMoon() ? 100 : 0), this.orbitTheta);
        return spacePosition;
    }

    @Override
    public float[] getRingColor() {
        return this.ringColor;
    }

    @Override
    public float[] getSkyColor() {
        return this.skyColor;
    }

    public static enum PlanetIcons {
        EARTHLIKE(new ResourceLocation("advancedrocketry:textures/planets/Earthlike.png")),
        LAVA(new ResourceLocation("advancedrocketry:textures/planets/Lava.png")),
        MARSLIKE(new ResourceLocation("advancedrocketry:textures/planets/marslike.png")),
        MOON(new ResourceLocation("advancedrocketry:textures/planets/moon.png")),
        WATERWORLD(new ResourceLocation("advancedrocketry:textures/planets/WaterWorld.png")),
        ICEWORLD(new ResourceLocation("advancedrocketry:textures/planets/IceWorld.png")),
        GASGIANTBLUE(new ResourceLocation("advancedrocketry:textures/planets/GasGiantBlue.png")),
        GASGIANTRED(new ResourceLocation("advancedrocketry:textures/planets/GasGiantred.png")),
        ASTEROID(new ResourceLocation("advancedrocketry:textures/planets/asteroid.png")),
        UNKNOWN(new ResourceLocation("advancedrocketry:textures/planets/Unknown.png"));

        private ResourceLocation resource;
        private ResourceLocation resourceLEO;

        private PlanetIcons(ResourceLocation resource) {
            this.resource = resource;
            this.resourceLEO = new ResourceLocation(resource.toString().substring(0, resource.toString().length() - 4) + "LEO.jpg");
        }

        private PlanetIcons(ResourceLocation resource, ResourceLocation leo) {
            this.resource = resource;
            this.resourceLEO = atmosphereLEO;
        }

        public ResourceLocation getResource() {
            return this.resource;
        }

        public ResourceLocation getResourceLEO() {
            return this.resourceLEO;
        }
    }

    public static enum AtmosphereTypes {
        SUPERHIGHPRESSURE(800),
        HIGHPRESSURE(200),
        NORMAL(75),
        LOW(25),
        NONE(0);

        private int value;

        private AtmosphereTypes(int value) {
            this.value = value;
        }

        public int getAtmosphereValue() {
            return this.value;
        }

        public boolean denserThan(AtmosphereTypes type) {
            return this.compareTo(type) < 0;
        }

        public boolean lessDenseThan(AtmosphereTypes type) {
            return this.compareTo(type) > 0;
        }

        public static AtmosphereTypes getAtmosphereTypeFromValue(int value) {
            for (AtmosphereTypes type : AtmosphereTypes.values()) {
                if (value <= type.value) continue;
                return type;
            }
            return NONE;
        }
    }

    public static enum Temps {
        TOOHOT(150),
        HOT(125),
        NORMAL(75),
        COLD(50),
        FRIGID(25),
        SNOWBALL(0);

        private int temp;

        private Temps(int i) {
            this.temp = i;
        }

        @Deprecated
        public int getTemp() {
            return this.temp;
        }

        public boolean hotterThan(Temps type) {
            return this.compareTo(type) < 0;
        }

        public boolean colderThan(Temps type) {
            return this.compareTo(type) > 0;
        }

        public boolean isInRange(Temps lowerBound, Temps upperBound) {
            return this.compareTo(lowerBound) <= 0 && this.compareTo(upperBound) >= 0;
        }

        public static Temps getTempFromValue(int value) {
            for (Temps type : Temps.values()) {
                if (value <= type.temp) continue;
                return type;
            }
            return SNOWBALL;
        }
    }
}

