/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.block.multiblock.BlockARHatch;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleLimitedSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileGuidanceComputerHatch
extends TilePointer
implements IInfrastructure,
IInventory,
IModularInventory,
IToggleButton,
INetworkMachine,
ITickable {
    private static final int buttonAutoEject = 0;
    private static final int buttonSatellite = 1;
    private static final int buttonPlanet = 2;
    private static final int buttonStation = 3;
    private static final int redstoneState = 4;
    private ModuleToggleSwitch module_autoEject;
    private ModuleToggleSwitch module_satellite;
    private ModuleToggleSwitch module_planet;
    private ModuleToggleSwitch module_station;
    private boolean[] buttonState = new boolean[4];
    private boolean chipEjected = false;
    EntityRocket rocket;
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, 4, "", (IButtonInventory)this, LibVulpes.proxy.getLocalizedString("msg.guidanceComputerHatch.loadingState"));
    ZUtils.RedstoneState state = ZUtils.RedstoneState.ON;

    public TileGuidanceComputerHatch() {
        this.module_autoEject = new ModuleToggleSwitch(90, 15, 0, "", (IToggleButton)this, TextureResources.buttonAutoEject, LibVulpes.proxy.getLocalizedString("msg.guidanceComputerHatch.ejectonlanding"), 24, 24, false);
        this.module_satellite = new ModuleToggleSwitch(64, 41, 1, "", (IToggleButton)this, TextureResources.buttonAutoEject, LibVulpes.proxy.getLocalizedString("msg.guidanceComputerHatch.ejectonsatlanding"), 24, 24, false);
        this.module_planet = new ModuleToggleSwitch(90, 41, 2, "", (IToggleButton)this, TextureResources.buttonAutoEject, LibVulpes.proxy.getLocalizedString("msg.guidanceComputerHatch.ejectonplanetlanding"), 24, 24, false);
        this.module_station = new ModuleToggleSwitch(116, 41, 3, "", (IToggleButton)this, TextureResources.buttonAutoEject, LibVulpes.proxy.getLocalizedString("msg.guidanceComputerHatch.ejectonstationlanding"), 24, 24, false);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        this.setModuleStates();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketBuilder) {
            ((TileRocketBuilder)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
    }

    public String func_70005_c_() {
        return this.getModularInventoryName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int index) {
        TileGuidanceComputer guidanceComputer;
        if (this.rocket != null && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            return guidanceComputer.func_70301_a(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        TileGuidanceComputer guidanceComputer;
        if (this.rocket != null && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            return guidanceComputer.func_70298_a(index, count);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        TileGuidanceComputer guidanceComputer;
        if (this.rocket != null && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            return guidanceComputer.func_70304_b(index);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        TileGuidanceComputer guidanceComputer;
        if (this.rocket != null && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            guidanceComputer.func_70299_a(index, stack);
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        TileGuidanceComputer guidanceComputer;
        if (this.rocket != null && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            return guidanceComputer.func_94041_b(index, stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        TileGuidanceComputer guidanceComputer;
        if (this.rocket != null && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            guidanceComputer.func_174888_l();
        }
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (this.rocket != null) {
            this.rocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("%s %s", new Object[]{new TextComponentTranslation("msg.guidanceComputerHatch.link", new Object[0]), ": " + this.func_174877_v().func_177958_n() + " " + this.func_174877_v().func_177956_o() + " " + this.func_174877_v().func_177952_p()}));
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("msg.linker.error.firstMachine", new Object[0]));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.rocket = null;
        ((BlockARHatch)AdvancedRocketryBlocks.blockLoader).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
        this.chipEjected = false;
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        TileGuidanceComputer guidanceComputer;
        this.rocket = (EntityRocket)rocket;
        if (!this.chipEjected && this.buttonState[0] && (guidanceComputer = this.rocket.storage.getGuidanceComputer()) != null) {
            ItemStack stack = guidanceComputer.func_70301_a(0);
            if (!stack.func_190926_b()) {
                if (stack.func_77973_b() instanceof ItemSatelliteIdentificationChip && this.buttonState[1] || stack.func_77973_b() instanceof ItemPlanetIdentificationChip && this.buttonState[2] || stack.func_77973_b() instanceof ItemStationChip && this.buttonState[3]) {
                    this.ejectChipFrom((IInventory)guidanceComputer);
                    this.chipEjected = true;
                }
            } else {
                this.chipEjected = true;
            }
        }
        return true;
    }

    private void ejectChipFrom(IInventory guidanceComputer) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (!(tile instanceof IInventory) || !ZUtils.doesInvHaveRoom((ItemStack)guidanceComputer.func_70301_a(0), (IInventory)((IInventory)tile))) continue;
            ZUtils.mergeInventory((ItemStack)guidanceComputer.func_70301_a(0), (IInventory)((IInventory)tile));
            guidanceComputer.func_70304_b(0);
        }
    }

    @Override
    public int getMaxLinkDistance() {
        return 64;
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModuleLimitedSlotArray(15, 15, (IInventory)this, 0, 1));
        modules.add((ModuleBase)this.redstoneControl);
        modules.add((ModuleBase)this.module_autoEject);
        if (this.field_145850_b.field_72995_K) {
            this.module_satellite.setBGColor(-14005331);
        }
        modules.add((ModuleBase)this.module_satellite);
        if (this.field_145850_b.field_72995_K) {
            this.module_planet.setBGColor(-7349152);
        }
        modules.add((ModuleBase)this.module_planet);
        if (this.field_145850_b.field_72995_K) {
            this.module_station.setBGColor(-2236963);
        }
        modules.add((ModuleBase)this.module_station);
        this.setModuleStates();
        return modules;
    }

    private void setModuleStates() {
        this.module_station.setToggleState(this.buttonState[3]);
        this.module_satellite.setToggleState(this.buttonState[1]);
        this.module_autoEject.setToggleState(this.buttonState[0]);
        this.module_planet.setToggleState(this.buttonState[2]);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.rocket != null) {
            boolean rocketContainsItems = this.rocket.storage.getGuidanceComputer() != null && !this.rocket.storage.getGuidanceComputer().func_70301_a(0).func_190926_b() && (this.chipEjected || !this.buttonState[0]);
            this.setRedstoneState(!rocketContainsItems);
        }
    }

    protected void setRedstoneState(boolean condition) {
        condition = this.isStateActive(this.state, condition);
        ((BlockARHatch)AdvancedRocketryBlocks.blockLoader).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, condition);
    }

    protected boolean isStateActive(ZUtils.RedstoneState state, boolean condition) {
        if (state == ZUtils.RedstoneState.INVERTED) {
            return !condition;
        }
        if (state == ZUtils.RedstoneState.OFF) {
            return false;
        }
        return condition;
    }

    public String getModularInventoryName() {
        return "tile.loader.6.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (4 == buttonId) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
        } else {
            this.buttonState[buttonId] = !this.buttonState[buttonId];
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
        }
    }

    public void stateUpdated(ModuleBase module) {
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 4) {
            out.writeByte(this.state.ordinal());
        } else {
            int status = 0;
            for (int i = 0; i < this.buttonState.length; ++i) {
                status = (short)(status + (this.buttonState[i] ? 1 << i : 0));
            }
            out.writeShort(status);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 4) {
            nbt.func_74774_a("state", in.readByte());
        } else {
            nbt.func_74777_a("status", in.readShort());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 4) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
            this.func_70296_d();
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()));
        } else {
            short status = nbt.func_74765_d("status");
            for (int i = 0; i < this.buttonState.length; ++i) {
                this.buttonState[i] = (status & 1 << i) != 0;
            }
            this.setModuleStates();
            this.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("chipEjected", this.chipEjected);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        short status = 0;
        for (int i = 0; i < this.buttonState.length; ++i) {
            status = (short)(status + (this.buttonState[i] ? 1 << i : 0));
        }
        nbt.func_74777_a("statuses", status);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.chipEjected = nbt.func_74767_n("chipEjected");
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        short status = nbt.func_74765_d("statuses");
        for (int i = 0; i < this.buttonState.length; ++i) {
            this.buttonState[i] = (status & 1 << i) != 0;
        }
        super.func_145839_a(nbt);
    }

    public boolean func_191420_l() {
        return this.func_70301_a(0).func_190926_b();
    }
}

