/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.provider;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.capability.DimensionCompat;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.compat.Compat;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.ChunkProviderCavePlanet;
import zmaster587.advancedRocketry.world.ChunkProviderPlanet;

public class WorldProviderPlanet
extends WorldProvider
implements IPlanetaryProvider {
    public BiomeProvider chunkMgrTerraformed;

    public IChunkGenerator func_186060_c() {
        int genType = DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getGenType();
        if (genType == 1) {
            return new ChunkProviderCavePlanet(this.field_76579_a, false, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_82571_y());
        }
        return new ChunkProviderPlanet(this.field_76579_a, this.field_76579_a.func_72905_C(), ARConfiguration.getCurrentConfig().generateVanillaStructures, this.field_76579_a.func_72912_H().func_82571_y());
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (!ARConfiguration.getCurrentConfig().planetSkyOverride) {
            return null;
        }
        int genType = DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getGenType();
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new RenderPlanetarySky());
        }
        return super.getSkyRenderer();
    }

    public long getSeed() {
        return super.getSeed() + (long)this.getDimension();
    }

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76579_a.func_72912_H().func_76085_a(AdvancedRocketry.planetWorldType);
        this.field_76578_c = new ChunkManagerPlanet(this.field_76579_a, this.field_76579_a.func_72912_H().func_82571_y(), DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getBiomes());
        this.chunkMgrTerraformed = new ChunkManagerPlanet(this.field_76579_a, this.field_76579_a.func_72912_H().func_82571_y(), DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getTerraformedBiomes());
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.getAtmosphereDensity(new BlockPos(0, 0, 0)) > 75.0f ? super.canDoRainSnowIce(chunk) : false;
    }

    public void calculateInitialWeather() {
        super.calculateInitialWeather();
        this.doWeatherStuff();
    }

    public void updateWeather() {
        super.updateWeather();
        this.doWeatherStuff();
    }

    private void doWeatherStuff() {
        BlockPos blockPos = new BlockPos(0, 0, 0);
        if (this.getAtmosphereDensity(blockPos) <= 75.0f && this.field_76579_a.func_72896_J()) {
            if (!Compat.isSpongeInstalled) {
                try {
                    WorldInfo worldInfo = (WorldInfo)ReflectionHelper.getPrivateValue(DerivedWorldInfo.class, (Object)((DerivedWorldInfo)this.field_76579_a.func_72912_H()), (String[])new String[]{"delegate", "field_76115_a"});
                    worldInfo.func_76084_b(false);
                }
                catch (ClassCastException e) {
                    this.field_76579_a.func_72912_H().func_76084_b(false);
                }
            } else {
                this.field_76579_a.func_72912_H().func_76084_b(false);
            }
        }
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        BlockPos coords;
        if (ARConfiguration.getCurrentConfig().canPlayerRespawnInSpace && (coords = player.getBedLocation(this.getDimension())) != null && (ARConfiguration.getCurrentConfig().forcePlayerRespawnInSpace || AtmosphereHandler.hasAtmosphereHandler(player.field_70170_p.field_73011_w.getDimension()) && AtmosphereHandler.getOxygenHandler(player.field_70170_p.field_73011_w.getDimension()).getAtmosphereType(coords).isBreathable())) {
            return this.getDimension();
        }
        return DimensionCompat.getDefaultSpawnDimension();
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        if (ARConfiguration.getCurrentConfig().forcePlayerRespawnInSpace || AtmosphereHandler.hasAtmosphereHandler(player.field_70170_p.field_73011_w.getDimension()) && AtmosphereHandler.getOxygenHandler(player.field_70170_p.field_73011_w.getDimension()).getAtmosphereType(pos).isBreathable()) {
            return WorldProvider.WorldSleepResult.ALLOW;
        }
        return WorldProvider.WorldSleepResult.DENY;
    }

    public boolean func_76567_e() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float p_76560_1_, float p_76560_2_) {
        float f4;
        float[] colors = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)Minecraft.func_71410_x().field_71439_g.field_70165_t), (int)0, (int)((int)Minecraft.func_71410_x().field_71439_g.field_70161_v))).sunriseSunsetColors;
        if (colors == null) {
            return super.func_76560_a(p_76560_1_, p_76560_2_);
        }
        float[] finalColors = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.func_76134_b((float)(p_76560_1_ * (float)Math.PI * 2.0f)) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * (float)Math.PI))) * 0.99f;
            f6 *= f6;
            finalColors[0] = f5 * 0.3f + colors[0];
            finalColors[1] = f5 * f5 * 0.7f + colors[1];
            finalColors[2] = f5 * f5 * 0.1f + colors[2];
            finalColors[3] = f6 * this.getAtmosphereDensityFromHeight(Minecraft.func_71410_x().func_175606_aa().field_70163_u, new BlockPos((int)Minecraft.func_71410_x().field_71439_g.field_70165_t, 0, (int)Minecraft.func_71410_x().field_71439_g.field_70161_v));
            return finalColors;
        }
        return null;
    }

    public float getSunBrightness(float partialTicks) {
        StellarBody star;
        float atmosphere = this.getAtmosphereDensity(new BlockPos(0, 0, 0));
        Math.abs(1.0f - atmosphere);
        float f1 = this.field_76579_a.func_72826_c(partialTicks);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f) - atmosphere / 4.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        if (this.field_76579_a.field_72995_K) {
            DimensionProperties properties = this.getDimensionProperties(Minecraft.func_71410_x().field_71439_g.func_180425_c());
            if (properties.isMoon()) {
                f2 = this.eclipseValue(properties, f2, partialTicks);
            } else {
                for (int i : properties.getChildPlanets()) {
                    DimensionProperties childProps = DimensionManager.getInstance().getDimensionProperties(i);
                    f2 = this.eclipseValue(childProps, f2, partialTicks);
                }
            }
        }
        boolean blackHole = (star = DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getStar()) != null && star.isBlackHole();
        for (StellarBody star2 : star.getSubStars()) {
            if (star2.isBlackHole()) continue;
            blackHole = false;
            break;
        }
        if (blackHole) {
            f2 = (float)((double)f2 * 0.25);
        }
        return f2 * super.getSunBrightness(partialTicks);
    }

    private float eclipseValue(DimensionProperties properties, float lightValue, double partialTicks) {
        double currentTheta = (partialTicks * properties.orbitTheta + (1.0 - partialTicks) * properties.prevOrbitalTheta) * 180.0 / Math.PI % 360.0;
        int solarDistance = properties.getSolarOrbitalDistance();
        float planetaryDistance = properties.getParentOrbitalDistance();
        float difference = (float)solarDistance / (200.0f - planetaryDistance + 1.0E-5f);
        float phiMuliplier = Math.max(Math.abs(MathHelper.func_76134_b((float)((float)(properties.orbitalPhi * Math.PI / 180.0)))) - 0.95f, 0.0f) * 20.0f;
        int offset = (int)((200.0f - planetaryDistance) / 2.0f);
        if (phiMuliplier != 0.0f && currentTheta > (double)(180 - offset) && currentTheta < (double)(180 + offset)) {
            lightValue *= phiMuliplier * MathHelper.func_76131_a((float)((float)((double)(difference / 20.0f) + Math.abs(currentTheta - 180.0) * (double)difference / 10.0)), (float)0.0f, (float)1.0f) + (1.0f - phiMuliplier);
        }
        return lightValue;
    }

    public float func_76571_f() {
        return this.getAtmosphereDensity(new BlockPos(0, 0, 0)) > 0.75f ? 128.0f : -2000.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        float[] vec = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)cameraEntity.field_70165_t), (int)0, (int)((int)cameraEntity.field_70161_v))).skyColor;
        if (vec == null) {
            return super.getSkyColor(cameraEntity, partialTicks);
        }
        Vec3d skyColorVec = super.getSkyColor(cameraEntity, partialTicks);
        return new Vec3d((double)vec[0] * skyColorVec.field_72450_a, (double)vec[1] * skyColorVec.field_72448_b, (double)vec[2] * skyColorVec.field_72449_c);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        Vec3d superVec = super.func_76562_b(p_76562_1_, p_76562_2_);
        float[] vec = this.getDimensionProperties((BlockPos)new BlockPos((int)((int)Minecraft.func_71410_x().field_71439_g.field_70165_t), (int)0, (int)((int)Minecraft.func_71410_x().field_71439_g.field_70161_v))).fogColor;
        return new Vec3d((double)vec[0] * superVec.field_72450_a, (double)vec[1] * superVec.field_72448_b, (double)vec[2] * superVec.field_72449_c);
    }

    public boolean func_76568_b(int x, int z) {
        return this.getDimensionProperties(new BlockPos(x, 0, z)).getAtmosphereDensity() > 100;
    }

    public double getHorizon() {
        int genType = DimensionManager.getInstance().getDimensionProperties(this.field_76579_a.field_73011_w.getDimension()).getGenType();
        if (genType == 2) {
            return 0.0;
        }
        return 63.0;
    }

    public float func_76563_a(long p_76563_1_, float p_76563_3_) {
        int rotationalPeriod = this.getRotationalPeriod(new BlockPos(0, 0, 0));
        int j = (int)(p_76563_1_ % (long)rotationalPeriod);
        float f1 = ((float)j + p_76563_3_) / (float)rotationalPeriod - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    @Override
    public double getGravitationalMultiplier(BlockPos pos) {
        return this.getDimensionProperties((BlockPos)pos).gravitationalMultiplier;
    }

    @Override
    public int getOrbitingDimension(BlockPos pos) {
        return this.getDimensionProperties(pos).getParentPlanet();
    }

    @Override
    public int[] getDimensionsInOrbit(BlockPos pos) {
        Set<Integer> intSet = this.getDimensionProperties(pos).getChildPlanets();
        Integer[] intArray = new Integer[intSet.size()];
        return ArrayUtils.toPrimitive((Integer[])this.getDimensionProperties(pos).getChildPlanets().toArray(intArray));
    }

    @Override
    public int getOrbitalDistance(BlockPos pos) {
        return this.getDimensionProperties((BlockPos)pos).orbitalDist;
    }

    @Override
    public IAtmosphere getAtmosphere(BlockPos pos) {
        return this.getDimensionProperties(pos).getAtmosphere();
    }

    @Override
    public float getAtmosphereDensity(BlockPos pos) {
        return (float)this.getDimensionProperties(pos).getAtmosphereDensity() / 100.0f;
    }

    @Override
    public float getAtmosphereDensityFromHeight(double y, BlockPos pos) {
        return this.getDimensionProperties(pos).getAtmosphereDensityAtHeight(y);
    }

    @Override
    public int getAverageTemperature(BlockPos pos) {
        return this.getDimensionProperties(pos).getAverageTemp();
    }

    @Override
    public int getRotationalPeriod(BlockPos pos) {
        return this.getDimensionProperties((BlockPos)new BlockPos((int)0, (int)0, (int)0)).rotationalPeriod;
    }

    @Override
    public int getWetness() {
        return 0;
    }

    public String getSaveFolder() {
        return "advRocketry/" + super.getSaveFolder();
    }

    @Override
    public boolean isPlanet() {
        return true;
    }

    @Override
    public Vec3d getSunColor(BlockPos pos) {
        float[] vec = this.getDimensionProperties(pos).getSunColor();
        return new Vec3d((double)vec[0], (double)vec[1], (double)vec[2]);
    }

    public int getSolarOrbitalDistance(BlockPos pos) {
        return this.getDimensionProperties(pos).getSolarOrbitalDistance();
    }

    @Override
    public DimensionProperties getDimensionProperties(BlockPos pos) {
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.getDimension());
        return properties == null ? new DimensionProperties(this.getDimension()) : properties;
    }

    public DimensionType func_186058_p() {
        return DimensionManager.PlanetDimensionType;
    }
}

