/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty;

import com.github.elrol.dropparty.commands.CommandRegistry;
import com.github.elrol.dropparty.config.DefaultConfiguration;
import com.github.elrol.dropparty.config.DropConfiguration;
import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.config.TierConfiguration;
import com.github.elrol.dropparty.events.EventManager;
import com.github.elrol.dropparty.libs.TextLibs;
import com.google.inject.Inject;
import java.io.File;
import java.util.Optional;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.service.economy.EconomyService;

@Plugin(id="dropparty", name="DropParty", version="Beta v0.9", description="A Drop Party plugin commissioned by the PokeFreaks network")
public class Main {
    private static Main instance;
    public EventBus EVENT_BUS = new EventBus();
    private Logger logger;
    private File defaultConfig;
    private File tierConfig;
    private File setupConfig;
    private File dropConfig;
    private ConfigurationLoader<CommentedConfigurationNode> configManager;
    private ConfigurationLoader<CommentedConfigurationNode> tierManager;
    private ConfigurationLoader<CommentedConfigurationNode> setupManager;
    private ConfigurationLoader<CommentedConfigurationNode> dropManager;
    private EventManager eventManager;

    @Inject
    public Main(Logger logger, @DefaultConfig(sharedRoot=false) ConfigurationLoader<CommentedConfigurationNode> loader, @ConfigDir(sharedRoot=false) File configDir) {
        this.logger = logger;
        this.defaultConfig = new File(configDir + "/dropparty.conf");
        this.tierConfig = new File(configDir + "/tiers.conf");
        this.setupConfig = new File(configDir + "/setups.conf");
        this.dropConfig = new File(configDir + "/drops.conf");
        this.configManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.defaultConfig)).build();
        this.tierManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.tierConfig)).build();
        this.setupManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.setupConfig)).build();
        this.dropManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(this.dropConfig)).build();
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        this.logger.info("Started DropParty");
        this.eventManager = new EventManager();
    }

    @Listener
    public void onServerStop(GameStoppedServerEvent event) {
        this.logger.info("Stopping DropParty");
    }

    @Listener
    public void preInit(GamePreInitializationEvent event) {
    }

    @Listener
    public void init(GameInitializationEvent event) {
        this.logger.info("Registering Configs");
        DefaultConfiguration.getInstance().setup(this.defaultConfig, this.configManager);
        TierConfiguration.getInstance().setup(this.tierConfig, this.tierManager);
        SetupConfiguration.getInstance().setup(this.setupConfig, this.setupManager);
        DropConfiguration.getInstance().setup(this.dropConfig, this.dropManager);
        CommandRegistry.setup(this);
    }

    @Listener
    public void postInit(GamePostInitializationEvent event) {
        instance = this;
    }

    @Listener
    public void onBlockActivate(InteractBlockEvent event) {
        BlockType type = event.getTargetBlock().getState().getType();
        if (!this.eventManager.isRunning) {
            return;
        }
        if (!(event.getSource() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getSource();
        if ((type.equals(BlockTypes.CHEST) || type.equals(BlockTypes.TRAPPED_CHEST)) && EventManager.getCurrentParty().getChests().contains(event.getTargetBlock().getLocation().get())) {
            TextLibs.sendError((CommandSource)player, "You can not open a DropParty chest durring a DropParty.");
            event.setCancelled(true);
        }
    }

    public static Main getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public EconomyService getEconService() {
        Optional service = Sponge.getServiceManager().provide(EconomyService.class);
        if (!service.isPresent()) {
            return null;
        }
        return (EconomyService)service.get();
    }
}

