/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.Main;
import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.title.Title;

public class DropPartyAdminStart
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        SetupConfiguration setup = SetupConfiguration.getInstance();
        Player player = null;
        if (src instanceof Player) {
            player = (Player)src;
        }
        if (args.hasAny("name")) {
            String timeArg;
            String name = (String)args.getOne("name").get();
            if (Main.getInstance().getEventManager().isRunning) {
                TextLibs.sendError(src, "A Drop Party is already running, Please wait until it has finished.");
                return CommandResult.success();
            }
            int delay = 0;
            int persec = 3;
            if (args.hasAny("delay")) {
                delay = (Integer)args.getOne("delay").get();
            }
            if (args.hasAny("persec")) {
                persec = (Integer)args.getOne("persec").get();
                if (persec > 20) {
                    TextLibs.sendError(src, "ItemsPerSec cannot exceed 20");
                    return CommandResult.empty();
                }
                if (persec < 1) {
                    TextLibs.sendError(src, "ItemsPerSec must be at least 1");
                    return CommandResult.empty();
                }
            }
            int time = 0;
            boolean isAuto = false;
            if (args.hasAny("time") && !(timeArg = (String)args.getOne("time").get()).equalsIgnoreCase("auto")) {
                try {
                    time = Integer.parseInt(timeArg);
                    isAuto = true;
                }
                catch (NumberFormatException e) {
                    TextLibs.sendError(src, "Time must be either a number, or \"auto\"");
                    return CommandResult.empty();
                }
            }
            Title title = Title.builder().title(Text.of((Object[])new Object[]{TextColors.BLUE, "DropParty '" + name + "'"})).subtitle(Text.of((Object[])new Object[]{TextColors.AQUA, "Starting in " + delay + " min"})).stay(Integer.valueOf(100)).build();
            if (setup.doesPartyExist(name)) {
                if (!setup.getChests(name).isEmpty()) {
                    if (!setup.getDrops(name).isEmpty()) {
                        if (setup.getPartyItemQty(name) > 0) {
                            if (isAuto) {
                                Main.getInstance().getEventManager().scheduleEvent(player, name, null, delay, persec, true);
                            } else {
                                Main.getInstance().getEventManager().scheduleEvent(player, name, null, delay, time, persec, true);
                            }
                            Methods.broadcastTitle(title);
                        } else {
                            TextLibs.sendError(src, "There are no items in the chests for the party.");
                        }
                    } else {
                        TextLibs.sendError(src, "There are no DropPoints specified for the party. Use /DropParty drop add " + name);
                    }
                } else {
                    TextLibs.sendError(src, "There are no Chests specified for the party. Use /DropParty chest add " + name);
                }
            } else {
                TextLibs.sendError(src, "There is no party by the name of: " + name);
            }
        }
        return CommandResult.success();
    }
}

