/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class DropPartyChestExecutor
implements CommandExecutor {
    private int mode;

    public DropPartyChestExecutor(int mode) {
        this.mode = mode;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("name")) {
            String name = (String)args.getOne("name").get();
            if (this.mode == 0) {
                src.sendMessage(TextLibs.pluginMessage("List of chests for " + name));
                List<Location<World>> chests = SetupConfiguration.getInstance().getChests(name);
                if (!chests.isEmpty()) {
                    for (int i = 0; i < chests.size(); ++i) {
                        src.sendMessage((Text)Text.of((String)("[" + i + "] X:" + chests.get(i).getBlockX() + ", Y:" + chests.get(i).getBlockY() + ", Z:" + chests.get(i).getBlockZ() + "(" + ((World)chests.get(i).getExtent()).getName() + ")")));
                    }
                } else {
                    src.sendMessage((Text)Text.of((String)"No chests found"));
                }
                return CommandResult.success();
            }
            if (this.mode == 1) {
                if (args.hasAny("x") && args.hasAny("y") && args.hasAny("z")) {
                    int x = (Integer)args.getOne("x").get();
                    int y = (Integer)args.getOne("y").get();
                    int z = (Integer)args.getOne("z").get();
                    World world = Methods.getWorld(args);
                    int id = SetupConfiguration.getInstance().getChestId(name);
                    src.sendMessage(TextLibs.pluginMessage("set chest " + id + " for Party " + name));
                    SetupConfiguration.getInstance().addChest(src, name, (Location<World>)new Location((Extent)world, x, y, z));
                    return CommandResult.success();
                }
                if (src instanceof Player) {
                    Player player = (Player)src;
                    List<Location<World>> chests = Methods.getChest(player);
                    for (Location<World> loc : chests) {
                        SetupConfiguration.getInstance().addChest(src, name, loc);
                    }
                    return CommandResult.success();
                }
                src.sendMessage(TextLibs.pluginError("You must set the coords of a chest in console"));
                return CommandResult.builder().successCount(Integer.valueOf(0)).build();
            }
            if (args.hasAny("id")) {
                int id = (Integer)args.getOne("id").get();
                SetupConfiguration.getInstance().removeChest(src, name, id);
            }
        }
        return CommandResult.success();
    }
}

