/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class DropPartyCreateExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("name")) {
            String name = (String)args.getOne("name").get();
            if (SetupConfiguration.getInstance().doesPartyExist(name)) {
                src.sendMessage(TextLibs.pluginError("A Party by that name already exists."));
                return CommandResult.builder().successCount(Integer.valueOf(0)).build();
            }
            String playerName = src instanceof Player ? ((Player)src).getName() : "Console";
            SetupConfiguration.getInstance().createParty(src, name, playerName);
            src.sendMessage(TextLibs.pluginMessage("Successfully created party: " + name));
            if (args.hasAny("x") && args.hasAny("y") && args.hasAny("z")) {
                int x = (Integer)args.getOne("x").get();
                int y = (Integer)args.getOne("y").get();
                int z = (Integer)args.getOne("z").get();
                World world = Methods.getWorld(args);
                SetupConfiguration.getInstance().addChest(src, name, (Location<World>)new Location((Extent)world, x, y, z));
            }
        }
        return CommandResult.success();
    }
}

