/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class DropPartyDropExecutor
implements CommandExecutor {
    private int mode;

    public DropPartyDropExecutor(int mode) {
        this.mode = mode;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (args.hasAny("name")) {
            String name = (String)args.getOne("name").get();
            if (this.mode == 0) {
                src.sendMessage(TextLibs.pluginMessage("List of drops for " + name));
                List<Location<World>> drops = SetupConfiguration.getInstance().getDrops(name);
                if (!drops.isEmpty()) {
                    for (int i = 0; i < drops.size(); ++i) {
                        src.sendMessage((Text)Text.of((String)("[" + i + "] X:" + drops.get(i).getBlockX() + ", Y:" + drops.get(i).getBlockY() + ", Z:" + drops.get(i).getBlockZ() + "(" + ((World)drops.get(i).getExtent()).getName() + ")")));
                    }
                } else {
                    src.sendMessage((Text)Text.of((String)"No drops found"));
                }
                return CommandResult.success();
            }
            if (this.mode == 1) {
                if (args.hasAny("x") && args.hasAny("y") && args.hasAny("z")) {
                    int x = (Integer)args.getOne("x").get();
                    int y = (Integer)args.getOne("y").get();
                    int z = (Integer)args.getOne("z").get();
                    World world = Methods.getWorld(args);
                    int id = SetupConfiguration.getInstance().getDropId(name);
                    src.sendMessage(TextLibs.pluginMessage("set drop " + id + " for Party " + name));
                    SetupConfiguration.getInstance().addDrop(src, name, (Location<World>)new Location((Extent)world, x, y, z));
                    return CommandResult.success();
                }
                if (src instanceof Player) {
                    Player player = (Player)src;
                    SetupConfiguration.getInstance().addDrop(src, name, (Location<World>)player.getLocation());
                    return CommandResult.success();
                }
                src.sendMessage(TextLibs.pluginError("You must set the coords of a drop while in console"));
                return CommandResult.builder().successCount(Integer.valueOf(0)).build();
            }
            if (args.hasAny("id")) {
                int id = (Integer)args.getOne("id").get();
                SetupConfiguration.getInstance().removeDrop(src, name, id);
            }
        }
        return CommandResult.success();
    }
}

