/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.config.DropConfiguration;
import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DropPartyDropListExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        int mode = 0;
        if (args.hasAny("sub")) {
            mode = (Integer)args.getOne("sub").get();
        }
        if (args.hasAny("name")) {
            String name = (String)args.getOne("name").get();
            if (mode == 0) {
                Map<ItemStack, Integer> map = DropConfiguration.getInstance().getMap(name);
                if (map != null && !map.isEmpty()) {
                    TextLibs.sendMessage(src, "Current Items in the '" + name + "' DropList:");
                    for (ItemStack item : map.keySet()) {
                        TextLibs.sendMessage(src, (Text)Text.of((String)("            " + item.getTranslation().get() + " (x" + map.get(item) + ")")));
                    }
                } else {
                    TextLibs.sendError(src, "The DropList '" + name + "' has not been created yet, or the list is empty.");
                }
                return CommandResult.success();
            }
            if (mode == 1) {
                if (src instanceof Player) {
                    Player player = (Player)src;
                    if (player.getEquipped((EquipmentType)EquipmentTypes.MAIN_HAND).isPresent()) {
                        ItemStack type = (ItemStack)player.getEquipped((EquipmentType)EquipmentTypes.MAIN_HAND).get();
                        DropConfiguration.getInstance().addDropListItem(src, name, type);
                        return CommandResult.success();
                    }
                    TextLibs.sendError(src, "You must be holding an Item in your hand to add it to the '" + name + "' DropList");
                    return CommandResult.builder().successCount(Integer.valueOf(0)).build();
                }
                TextLibs.sendError(src, "You must be a player to add items to the '" + name + "' DropList");
                return CommandResult.builder().successCount(Integer.valueOf(0)).build();
            }
            if (mode == 2) {
                if (src instanceof Player) {
                    Player player = (Player)src;
                    if (player.getEquipped((EquipmentType)EquipmentTypes.MAIN_HAND).isPresent()) {
                        ItemStack type = (ItemStack)player.getEquipped((EquipmentType)EquipmentTypes.MAIN_HAND).get();
                        DropConfiguration.getInstance().removeDropListItem(src, name, type);
                        return CommandResult.success();
                    }
                    TextLibs.sendError(src, "You must be holding an Item in your hand to remove it from the '" + name + "' DropList");
                    return CommandResult.builder().successCount(Integer.valueOf(0)).build();
                }
                TextLibs.sendError(src, "You must be a player to remove items from the '" + name + "' DropList");
                return CommandResult.builder().successCount(Integer.valueOf(0)).build();
            }
            if (mode == 3) {
                DropConfiguration.getInstance().removeAll(name);
                TextLibs.sendMessage(src, "Cleared all Items from the '" + name + "' DropList");
                return CommandResult.success();
            }
            if (mode == 4) {
                if (args.hasAny("party")) {
                    String party = (String)args.getOne("party").get();
                    if (!SetupConfiguration.getInstance().doesPartyExist(party)) {
                        TextLibs.sendError(src, "Party does not exist");
                        return CommandResult.empty();
                    }
                    List<Location<World>> chests = SetupConfiguration.getInstance().getChests(party);
                    if (chests.isEmpty() || chests == null) {
                        TextLibs.sendError(src, "There are no chests defined for the party");
                        return CommandResult.empty();
                    }
                    for (Location<World> chest : chests) {
                        if (!chest.getBlock().getType().equals(BlockTypes.CHEST)) {
                            TextLibs.pluginError("Chest at X:" + chest.getBlockX() + " Y:" + chest.getBlockY() + " Z:" + chest.getBlockZ() + " is not found, skipping it.");
                            continue;
                        }
                        TileEntityInventory inv = Methods.getCarrier(chest).getInventory();
                        if (inv == null) continue;
                        for (Inventory slot : inv.slots()) {
                            Optional stackOptional = slot.peek();
                            if (!stackOptional.isPresent()) continue;
                            ItemStack item = (ItemStack)stackOptional.get();
                            DropConfiguration.getInstance().addDropListItem(src, name, item);
                            TextLibs.sendConsoleMessage("Added Item to droplist");
                        }
                    }
                } else {
                    TextLibs.sendError(src, "You must specify a DropParty Setup to add Items from");
                }
            } else {
                if (!DropConfiguration.getInstance().doesDropListExist(name)) {
                    String playername = src instanceof Player ? ((Player)src).getName() : "Console";
                    DropConfiguration.getInstance().createDropList(src, name, playername);
                    return CommandResult.builder().successCount(Integer.valueOf(0)).build();
                }
                TextLibs.sendError(src, "The DropList '" + name + "' already exists");
                return CommandResult.success();
            }
        }
        return CommandResult.builder().successCount(Integer.valueOf(0)).build();
    }
}

