/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DropPartyRenameExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        String name = (String)args.getOne("name").get();
        String newname = (String)args.getOne("newname").get();
        String creator = src instanceof Player ? ((Player)src).getName() : "Console";
        SetupConfiguration config = SetupConfiguration.getInstance();
        config.createParty(src, newname, creator);
        List<Location<World>> chests = config.getChests(name);
        for (int i = chests.size() - 1; i >= 0; --i) {
            config.addChest(src, newname, chests.get(i));
            config.removeChest(src, name, i);
        }
        List<Location<World>> drops = config.getDrops(name);
        for (int j = drops.size() - 1; j >= 0; --j) {
            config.addDrop(src, newname, drops.get(j));
            config.removeDrop(src, name, j);
        }
        config.removeParty(src, name);
        TextLibs.sendMessage(src, "Successfully renamed DropParty " + name + " to " + newname + "!");
        return CommandResult.success();
    }
}

