/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.commands;

import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.List;
import java.util.Random;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DropPartyTpExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Player player;
        String name = (String)args.getOne("name").get();
        Random rand = new Random();
        if (args.hasAny("player")) {
            player = (Player)args.getOne("player").get();
        } else if (src instanceof Player) {
            player = (Player)src;
        } else {
            TextLibs.sendError(src, "When using console, you must specify a player.");
            return CommandResult.builder().successCount(Integer.valueOf(0)).build();
        }
        List<Location<World>> drops = SetupConfiguration.getInstance().getDrops(name);
        Location<World> drop = drops.get(rand.nextInt(drops.size()));
        TextLibs.sendConsoleMessage("Drop Location [" + name + "]: " + drop.toString());
        for (int y = drop.getBlockY(); y > 0; --y) {
            Location loc = new Location(drop.getExtent(), drop.getX() + 0.5, (double)y + 2.5, drop.getZ() + 0.5);
            if (!loc.getBlock().getType().equals(BlockTypes.AIR)) {
                player.setLocation(loc);
                TextLibs.sendPlayerMessage(player, "Welcome to the " + name + " party!");
                TextLibs.sendConsoleMessage("Teleported " + player.getName() + " to the " + name + " party!");
                break;
            }
            TextLibs.sendError(src, "Block type: " + loc.getBlock().getType().getName() + ", Location: " + loc.toString());
        }
        return CommandResult.success();
    }
}

