/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.config;

import java.io.File;
import java.io.IOException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;

public class DefaultConfiguration {
    private static DefaultConfiguration instance = new DefaultConfiguration();
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private CommentedConfigurationNode config;

    public static DefaultConfiguration getInstance() {
        return instance;
    }

    public void setup(File configFile, ConfigurationLoader<CommentedConfigurationNode> loader) {
        this.loader = loader;
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                this.loadConfig();
                this.config.getNode(new Object[]{"DropParty", "Tier Drops"}).setComment("All values must be integers");
                this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier 0"}).setValue((Object)50);
                this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier 1"}).setValue((Object)25);
                this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier 2"}).setValue((Object)15);
                this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier 3"}).setValue((Object)10);
                this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier 4"}).setValue((Object)5);
                this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier 5"}).setValue((Object)1);
                this.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.loadConfig();
        }
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.loader.save((ConfigurationNode)this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        try {
            this.config = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getTierChance(int tier) {
        return this.config.getNode(new Object[]{"DropParty", "Tier Drops", "Tier " + tier}).getInt();
    }

    public int getTotalChance() {
        int total = 0;
        for (int i = 0; i < 6; ++i) {
            total += this.getTierChance(i);
        }
        return total;
    }

    public int getTierRange(int tier) {
        int range = 0;
        for (int i = 0; i <= tier; ++i) {
            range += this.getTierChance(i);
        }
        return range;
    }

    public int[] getRange() {
        return new int[]{this.getTierRange(0), this.getTierRange(1), this.getTierRange(2), this.getTierRange(3), this.getTierRange(4), this.getTierRange(5)};
    }
}

