/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.config;

import com.github.elrol.dropparty.libs.TextLibs;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackComparators;

public class DropConfiguration {
    private static DropConfiguration instance = new DropConfiguration();
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private CommentedConfigurationNode config;

    public static DropConfiguration getInstance() {
        return instance;
    }

    public void setup(File configFile, ConfigurationLoader<CommentedConfigurationNode> loader) {
        this.loader = loader;
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                this.loadConfig();
                this.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.loadConfig();
        }
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.loader.save((ConfigurationNode)this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        try {
            this.config = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createDropList(CommandSource src, String name, String playername) {
        if (!this.doesDropListExist(name)) {
            this.loadConfig();
            this.config.getNode(new Object[]{"DropLists", name, "creator"}).setValue((Object)playername);
            this.saveConfig();
            TextLibs.sendMessage(src, "Created the '" + name + "' Drop List");
        } else {
            TextLibs.sendError(src, "The DropList '" + name + "' already exists");
        }
    }

    public void removeDropList(CommandSource src, String name) {
        if (this.doesDropListExist(name)) {
            this.loadConfig();
            this.config.getNode(new Object[]{"DropLists", name}).setValue(null);
            this.saveConfig();
            TextLibs.sendMessage(src, "The DropList '" + name + "' was removed");
        } else {
            TextLibs.sendError(src, "The DropList '" + name + "' already exists");
        }
    }

    public boolean doesDropListExist(String name) {
        this.loadConfig();
        Iterator iterator = this.config.getChildrenMap().keySet().iterator();
        if (iterator.hasNext()) {
            Object node = iterator.next();
            if (node.equals(name)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void addDropListItem(CommandSource src, String name, ItemStack type) {
        if (this.doesDropListExist(name)) {
            this.addItem(name, type);
            TextLibs.sendMessage(src, "'" + type.getTranslation().get() + "' was added to the DropList '" + name + "'");
        } else {
            TextLibs.sendError(src, "The DropList '" + name + "' doesn't exist");
        }
    }

    public void removeDropListItem(CommandSource src, String name, ItemStack type) {
        if (this.doesDropListExist(name)) {
            if (this.doesItemExist(name, type)) {
                this.removeItem(name, type);
                TextLibs.sendMessage(src, "'" + type.getTranslation().get() + "' was removed from the DropList '" + name + "'");
            } else {
                TextLibs.sendError(src, "'" + type.getTranslation().get() + "' is not int the DropList '" + name + "'");
            }
        } else {
            TextLibs.sendError(src, "The DropList '" + name + "' doesn't exist");
        }
    }

    public boolean doesItemExist(String name, ItemStack type) {
        List<ItemStack> items = this.getList(name);
        if (items != null && !items.isEmpty()) {
            for (ItemStack stack : items) {
                if (!stack.getType().equals(type.getType()) || ItemStackComparators.ITEM_DATA.compare(type, stack) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getList(String name) {
        List<Object> items = new ArrayList<ItemStack>();
        if (this.doesDropListExist(name)) {
            try {
                this.loadConfig();
                List temp = (List)this.config.getNode(new Object[]{"DropLists", name, "Items"}).getValue((TypeToken)new TypeToken<List<ItemStack>>(){});
                if (temp != null) {
                    items = temp;
                }
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        }
        return items;
    }

    public Map<ItemStack, Integer> getMap(String name) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        List<ItemStack> list = this.getList(name);
        if (list != null && !list.isEmpty()) {
            for (ItemStack stack : list) {
                ItemStack single = stack.copy();
                single.setQuantity(1);
                if (map.containsKey(single)) {
                    int qty = (Integer)map.get(single);
                    map.put(single, qty += stack.getQuantity());
                    continue;
                }
                map.put(single, stack.getQuantity());
            }
        }
        return map;
    }

    public void addItem(String name, ItemStack type) {
        this.loadConfig();
        try {
            List<ItemStack> items = this.getList(name);
            items.add(type);
            this.config.getNode(new Object[]{"DropLists", name, "Items"}).setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, items);
            this.saveConfig();
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public void removeItem(String name, ItemStack item) {
        this.loadConfig();
        List<ItemStack> items = this.getList(name);
        for (ItemStack stack : new ArrayList<ItemStack>(items)) {
            if (!stack.getType().equals(item.getType()) || ItemStackComparators.ITEM_DATA.compare(item, stack) != 0) continue;
            try {
                items.remove(stack);
                this.config.getNode(new Object[]{"DropLists", name, "Items"}).setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, items);
                this.saveConfig();
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAll(String name) {
        try {
            List<ItemStack> items = this.getList(name);
            items.clear();
            this.loadConfig();
            this.config.getNode(new Object[]{"DropLists", name, "Items"}).setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, items);
            this.saveConfig();
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public List<String> getDrops() {
        this.loadConfig();
        ArrayList<String> list = new ArrayList<String>();
        for (Object node : this.config.getNode(new Object[]{"DropLists"}).getChildrenMap().keySet()) {
            list.add((String)node);
        }
        return list;
    }
}

