/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.config;

import com.github.elrol.dropparty.Main;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class SetupConfiguration {
    private static SetupConfiguration instance = new SetupConfiguration();
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private CommentedConfigurationNode config;

    public static SetupConfiguration getInstance() {
        return instance;
    }

    public void setup(File configFile, ConfigurationLoader<CommentedConfigurationNode> loader) {
        this.loader = loader;
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                this.loadConfig();
                this.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.loadConfig();
        }
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.loader.save((ConfigurationNode)this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        try {
            this.config = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createParty(CommandSource src, String name, String playerName) {
        if (!this.doesPartyExist(name)) {
            this.loadConfig();
            this.config.getNode(new Object[]{"DropParties", name});
            this.config.getNode(new Object[]{"DropParties", name, "creator"}).setValue((Object)playerName);
            this.config.getNode(new Object[]{"DropParties", name, "settings", "chests"});
            this.config.getNode(new Object[]{"DropParties", name, "settings", "drops"});
            this.saveConfig();
            TextLibs.sendMessage(src, "Created the '" + name + "' DropParty Setup");
        } else {
            TextLibs.sendError(src, "The DropParty Setup '" + name + "' already exists");
        }
    }

    public void removeParty(CommandSource src, String name) {
        if (this.doesPartyExist(name)) {
            this.loadConfig();
            this.config.getNode(new Object[]{"DropParties", name}).setValue(null);
            this.saveConfig();
            TextLibs.sendMessage(src, "Removed the '" + name + "' DropParty Setup");
        } else {
            TextLibs.sendError(src, "The DropParty Setup '" + name + "' does not exist");
        }
    }

    public void addChest(CommandSource src, String name, Location<World> loc) {
        if (this.doesPartyExist(name)) {
            int id = this.getChestId(name);
            if (this.doesChestExist(name, id, loc)) {
                TextLibs.sendError(src, "Duplicate chest located at: X:" + loc.getBlockX() + ", Y:" + loc.getBlockY() + ", Z:" + loc.getBlockZ() + "(" + ((World)loc.getExtent()).getName() + ")");
            } else if (loc.getBlock().getType().equals(BlockTypes.CHEST)) {
                this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "x"}).setValue((Object)loc.getBlockX());
                this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "y"}).setValue((Object)loc.getBlockY());
                this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "z"}).setValue((Object)loc.getBlockZ());
                this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "dim"}).setValue((Object)((World)loc.getExtent()).getUniqueId().toString());
                this.saveConfig();
                TextLibs.sendMessage(src, "set chest '" + id + "' for Party '" + name + "'");
            } else {
                TextLibs.sendError(src, "No chest found at that location.");
            }
        } else {
            TextLibs.sendError(src, "The DropParty Setup '" + name + "' does not exist");
        }
    }

    public void removeChest(CommandSource src, String name, int id) {
        if (this.doesPartyExist(name)) {
            if (this.doesChestExist(name, id)) {
                this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id}).setValue(null);
                TextLibs.sendMessage(src, "Chest '" + id + "' from: '" + name + "' was removed");
                this.saveConfig();
                return;
            }
            TextLibs.sendError(src, "Chest '" + id + "' from: '" + name + "' was not found, could not remove");
            return;
        }
        TextLibs.sendError(src, "The DropParty Setup '" + name + "' does not exist");
    }

    public void addDrop(CommandSource src, String name, Location<World> loc) {
        if (this.doesPartyExist(name)) {
            int id = this.getDropId(name);
            if (this.doesDropExist(name, id, loc)) {
                TextLibs.sendError(src, "Duplicate drop located at: X:" + loc.getBlockX() + ", Y:" + loc.getBlockY() + ", Z:" + loc.getBlockZ() + "(" + ((World)loc.getExtent()).getName() + ")");
                return;
            }
            if (loc.getBlock().getType().equals(BlockTypes.AIR)) {
                this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "x"}).setValue((Object)loc.getBlockX());
                this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "y"}).setValue((Object)loc.getBlockY());
                this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "z"}).setValue((Object)loc.getBlockZ());
                this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "dim"}).setValue((Object)((World)loc.getExtent()).getUniqueId().toString());
                this.saveConfig();
                TextLibs.sendMessage(src, "set drop '" + id + "' for Party '" + name + "'");
                return;
            }
            TextLibs.sendError(src, "Location is blocked, remove block and try again.");
            return;
        }
        TextLibs.sendError(src, "The DropParty Setup '" + name + "' does not exist");
    }

    public void removeDrop(CommandSource src, String name, int id) {
        if (this.doesPartyExist(name)) {
            if (this.doesDropExist(name, id)) {
                this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id}).setValue(null);
                TextLibs.sendMessage(src, "Drop '" + id + "' from: '" + name + "' was removed");
                this.saveConfig();
                return;
            }
            TextLibs.sendError(src, "Drop '" + id + "' from: '" + name + "' was not found, could not remove");
            return;
        }
        TextLibs.sendError(src, "The DropParty Setup '" + name + "' does not exist");
    }

    public int getChestId(String name) {
        List chests = this.config.getNode(new Object[]{"DropParties", name, "settings", "chests"}).getChildrenList();
        if (chests.isEmpty()) {
            return 0;
        }
        return chests.size();
    }

    public int getDropId(String name) {
        List drops = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops"}).getChildrenList();
        if (drops.isEmpty()) {
            return 0;
        }
        return drops.size();
    }

    public boolean doesPartyExist(String name) {
        return this.config.getNode(new Object[]{"DropParties", name, "creator"}).getString() != null;
    }

    public List<Location<World>> getChests(String name) {
        this.loadConfig();
        int chestQty = this.config.getNode(new Object[]{"DropParties", name, "settings", "chests"}).getChildrenList().size();
        ArrayList<Location<World>> chests = new ArrayList<Location<World>>();
        for (int id = 0; id < chestQty; ++id) {
            try {
                int x = this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "x"}).getInt();
                int y = this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "y"}).getInt();
                int z = this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "z"}).getInt();
                UUID dim = UUID.fromString(this.config.getNode(new Object[]{"DropParties", name, "settings", "chests", id, "dim"}).getString());
                Optional world = Sponge.getServer().getWorld(dim);
                if (!world.isPresent()) {
                    TextLibs.sendConsoleError("UUID for world was invalid: " + dim);
                    continue;
                }
                Location loc = new Location((Extent)world.get(), x, y, z);
                if (loc.getBlock().getType().equals(BlockTypes.CHEST) || loc.getBlock().getType().equals(BlockTypes.TRAPPED_CHEST)) {
                    chests.add((Location<World>)loc);
                    continue;
                }
                this.removeChest((CommandSource)Sponge.getServer().getConsole(), name, id);
                TextLibs.sendConsoleError("Chest at X: " + x + ", Y: " + y + ", Z: " + z + " was missing, and was removed from the party");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return chests;
    }

    public boolean doesChestExist(String name, int id, Location<World> pos) {
        for (Location<World> chest : this.getChests(name)) {
            if (!((World)chest.getExtent()).getUniqueId().equals(((World)pos.getExtent()).getUniqueId()) || chest.getBlockX() != pos.getBlockX() || chest.getBlockY() != pos.getBlockY() || chest.getBlockZ() != pos.getBlockZ()) continue;
            return true;
        }
        return false;
    }

    public boolean doesChestExist(String name, int id) {
        return this.getChests(name).get(id) != null;
    }

    public List<Location<World>> getDrops(String name) {
        this.loadConfig();
        int dropQty = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops"}).getChildrenList().size();
        ArrayList<Location<World>> drops = new ArrayList<Location<World>>();
        for (int id = 0; id < dropQty; ++id) {
            try {
                int x = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "x"}).getInt();
                int y = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "y"}).getInt();
                int z = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "z"}).getInt();
                UUID dim = UUID.fromString(this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "dim"}).getString());
                Optional world = Sponge.getServer().getWorld(dim);
                if (!world.isPresent()) {
                    TextLibs.sendConsoleError("UUID for world was invalid: " + dim);
                    continue;
                }
                Location loc = new Location((Extent)world.get(), x, y, z);
                drops.add((Location<World>)loc);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return drops;
    }

    public boolean doesDropExist(String name, int id, Location<World> loc) {
        int max = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops"}).getChildrenList().size();
        if (id < max && !this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "y"}).isVirtual()) {
            return true;
        }
        for (Location<World> dropPos : this.getDrops(name)) {
            if (!dropPos.equals(loc)) continue;
            return true;
        }
        return false;
    }

    public boolean doesDropExist(String name, int id) {
        int max = this.config.getNode(new Object[]{"DropParties", name, "settings", "drops"}).getChildrenList().size();
        return id < max && !this.config.getNode(new Object[]{"DropParties", name, "settings", "drops", id, "y"}).isVirtual();
    }

    public void listParties(CommandSource src) {
        this.loadConfig();
        for (Object node : this.config.getNode(new Object[]{"DropParties"}).getChildrenMap().keySet()) {
            int i;
            TextLibs.sendMessage(src, (Text)Text.of((String)("            " + node)));
            TextLibs.sendMessage(src, (Text)Text.of((String)"               Chests{"));
            if (this.getChests((String)node).isEmpty()) {
                TextLibs.sendMessage(src, Text.of((Object[])new Object[]{"                  ", TextColors.RED, "No Chests Set"}));
            } else {
                i = 0;
                for (Location<World> chest : this.getChests((String)node)) {
                    TextLibs.sendMessage(src, (Text)Text.of((String)("                  [" + i + "] { Dim: " + ((World)chest.getExtent()).getName() + " X: " + chest.getBlockX() + " Y: " + chest.getBlockY() + " Z: " + chest.getBlockZ() + " }")));
                    ++i;
                }
            }
            TextLibs.sendMessage(src, (Text)Text.of((String)"               }"));
            TextLibs.sendMessage(src, (Text)Text.of((String)"               Drops{"));
            if (this.getDrops((String)node).isEmpty()) {
                TextLibs.sendMessage(src, Text.of((Object[])new Object[]{"                  ", TextColors.RED, "No Drops Set"}));
            } else {
                i = 0;
                for (Location<World> drop : this.getDrops((String)node)) {
                    TextLibs.sendMessage(src, (Text)Text.of((String)("                  [" + i + "] { Dim: " + ((World)drop.getExtent()).getName() + " X: " + drop.getBlockX() + " Y: " + drop.getBlockY() + " Z: " + drop.getZ() + " }")));
                    ++i;
                }
            }
            TextLibs.sendMessage(src, (Text)Text.of((String)"               }"));
        }
    }

    public List<String> getParties() {
        this.loadConfig();
        ArrayList<String> list = new ArrayList<String>();
        for (Object node : this.config.getNode(new Object[]{"DropParties"}).getChildrenMap().keySet()) {
            list.add((String)node);
        }
        return list;
    }

    public void spawnItemAtDrop(String name, ItemStack item) {
        Main.getInstance().getLogger().debug("attempting to spawn item");
        List<Location<World>> drops = this.getDrops(name);
        Random rand = new Random();
        Location<World> loc = drops.get(rand.nextInt(drops.size()));
        Entity itemEntity = loc.createEntity(EntityTypes.ITEM);
        Item items = (Item)itemEntity;
        items.offer(Keys.REPRESENTED_ITEM, (Object)item.createSnapshot());
        loc.spawnEntity((Entity)items);
    }

    public int getPartyItemQty(String name) {
        List<Location<World>> chests = this.getChests(name);
        int totalItems = 0;
        for (Location<World> chest : chests) {
            for (Inventory inv : Methods.getCarrier(chest).getInventory()) {
                totalItems += inv.totalItems();
            }
        }
        TextLibs.sendConsoleMessage("Total Items: " + totalItems);
        return totalItems;
    }

    public void setPartyCost(String name, int cost) {
        this.config.getNode(new Object[]{"DropParties", name, "settings", "cost"}).setValue((Object)cost);
        this.saveConfig();
    }

    public int getPartyCost(String name) {
        return this.config.getNode(new Object[]{"DropParties", name, "settings", "cost"}).getInt();
    }
}

