/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.config;

import com.github.elrol.dropparty.libs.TextLibs;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackComparators;

public class TierConfiguration {
    private static TierConfiguration instance = new TierConfiguration();
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    private CommentedConfigurationNode config;
    private List<ItemStack> tier1Items = new ArrayList<ItemStack>();
    private List<ItemStack> tier2Items = new ArrayList<ItemStack>();
    private List<ItemStack> tier3Items = new ArrayList<ItemStack>();
    private List<ItemStack> tier4Items = new ArrayList<ItemStack>();
    private List<ItemStack> tier5Items = new ArrayList<ItemStack>();

    public static TierConfiguration getInstance() {
        return instance;
    }

    public void setup(File configFile, ConfigurationLoader<CommentedConfigurationNode> loader) {
        this.loader = loader;
        this.loadDefaults();
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                this.loadConfig();
                try {
                    this.config.getNode(new Object[]{"Tier 1"}).setComment("A list of Items that are Uncommon").setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, this.tier1Items);
                    this.config.getNode(new Object[]{"Tier 2"}).setComment("A list of Items that are Rare").setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, this.tier2Items);
                    this.config.getNode(new Object[]{"Tier 3"}).setComment("A list of Items that are Epic").setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, this.tier3Items);
                    this.config.getNode(new Object[]{"Tier 4"}).setComment("A list of Items that are Legendary").setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, this.tier4Items);
                    this.config.getNode(new Object[]{"Tier 5"}).setComment("A list of Items that are Mythic").setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, this.tier5Items);
                }
                catch (ObjectMappingException objectMappingException) {
                    // empty catch block
                }
                this.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.loadConfig();
        }
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.loader.save((ConfigurationNode)this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfig() {
        try {
            this.config = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadDefaults() {
        this.tier1Items.add(ItemStack.builder().itemType(ItemTypes.IRON_INGOT).quantity(1).build());
        this.tier2Items.add(ItemStack.builder().itemType(ItemTypes.GOLD_INGOT).quantity(1).build());
        this.tier3Items.add(ItemStack.builder().itemType(ItemTypes.DIAMOND).quantity(1).build());
        this.tier4Items.add(ItemStack.builder().itemType(ItemTypes.EMERALD).quantity(1).build());
        this.tier5Items.add(ItemStack.builder().itemType(ItemTypes.NETHER_STAR).quantity(1).build());
    }

    public void addItem(CommandSource src, int tier, ItemStack type) {
        this.loadConfig();
        try {
            List<Object> items = new ArrayList();
            if (this.getTier(tier) != null) {
                items = this.getTier(tier);
            }
            if (!this.isItemListed(type)) {
                items.add(type);
                this.config.getNode(new Object[]{"Tier " + tier}).setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, items);
                this.saveConfig();
                TextLibs.sendMessage(src, "Successfully added '" + type.getTranslation().get() + "' to 'Tier " + tier + "'");
                return;
            }
            TextLibs.sendError(src, "Couldn't add '" + type + "' to 'Tier " + tier + "'");
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public boolean isItemListed(ItemStack type) throws ObjectMappingException {
        for (int i = 1; i < 6; ++i) {
            if (!this.isItemListed(i, type)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemListed(int tier, ItemStack type) {
        this.loadConfig();
        if (tier == 0) {
            for (int i = 1; i < 6; ++i) {
                if (this.getTier(i) == null) continue;
                for (ItemStack stack : this.getTier(i)) {
                    if (!stack.getType().equals(type.getType()) || ItemStackComparators.ITEM_DATA.compare(type, stack) != 0) continue;
                    return false;
                }
            }
            return true;
        }
        List<ItemStack> items = this.getTier(tier);
        if (items != null && !items.isEmpty()) {
            for (ItemStack stack : items) {
                if (!stack.getType().equals(type.getType()) || ItemStackComparators.ITEM_DATA.compare(type, stack) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getTier(int tier) {
        List<Object> list = new ArrayList<ItemStack>();
        this.loadConfig();
        try {
            List temp = (List)this.config.getNode(new Object[]{"Tier " + tier}).getValue((TypeToken)new TypeToken<List<ItemStack>>(){});
            if (temp != null) {
                list = temp;
            }
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void removeItem(CommandSource src, int tier, ItemStack item) {
        this.loadConfig();
        List<ItemStack> items = this.getTier(tier);
        for (ItemStack stack : new ArrayList<ItemStack>(items)) {
            if (!stack.getType().equals(item.getType()) || ItemStackComparators.ITEM_DATA.compare(item, stack) != 0) continue;
            try {
                items.remove(stack);
                this.config.getNode(new Object[]{"Tier " + tier}).setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, items);
                TextLibs.sendMessage(src, "'" + item.getTranslation().get() + "' was removed from 'Tier " + tier + "'");
                this.saveConfig();
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        }
    }

    public void clearTier(CommandSource src, int tier) {
        this.loadConfig();
        ArrayList items = new ArrayList();
        try {
            this.config.getNode(new Object[]{"Tier " + tier}).setValue((TypeToken)new TypeToken<List<ItemStack>>(){}, items);
            TextLibs.sendMessage(src, "Cleared 'Tier " + tier + "' of all Items");
            this.saveConfig();
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }
}

