/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.events;

import com.github.elrol.dropparty.Main;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.title.Title;

public class Countdown {
    private int time;
    private Task titleTask;
    private Task secIntervalTask;
    private ServerBossBar bar;
    private Title title;

    public Countdown(Runnable runnable, int length, ServerBossBar bossBar, Title title, Main plugin) {
        plugin.getLogger().debug("Countdown");
        this.bar = bossBar;
        this.bar.setPercent(1.0f);
        this.bar.addPlayers(Sponge.getServer().getOnlinePlayers());
        this.time = length;
        if (title != null) {
            this.title = title;
            this.titleTask = Sponge.getScheduler().createTaskBuilder().delay((long)((double)length * 0.9), TimeUnit.SECONDS).execute(() -> {
                for (Player p : Sponge.getServer().getOnlinePlayers()) {
                    p.sendTitle(title);
                }
            }).submit((Object)plugin);
        }
        this.secIntervalTask = Sponge.getScheduler().createTaskBuilder().interval(1L, TimeUnit.SECONDS).execute(() -> {
            if (this.time == -1) {
                this.bar.removePlayers(this.bar.getPlayers()).addPlayers(Sponge.getServer().getOnlinePlayers());
            } else if (this.time > 0) {
                --this.time;
                float percent = (float)this.time / (float)length;
                this.bar.setPercent(percent).removePlayers(this.bar.getPlayers()).addPlayers(Sponge.getServer().getOnlinePlayers());
            } else {
                if (title != null) {
                    this.titleTask.cancel();
                }
                this.bar.removePlayers(this.bar.getPlayers());
                runnable.run();
                this.secIntervalTask.cancel();
            }
        }).submit((Object)plugin);
    }

    public void cancel() {
        this.bar.removePlayers(this.bar.getPlayers());
        this.secIntervalTask.cancel();
        if (this.title != null) {
            this.titleTask.cancel();
        }
    }
}

