/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.events;

import com.github.elrol.dropparty.Main;
import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.events.Countdown;
import com.github.elrol.dropparty.events.DropPartyRunnable;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class DropPartyEvent {
    private Title dropPartyAnnouncement;
    protected String name;
    Task timeRemainingLoop;
    Task dropParty;
    private int timeLeft;
    protected int duration;
    private Countdown cd;
    private Player initiator;
    private int itemsPerSec;
    private boolean isAdmin;
    private ServerBossBar bar;

    protected DropPartyEvent(Player player, String name, int time, int itemsPerSec, boolean isAdmin) {
        this.name = name;
        this.initiator = player;
        this.duration = time;
        this.isAdmin = isAdmin;
        this.itemsPerSec = itemsPerSec;
        this.init();
    }

    protected DropPartyEvent(Player player, String name, int itemsPerSec, boolean isAdmin) {
        this.name = name;
        this.initiator = player;
        this.duration = Math.round((float)SetupConfiguration.getInstance().getPartyItemQty(name) / (float)itemsPerSec + 0.5f);
        this.isAdmin = isAdmin;
        this.itemsPerSec = itemsPerSec;
        this.init();
    }

    private void init() {
        ArrayList<Inventory> chests = new ArrayList<Inventory>();
        String initName = "Console";
        if (this.initiator != null) {
            initName = this.initiator.getName();
        }
        if (this.duration <= 0) {
            this.duration = -1;
        }
        this.dropPartyAnnouncement = Title.builder().title(Text.of((Object[])new Object[]{TextColors.BLUE, "Starting DropParty '" + this.name + "'"})).subtitle(Text.of((Object[])new Object[]{TextColors.AQUA, "Hosted by: " + initName})).stay(Integer.valueOf(100)).build();
        this.bar = this.isAdmin ? ServerBossBar.builder().color(BossBarColors.YELLOW).overlay(BossBarOverlays.PROGRESS).name(Text.of((Object[])new Object[]{TextColors.GOLD, "DropParty '" + this.name + "' has started! Use '/dp tp " + this.name + "' to join!"})).build() : ServerBossBar.builder().color(BossBarColors.PURPLE).overlay(BossBarOverlays.PROGRESS).name(Text.of((Object[])new Object[]{TextColors.LIGHT_PURPLE, "DropParty '" + this.name + "' has started! Use '/dp tp " + this.name + "' to join!"})).build();
        this.cd = new Countdown(() -> this.endEvent(), this.duration, this.bar, null, Main.getInstance());
        Methods.broadcastTitle(this.dropPartyAnnouncement);
        Sponge.getServer().getBroadcastChannel().send(Text.of((Object[])new Object[]{TextLibs.pluginHeader(), TextColors.GREEN, "DropParty '" + this.name + "' has started! Use '/dp tp " + this.name + "' to join!"}));
        this.timeLeft = this.duration;
        this.timeRemainingLoop = Sponge.getScheduler().createTaskBuilder().execute(() -> {
            if (this.timeLeft > 0) {
                this.remainingTime(this.timeLeft);
                this.timeLeft -= 120;
            } else {
                this.timeRemainingLoop.cancel();
            }
        }).delay(5L, TimeUnit.MINUTES).interval(2L, TimeUnit.MINUTES).submit((Object)Main.getInstance());
        TextLibs.sendConsoleMessage("Starting the party");
        this.winnerEffects();
        for (Location<World> loc : SetupConfiguration.getInstance().getChests(this.name)) {
            TileEntityInventory chest = Methods.getCarrier(loc).getInventory();
            if (chest == null) continue;
            chests.add((Inventory)chest);
        }
        this.dropParty = Sponge.getScheduler().createTaskBuilder().execute((Runnable)new DropPartyRunnable(this.name, this.itemsPerSec, chests, this.isAdmin)).interval(1L, TimeUnit.SECONDS).submit((Object)Main.getInstance());
        TextLibs.sendConsoleMessage("Starting DropParty '" + this.name + "'");
    }

    private void remainingTime(long time) {
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            player.sendMessage(ChatTypes.ACTION_BAR, Text.of((Object[])new Object[]{TextColors.AQUA, "There are ", Math.round((float)time / 60.0f), " minutes left of the '" + this.name + "' DropParty"}));
        }
    }

    private void endingParty(String name) {
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            player.sendMessage(ChatTypes.ACTION_BAR, Text.of((Object[])new Object[]{TextColors.AQUA, "DropParty ", name, " has ended. Thanks for playing!"}));
        }
    }

    public void endEvent() {
        this.endingParty(this.name);
        Main.getInstance().getLogger().debug("DropParty Ending");
        if (this.cd != null) {
            this.cd.cancel();
        }
        if (this.timeRemainingLoop != null) {
            this.timeRemainingLoop.cancel();
        }
        if (this.dropParty != null) {
            this.dropParty.cancel();
        }
        if (this.bar != null) {
            this.bar.removePlayers(this.bar.getPlayers());
        }
        this.winnerEffects();
        Main.getInstance().getEventManager().isRunning = false;
    }

    protected void winnerEffects() {
        List<Location<World>> drops = SetupConfiguration.getInstance().getDrops(this.name);
        block0: for (Location<World> drop : drops) {
            for (int y = drop.getBlockY(); y > 0; --y) {
                if (drop.getBlock().getType().equals(BlockTypes.AIR)) continue;
                Location loc = new Location(drop.getExtent(), drop.getX() + 0.5, (double)y + 1.5, drop.getZ() + 0.5);
                Task firework1 = Sponge.getScheduler().createTaskBuilder().execute(() -> Methods.spawnFirework((Location<World>)loc)).delay(1L, TimeUnit.SECONDS).interval(750L, TimeUnit.MILLISECONDS).submit((Object)Main.getInstance());
                Sponge.getScheduler().createTaskBuilder().execute(() -> firework1.cancel()).delay(3L, TimeUnit.SECONDS).submit((Object)Main.getInstance());
                ((World)loc.getExtent()).playSound(SoundTypes.ENTITY_PLAYER_LEVELUP, drop.getPosition(), 1.0);
                continue block0;
            }
        }
    }

    public String getPartyName() {
        return this.name;
    }

    public List<Location<World>> getChests() {
        ArrayList<Location<World>> chests = new ArrayList<Location<World>>();
        for (Location<World> pos : SetupConfiguration.getInstance().getChests(this.name)) {
            chests.add(pos);
        }
        return chests;
    }

    public Player getInitiator() {
        return this.initiator;
    }
}

