/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.events;

import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.events.EventManager;
import com.github.elrol.dropparty.libs.Methods;
import com.github.elrol.dropparty.libs.TextLibs;
import java.util.List;
import java.util.Random;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;

public class DropPartyRunnable
implements Runnable {
    String name;
    int itemsPerSec;
    List<Inventory> chestLocations;
    List<List<ItemStack>> partyItems;
    Random rand;
    boolean isAdmin;

    public DropPartyRunnable(String name, int itemsPerSec, List<Inventory> chestLocations, boolean isAdmin) {
        this.name = name;
        this.itemsPerSec = itemsPerSec;
        this.rand = new Random();
        this.isAdmin = isAdmin;
        this.chestLocations = chestLocations;
        this.partyItems = Methods.getTierItemsFromParty(chestLocations);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.itemsPerSec; ++i) {
            Inventory chest = this.chestLocations.get(this.rand.nextInt(this.chestLocations.size()));
            while (chest.totalItems() == 0) {
                this.chestLocations.remove(chest);
                if (this.chestLocations.isEmpty()) {
                    EventManager.getCurrentParty().endEvent();
                    return;
                }
                chest = this.chestLocations.get(this.rand.nextInt(this.chestLocations.size()));
            }
            int randSlotNum = this.rand.nextInt(chest.size());
            int tier = Methods.getRandomTier();
            int slotNum = 0;
            TextLibs.sendConsoleMessage("Starting Tier is: " + tier + ". IsEmpty: " + this.partyItems.get(tier).isEmpty());
            if (this.partyItems.get(tier).isEmpty()) {
                int t = Methods.getLowerTier(this.partyItems, tier);
                if (t == -1) {
                    t = Methods.getHigherTier(this.partyItems, tier);
                    if (t == -1) {
                        EventManager.getCurrentParty().endEvent();
                        return;
                    }
                    tier = t;
                } else {
                    tier = t;
                }
            }
            List<ItemStack> tierItems = this.partyItems.get(tier);
            TextLibs.sendConsoleMessage("Current Tier is: " + tier + ". IsEmpty: " + tierItems.isEmpty());
            int index = this.rand.nextInt(tierItems.size());
            ItemStack stack = tierItems.get(index);
            int qty = stack.getQuantity() - 1;
            if (qty == 0) {
                tierItems.remove(index);
            } else {
                stack.setQuantity(qty);
                tierItems.add(index, stack);
                stack.setQuantity(1);
            }
            for (Inventory slot : chest.slots()) {
                if (slot.totalItems() == 0) continue;
                if (slotNum == randSlotNum) {
                    ItemStack temp = (ItemStack)slot.peek(1).get();
                    if (!stack.equals(temp)) continue;
                    if (!this.isAdmin) {
                        slot.poll(1);
                    }
                    SetupConfiguration.getInstance().spawnItemAtDrop(this.name, stack);
                    return;
                }
                ++slotNum;
            }
        }
    }
}

