/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.events;

import com.github.elrol.dropparty.Main;
import com.github.elrol.dropparty.events.Countdown;
import com.github.elrol.dropparty.events.DropPartyEvent;
import com.github.elrol.dropparty.libs.TextLibs;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.title.Title;

public class EventManager {
    private static DropPartyEvent currentEvent;
    public boolean isRunning = false;
    private Countdown scheduledEvent;
    private Player initiator;
    private String partyName;

    public void startParty(Player player, String name, int time, int itemsPerSec, boolean isAdmin) {
        this.partyName = name;
        if (Sponge.getServer().getOnlinePlayers().size() >= 0) {
            currentEvent = new DropPartyEvent(player, this.partyName, time, itemsPerSec, isAdmin);
        } else {
            TextLibs.sendError((CommandSource)Sponge.getServer().getConsole(), "There are no players online, and you need people for a party");
        }
    }

    public void startParty(Player player, String name, int itemsPerSec, boolean isAdmin) {
        this.partyName = name;
        if (Sponge.getServer().getOnlinePlayers().size() >= 0) {
            currentEvent = new DropPartyEvent(player, this.partyName, itemsPerSec, isAdmin);
        } else {
            TextLibs.sendError((CommandSource)Sponge.getServer().getConsole(), "There are no players online, and you need people for a party");
        }
    }

    public static DropPartyEvent getCurrentParty() {
        return currentEvent;
    }

    public Player getInitiator() {
        return this.initiator;
    }

    protected ServerBossBar nextEventBar(String name) {
        return ServerBossBar.builder().color(BossBarColors.BLUE).name(Text.of((Object[])new Object[]{TextColors.BLUE, "DropParty starting at " + name})).overlay(BossBarOverlays.PROGRESS).build();
    }

    public void scheduleEvent(Player player, String name, Title title, int delay, int time, int itemsPerSec, boolean isAdmin) {
        if (this.isRunning) {
            TextLibs.sendConsoleMessage("A DropParty is already running, please wait until it has finished");
            return;
        }
        this.scheduledEvent = new Countdown(() -> this.startParty(player, name, time, itemsPerSec, isAdmin), delay * 60, this.nextEventBar(name), title, Main.getInstance());
        this.isRunning = true;
        this.initiator = player;
    }

    public void scheduleEvent(Player player, String name, Title title, int delay, int itemsPerSec, boolean isAdmin) {
        if (this.isRunning) {
            TextLibs.sendConsoleMessage("A DropParty is already running, please wait until it has finished");
            return;
        }
        this.scheduledEvent = new Countdown(() -> this.startParty(player, name, itemsPerSec, isAdmin), delay * 60, this.nextEventBar(name), title, Main.getInstance());
        this.isRunning = true;
        this.initiator = player;
    }

    public void stopScheduledEvent() {
        this.isRunning = false;
        if (this.scheduledEvent != null) {
            this.scheduledEvent.cancel();
        }
        if (EventManager.getCurrentParty() != null) {
            EventManager.getCurrentParty().endEvent();
        }
    }
}

