/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.dropparty.libs;

import com.github.elrol.dropparty.config.DefaultConfiguration;
import com.github.elrol.dropparty.config.SetupConfiguration;
import com.github.elrol.dropparty.config.TierConfiguration;
import com.github.elrol.dropparty.libs.TextLibs;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class Methods {
    private static final FireworkShape[] fireworkShapes = new FireworkShape[]{FireworkShapes.BALL, FireworkShapes.BURST, FireworkShapes.CREEPER, FireworkShapes.LARGE_BALL, FireworkShapes.STAR};

    public static int getRandomTier() {
        Random rand = new Random();
        int rng = rand.nextInt(DefaultConfiguration.getInstance().getTotalChance());
        int tier = 0;
        for (int m = 0; m < 6; ++m) {
            if (rng >= DefaultConfiguration.getInstance().getTierRange(m)) continue;
            tier = m;
            break;
        }
        return tier;
    }

    public static List<Location<World>> getChest(Player player) {
        ArrayList<Location<World>> chests = new ArrayList<Location<World>>();
        World world = player.getWorld();
        int originX = player.getLocation().getBlockX();
        int originY = player.getLocation().getBlockY();
        int originZ = player.getLocation().getBlockZ();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockState block = player.getWorld().getBlock(originX + i, originY + j, originZ + k);
                    if (!block.getType().equals(BlockTypes.CHEST)) continue;
                    chests.add((Location<World>)new Location((Extent)world, originX + i, originY + j, originZ + k));
                }
            }
        }
        if (chests.isEmpty()) {
            player.sendMessage(TextLibs.pluginError("No chests nearby found"));
        }
        return chests;
    }

    public static World getWorld(CommandContext args) {
        Optional worldOpt;
        World world = (World)Sponge.getServer().getWorld(Sponge.getServer().getDefaultWorldName()).get();
        if (args.hasAny("dim") && (worldOpt = Sponge.getServer().getWorld((String)args.getOne("dim").get())).isPresent()) {
            world = (World)worldOpt.get();
        }
        return world;
    }

    public static Map<String, String> getPartyNames() {
        LinkedHashMap<String, String> partyNames = new LinkedHashMap<String, String>();
        for (String party : SetupConfiguration.getInstance().getParties()) {
            partyNames.put(party, party);
        }
        return partyNames;
    }

    public static void broadcastTitle(Title title) {
        for (Player p : Sponge.getServer().getOnlinePlayers()) {
            p.sendTitle(title);
        }
    }

    public static void broadcastBossBar(ServerBossBar bar) {
        for (Player p : Sponge.getServer().getOnlinePlayers()) {
            bar.addPlayer(p);
        }
    }

    public static TileEntityCarrier getCarrier(Location<World> loc) {
        if (!loc.getBlock().getType().equals(BlockTypes.CHEST)) {
            TextLibs.pluginError("Chest at X:" + loc.getBlockX() + " Y:" + loc.getBlockY() + " Z:" + loc.getBlockZ() + " is not found, removing it.");
            return null;
        }
        return (TileEntityCarrier)loc.getTileEntity().get();
    }

    public static boolean doesPartyHaveItems(String name) {
        List<Location<World>> chests = SetupConfiguration.getInstance().getChests(name);
        for (Location<World> chest : chests) {
            for (Inventory slot : Methods.getCarrier(chest).getInventory().slots()) {
                if (slot.size() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ItemStack> getListFromTier(Inventory chests, int tier) {
        ArrayList<ItemStack> validOptions = new ArrayList<ItemStack>();
        for (Inventory slot : chests.slots()) {
            Optional opStack = slot.peek();
            if (!opStack.isPresent()) continue;
            ItemStack stack = (ItemStack)opStack.get();
            if (!TierConfiguration.getInstance().isItemListed(tier, stack)) continue;
            validOptions.add(stack);
        }
        return validOptions;
    }

    public static List<List<ItemStack>> getTierItemsFromParty(List<Inventory> chests) {
        ArrayList<List<ItemStack>> partyTierItems = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < 6; ++i) {
            for (Inventory chest : chests) {
                if (partyTierItems.isEmpty() || partyTierItems.size() <= i || partyTierItems.size() > i && ((List)partyTierItems.get(i)).isEmpty()) {
                    partyTierItems.add(Methods.getListFromTier(chest, i));
                    continue;
                }
                List stacks = (List)partyTierItems.get(i);
                stacks.addAll(Methods.getListFromTier(chest, i));
                partyTierItems.set(i, stacks);
            }
        }
        return partyTierItems;
    }

    public static int getLowerTier(List<List<ItemStack>> tierItems, int tier) {
        for (int i = tier; i >= 0; --i) {
            if (tierItems.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static int getHigherTier(List<List<ItemStack>> tierItems, int tier) {
        for (int i = tier; i < 5; ++i) {
            if (tierItems.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static void spawnFirework(Location<World> location) {
        Random rand = new Random();
        FireworkEffect effect = FireworkEffect.builder().color(Color.ofRgb((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255))).flicker(rand.nextBoolean()).shape(fireworkShapes[rand.nextInt(fireworkShapes.length)]).trail(rand.nextBoolean()).build();
        Entity firework = ((World)location.getExtent()).createEntity(EntityTypes.FIREWORK, location.getPosition());
        firework.offer(Keys.FIREWORK_EFFECTS, (Object)Lists.newArrayList((Object[])new FireworkEffect[]{effect}));
        firework.offer(Keys.FIREWORK_FLIGHT_MODIFIER, (Object)2);
        ((World)location.getExtent()).spawnEntity(firework);
    }

    public static String itemToString(ItemStack stack) {
        return "";
    }
}

