/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.CommonProxy;
import net.blay09.mods.craftingtweaks.Compatibility;
import net.blay09.mods.craftingtweaks.InternalMethodsImpl;
import net.blay09.mods.craftingtweaks.SimpleTweakProviderImpl;
import net.blay09.mods.craftingtweaks.addons.CraftingTweaksAddons;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.net.NetworkHandler;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="craftingtweaks", name="Crafting Tweaks", acceptedMinecraftVersions="[1.12]", guiFactory="net.blay09.mods.craftingtweaks.client.GuiFactory")
public class CraftingTweaks {
    public static boolean TEST_CLIENT_SIDE = false;
    public static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "craftingtweaks";
    @Mod.Instance
    public static CraftingTweaks instance;
    @SidedProxy(clientSide="net.blay09.mods.craftingtweaks.client.ClientProxy", serverSide="net.blay09.mods.craftingtweaks.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;
    private final Map<String, ModSupportState> configMap = Maps.newHashMap();
    private final Map<Class<? extends Container>, TweakProvider> providerMap = Maps.newHashMap();
    public static boolean hideButtons;
    public static boolean rightClickCraftsStack;
    public static boolean compressAnywhere;
    public static boolean hideButtonTooltips;
    public static List<String> compressBlacklist;
    public static boolean hideVanillaCraftingGuide;
    public static boolean isServerSideInstalled;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CraftingTweaksAPI.setupAPI(new InternalMethodsImpl());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.configMap.put("minecraft", ModSupportState.ENABLED);
        config = new Configuration(event.getSuggestedConfigurationFile());
        this.reloadConfig();
    }

    @Mod.EventHandler
    public void imc(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.isNBTMessage() && (message.key.equals("RegisterProvider") || message.key.equals("RegisterProviderV2") || message.key.equals("RegisterProviderV3"))) {
                String getGridStartFunction;
                String validContainerPredicate;
                NBTTagCompound tagCompound = message.getNBTValue();
                String containerClassName = tagCompound.func_74779_i("ContainerClass");
                SimpleTweakProviderImpl provider = new SimpleTweakProviderImpl(message.getSender());
                int buttonOffsetX = tagCompound.func_74764_b("ButtonOffsetX") ? tagCompound.func_74762_e("ButtonOffsetX") : -16;
                int buttonOffsetY = tagCompound.func_74764_b("ButtonOffsetY") ? tagCompound.func_74762_e("ButtonOffsetY") : 16;
                EnumFacing alignToGrid = null;
                String alignToGridName = tagCompound.func_74779_i("AlignToGrid");
                switch (alignToGridName.toLowerCase()) {
                    case "north": 
                    case "up": {
                        alignToGrid = EnumFacing.UP;
                        break;
                    }
                    case "south": 
                    case "down": {
                        alignToGrid = EnumFacing.DOWN;
                        break;
                    }
                    case "east": 
                    case "right": {
                        alignToGrid = EnumFacing.EAST;
                        break;
                    }
                    case "west": 
                    case "left": {
                        alignToGrid = EnumFacing.WEST;
                    }
                }
                provider.setAlignToGrid(alignToGrid);
                provider.setGrid(CraftingTweaks.getIntOr(tagCompound, "GridSlotNumber", 1), CraftingTweaks.getIntOr(tagCompound, "GridSize", 9));
                provider.setHideButtons(tagCompound.func_74767_n("HideButtons"));
                provider.setPhantomItems(tagCompound.func_74767_n("PhantomItems"));
                NBTTagCompound rotateCompound = tagCompound.func_74775_l("TweakRotate");
                provider.setTweakRotate(CraftingTweaks.getBoolOr(rotateCompound, "Enabled", true), CraftingTweaks.getBoolOr(rotateCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(rotateCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(rotateCompound, "ButtonY", 0));
                NBTTagCompound balanceCompound = tagCompound.func_74775_l("TweakBalance");
                provider.setTweakBalance(CraftingTweaks.getBoolOr(balanceCompound, "Enabled", true), CraftingTweaks.getBoolOr(balanceCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(balanceCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(balanceCompound, "ButtonY", 18));
                NBTTagCompound clearCompound = tagCompound.func_74775_l("TweakClear");
                provider.setTweakClear(CraftingTweaks.getBoolOr(clearCompound, "Enabled", true), CraftingTweaks.getBoolOr(clearCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(clearCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(clearCompound, "ButtonY", 36));
                String validContainerPredicateLegacy = tagCompound.func_74779_i("ContainerCallback");
                if (!validContainerPredicateLegacy.isEmpty()) {
                    try {
                        Class<?> functionClass = Class.forName(validContainerPredicateLegacy);
                        if (!Function.class.isAssignableFrom(functionClass)) {
                            logger.error(message.getSender() + " sent a container callback that's not even a function");
                            return;
                        }
                        final Function function = (Function)functionClass.newInstance();
                        provider.setContainerValidPredicate((Predicate<Container>)new com.google.common.base.Predicate<Container>(){

                            public boolean apply(@Nullable Container input) {
                                Boolean result = (Boolean)function.apply((Object)input);
                                return result != null ? result : false;
                            }
                        });
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        logger.error(message.getSender() + " sent an invalid container callback.");
                    }
                }
                if (!(validContainerPredicate = tagCompound.func_74779_i("ValidContainerPredicate")).isEmpty()) {
                    try {
                        Class<?> predicateClass = Class.forName(validContainerPredicate);
                        if (!com.google.common.base.Predicate.class.isAssignableFrom(predicateClass)) {
                            logger.error(message.getSender() + " sent an invalid ValidContainerPredicate - it must implement Predicate<Container>");
                            return;
                        }
                        com.google.common.base.Predicate predicate = (com.google.common.base.Predicate)predicateClass.newInstance();
                        provider.setContainerValidPredicate((Predicate<Container>)predicate);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        logger.error(message.getSender() + " sent an invalid ValidContainerPredicate: " + e.getMessage());
                    }
                }
                if (!(getGridStartFunction = tagCompound.func_74779_i("GetGridStartFunction")).isEmpty()) {
                    try {
                        Class<?> functionClass = Class.forName(getGridStartFunction);
                        if (!Function.class.isAssignableFrom(functionClass)) {
                            logger.error("%s sent an invalid GetGridStartFunction - it must implement Function<Container, Integer>", (Object)message.getSender());
                            return;
                        }
                        Function function = (Function)functionClass.newInstance();
                        provider.setGetGridStartFunction((java.util.function.Function<Container, Integer>)function);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        logger.error("%s sent an invalid GetGridStartFunction: %s", (Object)message.getSender(), (Object)e.getMessage());
                    }
                }
                this.registerProvider(containerClassName, provider);
                logger.info(message.getSender() + " has registered " + containerClassName + " for CraftingTweaks");
                continue;
            }
            logger.error("CraftingTweaks received an invalid IMC message from " + message.getSender());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        Compatibility.vanilla();
        CraftingTweaksAddons.postInit(event);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            this.reloadConfig();
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> map, Side side) {
        if (side == Side.SERVER) {
            isServerSideInstalled = !TEST_CLIENT_SIDE && map.containsKey(MOD_ID);
        }
        return true;
    }

    public void reloadConfig() {
        hideButtons = config.getBoolean("hideButtons", "general", false, "This option is toggled by the 'Toggle Buttons' key that can be defined in the Controls settings.");
        hideVanillaCraftingGuide = config.getBoolean("hideVanillaCraftingGuide", "general", false, "We both know JEI is much better. This option hides Vanilla's crafting book button instead of moving it.");
        rightClickCraftsStack = config.getBoolean("rightClickCraftsStack", "general", true, "If set to true, right-clicking the result slot in a crafting table will craft a full stack.");
        hideButtonTooltips = config.getBoolean("hideButtonTooltips", "general", false, "Set this to true if you don't want the tweak buttons' tooltips to show.");
        compressAnywhere = config.getBoolean("compressAnywhere", "general", false, "Set this to true if you want the (de)compress feature to work outside of crafting GUIs (only works if installed on server)");
        compressBlacklist = Lists.newArrayList((Object[])config.getStringList("compressBlacklist", "general", new String[]{"ExtraUtilities:decorativeBlock1", "minecraft:sandstone", "minecraft:iron_trapdoor"}, "A list of modid:name entries that will not be crafted by the compress key."));
        config.setCategoryComment("addons", "Here you can control whether support for a mod should be enabled, buttons_only, hotkeys_only or disabled. For Vanilla Minecraft, see the option 'minecraft'. Mods are identified by their mod ids.");
        config.getString("minecraft", "addons", ModSupportState.ENABLED.name().toLowerCase(), "", ModSupportState.getValidValues());
        for (Property property : config.getCategory("addons").values()) {
            this.configMap.put(property.getName(), ModSupportState.fromName(config.getString(property.getName(), "addons", ModSupportState.ENABLED.name().toLowerCase(), "enabled, buttons_only, hotkeys_only or disabled", ModSupportState.getValidValues())));
        }
    }

    public static void saveConfig() {
        config.get("general", "hideButtons", false, "This option is toggled by the 'Toggle Buttons' key that can be defined in the Controls settings.").set(hideButtons);
        config.save();
    }

    public <T extends Container> void registerProvider(Class<T> clazz, TweakProvider<T> provider) {
        if (!provider.getModId().equals("minecraft") && !Loader.isModLoaded((String)provider.getModId())) {
            return;
        }
        if (provider.load()) {
            this.providerMap.put(clazz, provider);
        }
    }

    private void registerProvider(String className, TweakProvider provider) {
        config.getString(provider.getModId(), "addons", ModSupportState.ENABLED.name().toLowerCase(), "enabled, buttons_only, hotkeys_only or disabled", ModSupportState.getValidValues());
        if (Loader.isModLoaded((String)provider.getModId()) && provider.load()) {
            try {
                Class<?> clazz = Class.forName(className);
                if (Container.class.isAssignableFrom(clazz)) {
                    this.providerMap.put(clazz, provider);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Nullable
    public <T extends Container> TweakProvider<T> getProvider(@Nullable T container) {
        if (container == null) {
            return null;
        }
        for (Class<? extends Container> clazz : this.providerMap.keySet()) {
            if (container.getClass() != clazz) continue;
            return this.providerMap.get(clazz);
        }
        for (Class<? extends Container> clazz : this.providerMap.keySet()) {
            if (!clazz.isAssignableFrom(container.getClass())) continue;
            return this.providerMap.get(clazz);
        }
        return null;
    }

    public ModSupportState getModSupportState(String modId) {
        ModSupportState supportState = this.configMap.get(modId);
        if (supportState == null) {
            supportState = ModSupportState.ENABLED;
            this.configMap.put(modId, supportState);
        }
        return supportState;
    }

    private static int getIntOr(NBTTagCompound tagCompound, String key, int defaultVal) {
        return tagCompound.func_74764_b(key) ? tagCompound.func_74762_e(key) : defaultVal;
    }

    private static boolean getBoolOr(NBTTagCompound tagCompound, String key, boolean defaultVal) {
        return tagCompound.func_74764_b(key) ? tagCompound.func_74767_n(key) : defaultVal;
    }

    public static enum ModSupportState {
        ENABLED,
        BUTTONS_ONLY,
        HOTKEYS_ONLY,
        DISABLED;


        public static ModSupportState fromName(String name) {
            try {
                return ModSupportState.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return ENABLED;
            }
        }

        public static String[] getValidValues() {
            ModSupportState[] values = ModSupportState.values();
            String[] validValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                validValues[i] = values[i].name().toLowerCase();
            }
            return validValues;
        }
    }
}

