/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.command;

import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsLogs;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ShopReportExecutor
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional user = args.getOne("player");
        UUID target = null;
        if (user.isPresent()) {
            if (!src.hasPermission("carrotshop.report.other")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.REPORT_ERROR_OPERM}));
                return CommandResult.success();
            }
            target = ((User)user.get()).getUniqueId();
        } else {
            if (!src.hasPermission("carrotshop.report.self")) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.REPORT_ERROR_PERM}));
                return CommandResult.success();
            }
            if (src instanceof Player) {
                target = ((Player)src).getUniqueId();
            }
        }
        ShopsLogs.generateReport(src, target);
        return CommandResult.success();
    }
}

