/*
 * Decompiled with CFR 0.152.
 */
package com.itwookie.utils;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Expiring<T> {
    T value;
    long expirationDate;

    private Expiring() {
        this.value = null;
        this.expirationDate = 0L;
    }

    private Expiring(T object, long lifespan) {
        this.value = object;
        this.expirationDate = System.currentTimeMillis() + lifespan;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationDate;
    }

    public boolean isAlive() {
        return System.currentTimeMillis() <= this.expirationDate;
    }

    public T get() {
        if (this.isExpired()) {
            throw new IllegalStateException("This object expired");
        }
        return this.value;
    }

    public T orElse(T other) {
        return this.isExpired() ? other : this.value;
    }

    public T orElseGet(Supplier<T> other) {
        return this.isExpired() ? other.get() : this.value;
    }

    public void ifAlive(Consumer<T> consumer) {
        if (this.isAlive()) {
            consumer.accept(this.value);
        }
    }

    public Optional<T> poll() {
        return this.isExpired() ? Optional.empty() : Optional.of(this.value);
    }

    public T getAnyways() {
        return this.value;
    }

    public static <Y> Expiring<Y> expireAt(Y object, long timeAt) {
        return new Expiring<Y>(object, timeAt - System.currentTimeMillis());
    }

    public static <Y> Expiring<Y> expireIn(Y object, long lifespan) {
        return new Expiring<Y>(object, lifespan);
    }

    public static <Y> Expiring<Y> expired() {
        return new Expiring();
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public long getRemainingLifespan() {
        return Math.min(0L, this.expirationDate - System.currentTimeMillis());
    }

    public String toString() {
        return "Expiring<" + String.valueOf(this.value) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expiring expiring = (Expiring)o;
        return this.expirationDate == expiring.expirationDate && Objects.equals(this.value, expiring.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.expirationDate);
    }
}

