/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds;

import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.sounds.EventSoundRegistry;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.ResourcePackStatusEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;

public class EventListeners {
    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event) {
        if (EventSounds.doForceDownload()) {
            Sponge.getServer().getDefaultResourcePack().ifPresent(pack -> event.getTargetEntity().sendResourcePack(pack));
        }
        EventSoundRegistry.triggerJoin(event.getTargetEntity());
    }

    @Listener
    public void onResourcePackLoaded(ResourcePackStatusEvent event) {
        if (event.getStatus().equals((Object)ResourcePackStatusEvent.ResourcePackStatus.FAILED)) {
            event.getPlayer().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Oops", TextColors.WHITE, ", looks like downloading the resource-pack failed. You can ", Text.builder((String)"try again").onClick((ClickAction)TextActions.runCommand((String)"/eventsounds")).style(new TextStyle[]{TextStyles.UNDERLINE}).color(TextColors.BLUE).build()}));
        }
    }

    @Listener
    public void onChat(MessageChannelEvent.Chat event) {
        Player from = event.getCause().first(Player.class).orElse(null);
        if (from == null) {
            return;
        }
        String message = event.getRawMessage().toPlain();
        EventSounds.l("Chat: %s %s", from.getName(), message);
        EventSoundRegistry.triggerChat(from, message);
    }

    @Listener
    public void onDamageEntity(DamageEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getTargetEntity() instanceof Living)) {
            return;
        }
        Living target = (Living)event.getTargetEntity();
        Optional source = event.getCause().first(EntityDamageSource.class);
        Entity attacker = null;
        if (source.isPresent()) {
            Optional perhaps;
            Entity test = ((EntityDamageSource)source.get()).getSource();
            if (test instanceof Living) {
                attacker = test;
            } else if (test.getCreator().isPresent() && (perhaps = target.getWorld().getEntity((UUID)test.getCreator().get())).isPresent() && perhaps.get() instanceof Living) {
                attacker = (Entity)perhaps.get();
            }
        }
        if (!(target instanceof Player) || !event.willCauseDeath()) {
            return;
        }
        if (attacker instanceof Player) {
            EventSoundRegistry.triggerQuake((Player)attacker, (Player)target);
        } else if (attacker instanceof Living) {
            EventSoundRegistry.triggerDeath((Player)target, attacker);
        } else if (source.isPresent()) {
            EventSoundRegistry.triggerDeath((Player)target, ((EntityDamageSource)source.get()).getType());
        }
    }

    @Listener
    public void onPlayerDeath(RespawnPlayerEvent event) {
        EventSoundRegistry.resetPlayer(event.getOriginalPlayer());
    }

    @Listener
    public void onPlayerPart(ClientConnectionEvent.Disconnect event) {
        EventSoundRegistry.resetPlayer(event.getTargetEntity());
    }
}

