/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds;

import com.google.inject.Inject;
import de.dosmike.sponge.EventSounds.CommandRegistra;
import de.dosmike.sponge.EventSounds.EventListeners;
import de.dosmike.sponge.EventSounds.config.ConfigLoader;
import de.dosmike.sponge.EventSounds.config.ResourcePacker;
import de.dosmike.sponge.EventSounds.config.SoundCollector;
import java.util.Optional;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import shadow.dosmike.versionchecker.eventsounds.VersionChecker;

@Plugin(id="eventsounds", name="Event Sounds", version="0.3.3", authors={"DosMike"})
public class EventSounds {
    private SpongeExecutorService executor;
    private static boolean forceDownload = true;
    private static EventSounds instance;
    private static ResourcePacker packer;
    public boolean verbose = true;
    @Inject
    private Logger logger;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private ConfigurationLoader<CommentedConfigurationNode> config;

    public static SpongeExecutorService getExecutor() {
        return EventSounds.instance.executor;
    }

    public static void setForceDownload(boolean forceDownload) {
        EventSounds.forceDownload = forceDownload;
    }

    public static boolean doForceDownload() {
        return forceDownload;
    }

    public static EventSounds getInstance() {
        return instance;
    }

    static Optional<ResourcePacker> getResourcePacker() {
        return Optional.ofNullable(packer);
    }

    public static boolean logVerbose() {
        return EventSounds.getInstance().verbose;
    }

    public static void l(String format, Object ... args) {
        EventSounds.instance.logger.info(String.format(format, args));
    }

    public static void w(String format, Object ... args) {
        EventSounds.instance.logger.warn(String.format(format, args));
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        instance = this;
        SoundCollector.collect();
        try {
            this.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VersionChecker.checkVersion(this);
        CommandRegistra.RegisterCommands();
        this.executor = Sponge.getScheduler().createAsyncExecutor((Object)this);
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EventListeners());
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.loadConfig();
    }

    private void loadConfig() {
        try {
            packer = ConfigLoader.load(this.config);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                EventSounds.w(e.getMessage(), new Object[0]);
            } else {
                EventSounds.w(e.getClass().getSimpleName(), new Object[0]);
            }
            throw new RuntimeException("Failed to load config", e);
        }
    }

    static {
        packer = null;
    }
}

