/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds;

import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.config.ResourcePacker;
import de.dosmike.sponge.EventSounds.config.SoundCollector;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.effect.sound.SoundCategories;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class cmdEventSounds {
    public static AtomicBoolean rebuilding = new AtomicBoolean(false);

    private static Text getQuadStateText(String text, int state) {
        if (state < -1) {
            return Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "\u2718 ", text});
        }
        if (state == -1) {
            return Text.of((Object[])new Object[]{TextColors.WHITE, "\u2751 ", text});
        }
        if (state == 0) {
            return Text.of((Object[])new Object[]{TextColors.YELLOW, "\u25ba ", text, "..."});
        }
        return Text.of((Object[])new Object[]{TextColors.GREEN, "\u2714 ", text});
    }

    private static void printUpdate(CommandSource viewer, int stage, int maxStage, @Nullable Text lastLine) {
        String[] stages = new String[]{"Searching for other Plugins", "Reloading configuration", "Rebuilding Resource-Pack", "Uploading Pack to Server", "Validating Pack"};
        PaginationList.Builder builder = PaginationList.builder().title((Text)Text.of((String)"EventSounds"));
        builder.padding((Text)Text.of((String)"="));
        LinkedList<Text> lines = new LinkedList<Text>();
        for (int i = 0; i < stages.length; ++i) {
            int state = i > maxStage ? -2 : Integer.compare(stage, i);
            lines.add(cmdEventSounds.getQuadStateText(stages[i], state));
        }
        lines.add(Text.EMPTY);
        if (stage > maxStage) {
            if (lastLine != null) {
                lines.add(lastLine);
            } else {
                lines.add(Text.of((Object[])new Object[]{TextColors.GREEN, "The reload was complete!"}));
            }
        } else {
            lines.add(Text.of((Object[])new Object[]{TextColors.GRAY, "Please wait for the task to finish"}));
        }
        builder.contents(lines);
        builder.sendTo((MessageReceiver)viewer);
    }

    public static CommandSpec getCommandSpec() {
        CommandSpec cmdReload = CommandSpec.builder().permission("es.command.reload").description((Text)Text.of((String)"Reload configuration, (-b)uild pack, (-u)pload it via ftp and verify the hash")).extendedDescription(Text.of((Object[])new Object[]{"Reload the configuration and rebuild the resource-pack", Text.NEW_LINE, "The flag -b (es.command.rebuild) will also rebuild the resource-pack", Text.NEW_LINE, "The flag -u (es.command.upload) will upload the pack via ftp if possible (implies -b)"})).arguments(GenericArguments.flags().permissionFlag("es.command.upload", new String[]{"u"}).permissionFlag("es.command.rebuild", new String[]{"b"}).buildWith(GenericArguments.none())).executor((src, args) -> {
            boolean rebuild;
            if (rebuilding.getAndSet(true)) {
                throw new CommandException((Text)Text.of((String)"The command is already running..."));
            }
            boolean upload = args.hasAny("u");
            boolean bl = rebuild = upload || args.hasAny("b");
            int maxStage = upload ? 4 : (rebuild ? 2 : 1);
            try {
                cmdEventSounds.printUpdate(src, 0, maxStage, null);
                SoundCollector.collect();
                cmdEventSounds.printUpdate(src, 1, maxStage, null);
                EventSounds.getInstance().onReload(null);
                cmdEventSounds.printUpdate(src, 2, maxStage, null);
            }
            catch (Exception e) {
                rebuilding.set(false);
                throw new CommandException((Text)Text.of((String)(e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName())));
            }
            EventSounds.getExecutor().execute(() -> {
                try {
                    ResourcePacker packer = EventSounds.getResourcePacker().orElse(null);
                    if (packer != null) {
                        if (rebuild) {
                            packer.repack();
                            cmdEventSounds.printUpdate(src, 3, maxStage, null);
                        }
                        if (upload) {
                            packer.upload();
                            cmdEventSounds.printUpdate(src, 4, maxStage, null);
                            boolean valid = packer.validateResourcePack();
                            if (valid) {
                                for (Player p : Sponge.getServer().getOnlinePlayers()) {
                                    packer.sendDefaultPackUpdated(p);
                                }
                                cmdEventSounds.printUpdate(src, 5, maxStage, Text.of((Object[])new Object[]{TextColors.GREEN, "Done! The resource-pack was successfully uploaded."}));
                            } else {
                                cmdEventSounds.printUpdate(src, 5, maxStage, Text.of((Object[])new Object[]{TextColors.RED, "There was a problem validating the resource-pack", Text.NEW_LINE, TextColors.YELLOW, "Don't panic, an old version of the pack is probably still be cached by the server"}));
                                if (src instanceof Player) {
                                    ((Player)src).playSound(SoundTypes.BLOCK_ANVIL_FALL, SoundCategories.MASTER, ((Player)src).getPosition(), 0.5, 1.0, 1.0);
                                }
                            }
                        }
                    } else {
                        src.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, "Resource Packer was not configured"}));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Failed to Repack: ", e.getMessage()}));
                }
                finally {
                    rebuilding.set(false);
                }
            });
            return CommandResult.success();
        }).build();
        return CommandSpec.builder().description((Text)Text.of((String)"Management command for EventSounds")).extendedDescription((Text)Text.of((String)"/es prompts Resource Pack install.")).arguments(GenericArguments.none()).executor((src, args) -> {
            Optional pack = Sponge.getServer().getDefaultResourcePack();
            if (src instanceof Player) {
                Player player = (Player)src;
                if (pack.isPresent()) {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Sending the Resource Pack your way..."}));
                    Task.builder().delayTicks(1L).execute(() -> {
                        ResourcePacker packer = EventSounds.getResourcePacker().orElse(null);
                        if (packer != null) {
                            packer.sendDefaultPackUpdated(player);
                        } else {
                            player.sendResourcePack((ResourcePack)pack.get());
                        }
                    }).submit((Object)EventSounds.getInstance());
                } else {
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "There is no Resource Pack available"}));
                }
            } else if (pack.isPresent()) {
                src.sendMessage((Text)Text.of((String)("Resource Pack at " + ((ResourcePack)pack.get()).getUri().toString())));
            } else {
                src.sendMessage((Text)Text.of((String)"There is no Resource Pack available"));
            }
            return CommandResult.success();
        }).child((CommandCallable)cmdReload, new String[]{"reload"}).build();
    }
}

