/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.config;

import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.config.PlaytimeManager;
import de.dosmike.sponge.EventSounds.config.ResourcePacker;
import de.dosmike.sponge.EventSounds.config.SoundCollector;
import de.dosmike.sponge.EventSounds.events.SoundsCollectedEvent;
import de.dosmike.sponge.EventSounds.sounds.EventSoundRegistry;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.ConfigurationException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.plugin.PluginContainer;
import shadow.dosmike.versionchecker.eventsounds.VersionChecker;

public class ConfigLoader {
    public static ResourcePacker load(ConfigurationLoader<CommentedConfigurationNode> config) throws IOException, ConfigurationException {
        EventSoundRegistry.resetAll();
        CommentedConfigurationNode root = (CommentedConfigurationNode)config.load(ConfigurationOptions.defaults());
        if (root.getNode(new Object[]{"plugin"}).isVirtual() && root.getNode(new Object[]{"packer"}).isVirtual()) {
            EventSounds.w("Trying to write defautls", new Object[0]);
            HoconConfigurationLoader defaultConfig = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setURL(((Asset)Sponge.getAssetManager().getAsset((Object)EventSounds.getInstance(), "default.conf").get()).getUrl())).build();
            root.mergeValuesFrom(defaultConfig.load(ConfigurationOptions.defaults()));
            config.save((ConfigurationNode)root);
        }
        EventSounds.getInstance().verbose = ConfigLoader.getOptionalBoolean((ConfigurationNode)root.getNode(new Object[]{"plugin"}), "verbose").orElse(true);
        CommentedConfigurationNode vcnode = root.getNode(new Object[]{"plugin"}).getNode(new Object[]{"VersionChecker"});
        if (vcnode.isVirtual()) {
            vcnode.setValue((Object)false);
            vcnode.setComment("It's strongly recommended to enable automatic version checking,\nThis will also inform you about changes in dependencies.\nSet this value to true to allow this Plugin to check for Updates on Ore");
            config.save((ConfigurationNode)root);
            VersionChecker.setVersionCheckingEnabled(((PluginContainer)Sponge.getPluginManager().fromInstance((Object)EventSounds.getInstance()).get()).getId(), false);
        } else {
            VersionChecker.setVersionCheckingEnabled(((PluginContainer)Sponge.getPluginManager().fromInstance((Object)EventSounds.getInstance()).get()).getId(), vcnode.getBoolean(false));
        }
        ResourcePacker packer = null;
        if (!root.getNode(new Object[]{"packer"}).isVirtual()) {
            packer = new ResourcePacker(ConfigLoader.getOptionalString((ConfigurationNode)root.getNode(new Object[]{"packer"}), "template").orElse(null), ConfigLoader.getOptionalString((ConfigurationNode)root.getNode(new Object[]{"packer"}), "ftpserver").orElse(null), ConfigLoader.getOptionalString((ConfigurationNode)root.getNode(new Object[]{"packer"}), "ftplogin").orElse(null), ConfigLoader.getOptionalString((ConfigurationNode)root.getNode(new Object[]{"packer"}), "ftppasswd").orElse(null));
            EventSounds.setForceDownload(ConfigLoader.getOptionalBoolean((ConfigurationNode)root.getNode(new Object[]{"packer"}), "forceDownload").orElse(true));
        }
        Set allKeys = root.getChildrenMap().keySet().stream().map(Object::toString).collect(Collectors.toSet());
        allKeys.remove("packer");
        allKeys.remove("plugin");
        for (String event : allKeys) {
            CommentedConfigurationNode cfgEvent = root.getNode(new Object[]{event});
            if (cfgEvent.isVirtual()) continue;
            EventSoundRegistry.parseConfigurationNode(event, (ConfigurationNode)cfgEvent);
        }
        SoundCollector.registerSound();
        try (CauseStackManager.StackFrame ignored = Sponge.getCauseStackManager().pushCauseFrame();){
            Sponge.getEventManager().post((Event)new SoundsCollectedEvent());
        }
        PlaytimeManager.readFileLengths();
        return packer;
    }

    private static Optional<String> getOptionalString(ConfigurationNode node, String key) {
        if (node.getNode(new Object[]{key}).isVirtual()) {
            return Optional.empty();
        }
        return Optional.ofNullable(node.getNode(new Object[]{key}).getString());
    }

    private static Optional<Boolean> getOptionalBoolean(ConfigurationNode node, String key) {
        if (node.getNode(new Object[]{key}).isVirtual()) {
            return Optional.empty();
        }
        return Optional.of(node.getNode(new Object[]{key}).getBoolean());
    }
}

