/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.itwookie.utils.Expiring;
import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.sounds.EventSoundRegistry;
import de.dosmike.sponge.EventSounds.sounds.SoundDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;

public class PlaytimeManager {
    private static Map<String, Long> soundLengths = new HashMap<String, Long>();
    private static Map<UUID, Set<Expiring<SoundDefinition>>> currentlyPlaying = new HashMap<UUID, Set<Expiring<SoundDefinition>>>();
    private static final int playbackRate = 48;

    public static void readFileLengths() {
        JsonObject fileMapJson;
        JsonObject soundJson;
        soundLengths.clear();
        currentlyPlaying.clear();
        try {
            JsonParser parser = new JsonParser();
            soundJson = parser.parse(((Asset)Sponge.getAssetManager().getAsset((Object)EventSounds.getInstance(), "soundindex_1-12.json").get()).readString()).getAsJsonObject();
            fileMapJson = parser.parse(((Asset)Sponge.getAssetManager().getAsset((Object)EventSounds.getInstance(), "filemapping_1-12.json").get()).readString()).getAsJsonObject().getAsJsonObject("objects");
        }
        catch (IOException e) {
            return;
        }
        for (Map.Entry entry : soundJson.entrySet()) {
            String id = (String)entry.getKey();
            JsonObject definition = ((JsonElement)entry.getValue()).getAsJsonObject();
            HashSet<String> soundFiles = new HashSet<String>();
            for (JsonElement element : definition.getAsJsonArray("sounds")) {
                if (element.isJsonObject()) {
                    if (element.getAsJsonObject().has("type") && element.getAsJsonObject().get("type").getAsString().matches("event")) continue;
                    soundFiles.add(element.getAsJsonObject().get("name").getAsString());
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    soundFiles.add(element.getAsString());
                    continue;
                }
                throw new RuntimeException("cached sounds.json seems to be corrupted!");
            }
            long length = 0L;
            for (String file : soundFiles) {
                try {
                    length = Math.max(length, fileMapJson.getAsJsonObject(String.format("minecraft/sounds/%s.ogg", file)).get("size").getAsLong());
                }
                catch (NullPointerException e) {
                    EventSounds.w("NullPointerException at %s", file);
                }
            }
            long timeMs = length / 48L;
            if (timeMs > 0L) {
                soundLengths.put(id, timeMs);
                continue;
            }
            if (!EventSounds.logVerbose()) continue;
            EventSounds.w("Could not read length for sound %s", id);
        }
        EventSoundRegistry.getSoundDefinitions().forEach(def -> {
            if (EventSounds.logVerbose()) {
                EventSounds.l("File: %s %s", def.isExternal() ? "Plugin" : "Config", String.join((CharSequence)", ", def.getFiles()));
            }
            long timeMs = -1L;
            if (!def.isExternal()) {
                for (String file : def.getFiles()) {
                    try {
                        File f = new File(".", "assets/eventsounds/" + file);
                        int bytelength = (int)f.length();
                        byte[] filebytes = new byte[bytelength];
                        new FileInputStream(f).read(filebytes);
                        timeMs = Math.max(timeMs, PlaytimeManager.getOggLength(filebytes));
                    }
                    catch (IOException e) {
                        EventSounds.w("Could not read %s", file);
                    }
                }
            } else {
                String[] p = def.getRegistryName().split("\\.");
                String id = p[p.length - 2];
                for (String file : def.getFiles()) {
                    try {
                        byte[] filebytes = ((Asset)((PluginContainer)Sponge.getPluginManager().getPlugin(id).get()).getAsset(file).get()).readBytes();
                        timeMs = Math.max(timeMs, PlaytimeManager.getOggLength(filebytes));
                    }
                    catch (IOException e) {
                        EventSounds.w("Could not read %s:%s", id, file);
                    }
                }
            }
            if (timeMs > 0L) {
                soundLengths.put(def.getRegistryName(), timeMs);
            } else if (EventSounds.logVerbose()) {
                EventSounds.w("Could not read length for sound %s", def.getRegistryName());
            }
        });
    }

    private static long getOggLength(byte[] file) {
        ByteBuffer buffer;
        int i;
        int rate = -1;
        long length = -1L;
        for (i = 0; i < file.length - 15; ++i) {
            if (file[i] != 118 || !new String(file, i, 6, StandardCharsets.US_ASCII).equals("vorbis")) continue;
            buffer = ByteBuffer.wrap(file, i + 11, 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            rate = buffer.getInt();
            break;
        }
        for (i = file.length - 1 - 8 - 2 - 4; i >= 0; --i) {
            if (file[i] != 79 || !new String(file, i, 4, StandardCharsets.US_ASCII).equals("OggS")) continue;
            buffer = ByteBuffer.wrap(file, i + 6, 8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            length = buffer.getLong();
            break;
        }
        if (rate <= 0 || length <= 0L) {
            return 0L;
        }
        return length * 1000L / (long)rate;
    }

    public static long getSoundLength(SoundType sound) {
        String id = sound.getId();
        if (id.contains(":")) {
            id = id.substring(id.indexOf(":") + 1);
        }
        return soundLengths.getOrDefault(id, 0L);
    }

    public static void stopAndPlay(SoundDefinition sound, Player player) {
        PlaytimeManager.cleanRegistry();
        Set playing = currentlyPlaying.getOrDefault(player.getUniqueId(), new HashSet());
        playing.removeIf(s -> {
            String event2;
            String event1 = ((SoundDefinition)s.getAnyways()).getRegistryName().split("\\.")[1];
            boolean res = event1.equals(event2 = sound.getRegistryName().split("\\.")[1]);
            if (res) {
                player.stopSounds(sound.getSound());
            }
            return res;
        });
        playing.add(Expiring.expireIn(sound, PlaytimeManager.getSoundLength(sound.getSound())));
        currentlyPlaying.put(player.getUniqueId(), playing);
    }

    public static void cleanRegistry() {
        HashSet<UUID> staleKeys = new HashSet<UUID>();
        for (Map.Entry<UUID, Set<Expiring<SoundDefinition>>> entry : currentlyPlaying.entrySet()) {
            Set<Expiring<SoundDefinition>> sounds = entry.getValue();
            sounds.removeIf(Expiring::isExpired);
            if (!sounds.isEmpty()) continue;
            staleKeys.add(entry.getKey());
        }
        for (UUID stale : staleKeys) {
            currentlyPlaying.remove(stale);
        }
    }
}

