/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.config.SoundCollector;
import de.dosmike.sponge.EventSounds.sounds.EventSoundRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.resourcepack.ResourcePacks;
import org.spongepowered.api.text.Text;
import shadow.dosmike.ftp.vshop.it.sauronsoftware.ftp4j.FTPAbortedException;
import shadow.dosmike.ftp.vshop.it.sauronsoftware.ftp4j.FTPClient;
import shadow.dosmike.ftp.vshop.it.sauronsoftware.ftp4j.FTPDataTransferException;
import shadow.dosmike.ftp.vshop.it.sauronsoftware.ftp4j.FTPException;
import shadow.dosmike.ftp.vshop.it.sauronsoftware.ftp4j.FTPIllegalReplyException;

public class ResourcePacker {
    private static final Path soundsJson = Paths.get("assets/minecraft/sounds.json", new String[0]);
    private static final Path soundsDir = Paths.get("assets/minecraft/sounds", new String[0]);
    private static final Path soundsCustom = soundsDir.resolve("custom/es/server");
    private String ftpU;
    private String ftpP;
    private String sha1 = null;
    private File zipSrc;
    private File zipDst = new File(".", "eventsounds_pack.zip");
    private URL ftpTarget;
    private JsonObject jsonSounds;

    public static Path getPackDir() {
        return soundsCustom;
    }

    public ResourcePacker(String templateArchive, String ftpUploadTarget, String ftpUser, String ftpPass) throws MalformedURLException {
        this.zipSrc = templateArchive != null ? new File(".", templateArchive) : null;
        if (ftpUploadTarget == null || ftpUploadTarget.isEmpty()) {
            this.ftpTarget = null;
        } else {
            this.ftpTarget = new URL(ftpUploadTarget);
            if ((ftpPass == null || ftpPass.isEmpty()) && ftpUser != null && !ftpUser.isEmpty()) {
                throw new RuntimeException("A ftp password is required if a ftp user was set");
            }
            if (ftpUser != null && !ftpUser.isEmpty()) {
                this.ftpU = ftpUser;
                this.ftpP = ftpPass;
            }
        }
        this.jsonSounds = new JsonObject();
    }

    public void repack() throws IOException {
        HashSet zipped = new HashSet();
        EventSounds.l("Generating %s...", this.zipDst.getName());
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(this.zipDst));
        zout.setMethod(8);
        zout.setLevel(9);
        if (this.zipSrc != null && this.zipSrc.exists()) {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(this.zipSrc));
            while ((entry = zin.getNextEntry()) != null) {
                int r;
                Path path = Paths.get(entry.getName(), new String[0]);
                if (path.startsWith(soundsDir) || path.equals(soundsJson)) continue;
                EventSounds.l("Repacking %s", entry.getName());
                zout.putNextEntry(new ZipEntry(entry.getName()));
                byte[] buffer = new byte[512];
                while ((r = zin.read(buffer, 0, buffer.length)) >= 0) {
                    zout.write(buffer, 0, r);
                }
                zin.closeEntry();
                zout.closeEntry();
            }
        } else {
            JsonObject packmcmeta = new JsonObject();
            JsonObject jpack = new JsonObject();
            jpack.addProperty("description", "Automatically generated Resource-Pack\nBy: EventSounds Sponge-Plugin");
            jpack.addProperty("pack_format", (Number)3);
            packmcmeta.add("pack", (JsonElement)jpack);
            ZipEntry entry = new ZipEntry("pack.mcmeta");
            zout.putNextEntry(entry);
            EventSoundRegistry.getSoundDefinitions().forEach(def -> this.jsonSounds.add(def.getRegistryName(), (JsonElement)def.toJson()));
            StringWriter sw = new StringWriter(512);
            JsonWriter writer = new JsonWriter((Writer)sw);
            Gson g = new Gson();
            g.toJson((JsonElement)this.jsonSounds, writer);
            zout.write(sw.toString().getBytes());
            zout.closeEntry();
        }
        ZipEntry entry = new ZipEntry(soundsJson.toString().replace('\\', '/'));
        zout.putNextEntry(entry);
        EventSoundRegistry.getSoundDefinitions().forEach(def -> this.jsonSounds.add(def.getRegistryName(), (JsonElement)def.toJson()));
        StringWriter sw = new StringWriter(512);
        JsonWriter writer = new JsonWriter((Writer)sw);
        Gson g = new Gson();
        g.toJson((JsonElement)this.jsonSounds, writer);
        zout.write(sw.toString().getBytes());
        zout.closeEntry();
        EventSoundRegistry.getSoundDefinitions().forEach(def -> {
            if (!def.isExternal()) {
                for (String file : def.getFiles()) {
                    if (zipped.contains(file)) continue;
                    zipped.add(file);
                    File toZip = new File("./assets/eventsounds/", file);
                    String zipPath = soundsCustom.resolve(file).toString().replace('\\', '/');
                    EventSounds.l("Zipping %s to %s", toZip.getAbsolutePath(), zipPath);
                    ZipEntry e = new ZipEntry(zipPath);
                    FileInputStream fin = null;
                    try {
                        int r;
                        fin = new FileInputStream(toZip);
                        zout.putNextEntry(e);
                        byte[] buffer = new byte[1024];
                        while ((r = ((InputStream)fin).read(buffer, 0, buffer.length)) >= 0) {
                            zout.write(buffer, 0, r);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    finally {
                        try {
                            ((InputStream)fin).close();
                        }
                        catch (IOException iOException) {}
                        try {
                            zout.closeEntry();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        SoundCollector.copyToResourcePack(zout);
        zout.finish();
        zout.flush();
        zout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload() throws IOException, NoSuchAlgorithmException, URISyntaxException {
        int r;
        if (!"ftp".equalsIgnoreCase(this.ftpTarget.getProtocol())) {
            throw new IOException("Protocol not supported: " + this.ftpTarget.getProtocol());
        }
        byte[] buffer = new byte[512];
        this.sha1 = null;
        FileInputStream fis = new FileInputStream(this.zipDst);
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        while ((r = fis.read(buffer)) >= 0) {
            digest.update(buffer, 0, r);
        }
        fis.close();
        byte[] hash = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02X", b));
        }
        this.sha1 = sb.toString();
        EventSounds.l("Patching server.properties value resource-pack-sha1 to %s", this.sha1);
        File propertiesFile = new File("server.properties");
        StringBuilder props = new StringBuilder();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(propertiesFile)));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("resource-pack-sha1=")) {
                    props.append("resource-pack-sha1=" + this.sha1);
                } else {
                    props.append(line);
                }
                props.append('\n');
            }
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (Exception error) {}
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(propertiesFile)));
            bw.write(props.toString());
            bw.flush();
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception error) {}
        }
        EventSounds.l("Establishing FTP connection", new Object[0]);
        FTPClient client = new FTPClient();
        FileInputStream zipIn = null;
        try {
            Path path;
            zipIn = new FileInputStream(this.zipDst);
            int port = this.ftpTarget.getPort();
            if (port < 0) {
                client.connect(this.ftpTarget.getHost());
            } else {
                client.connect(this.ftpTarget.getHost(), port);
            }
            if (this.ftpU != null) {
                try {
                    client.login(this.ftpU, this.ftpP);
                    client.setAutoNoopTimeout(15000L);
                }
                catch (FTPException | FTPIllegalReplyException exception) {
                    throw new RuntimeException("Login failed");
                }
            }
            if ((path = Paths.get(this.ftpTarget.getPath(), new String[0])).getFileName() == null || !path.getFileName().toString().toLowerCase().endsWith(".zip")) {
                throw new IOException("Please append a zip path to the ftp url");
            }
            EventSounds.l("Remote file: %s", path.toString());
            for (int i = 0; i < path.getNameCount() - 1; ++i) {
                String elem = path.getName(i).toString();
                this.forceEnterDirectory(client, elem);
            }
            String name = path.getName(path.getNameCount() - 1).toString();
            Object[] files = client.listNames();
            if (files == null) {
                throw new IOException("Directory could not be read");
            }
            if (ArrayUtils.contains((Object[])files, (Object)name)) {
                EventSounds.l("FTP> rm %s", name);
                try {
                    client.deleteFile(name);
                }
                catch (Exception e) {
                    throw new IOException("Could not delete old resource-pack");
                }
            }
            EventSounds.l("FTP> put %s", name);
            client.setType(2);
            try {
                client.upload(name, zipIn, 0L, 0L, null);
            }
            catch (FTPAbortedException | FTPDataTransferException e) {
                throw new RuntimeException("Upload failed or was aborted");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("FTP connection Failed", e);
        }
        finally {
            try {
                client.disconnect(true);
            }
            catch (Exception exception) {}
            try {
                ((InputStream)zipIn).close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean validateResourcePack() {
        if (this.sha1 == null) {
            return false;
        }
        try {
            ResourcePack pack = Sponge.getServer().getDefaultResourcePack().orElse(null);
            if (pack == null) {
                return false;
            }
            pack = ResourcePacks.fromUri((URI)pack.getUri());
            EventSounds.l("Hash A/B: \n%s\n%s", pack.getHash().orElse("NULL"), this.sha1);
            return this.sha1.equalsIgnoreCase(pack.getHash().orElse(null));
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private void forceEnterDirectory(FTPClient client, String directory) throws FTPException, FTPIllegalReplyException, IOException {
        try {
            EventSounds.l("FTP> cd %s", directory);
            client.changeDirectory(directory);
        }
        catch (FTPException e) {
            EventSounds.l("FTP> mkdir %s", directory);
            client.createDirectory(directory);
            EventSounds.l("FTP> cd %s", directory);
            client.changeDirectory(directory);
        }
    }

    public void sendDefaultPackUpdated(Player player) {
        ResourcePack pack = Sponge.getServer().getDefaultResourcePack().orElse(null);
        if (pack == null) {
            player.sendMessage((Text)Text.of((String)"Resource pack download was not defined in server.properties"));
            return;
        }
        ResourcePack newPack = ResourcePacks.fromUriUnchecked((URI)pack.getUri());
        player.sendResourcePack(newPack);
    }
}

