/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.sounds.EventSoundRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.plugin.PluginContainer;

public class SoundCollector {
    private static Gson gson = new Gson();
    static Map<String, Set<String>> pluginSounds = new HashMap<String, Set<String>>();
    static Map<String, Set<String>> externalFiles = new HashMap<String, Set<String>>();

    static Map<String, Set<String>> readIndex(PluginContainer plugin) {
        HashMap<String, Set<String>> entries = new HashMap<String, Set<String>>();
        if (plugin.getInstance().isPresent()) {
            Optional asset = plugin.getAsset("eventsounds.json");
            if (asset.isPresent()) {
                try {
                    entries.putAll((Map)gson.fromJson(((Asset)asset.get()).readString(), new TypeToken<Map<String, Set<String>>>(){}.getType()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (entries.size() > 0) {
                EventSounds.l("Found %d sounds for %s", entries.size(), plugin.getName());
            }
        }
        return entries;
    }

    public static void collect() {
        externalFiles.clear();
        pluginSounds.clear();
        HashMap<String, Map> sounds = new HashMap<String, Map>();
        Sponge.getPluginManager().getPlugins().forEach(p -> sounds.put(p.getId(), SoundCollector.readIndex(p)));
        sounds.forEach((id, entries) -> {
            HashSet soundNamesForPlugin = new HashSet();
            entries.forEach((n, files) -> {
                HashSet found = new HashSet();
                for (String f : files) {
                    ((PluginContainer)Sponge.getPluginManager().getPlugin(id).get()).getAsset(f).ifPresent(a -> found.add(f));
                }
                String squish = String.format("%s.%s", id, n);
                if (found.size() != files.size()) {
                    HashSet tmp = new HashSet(files);
                    tmp.removeAll(found);
                    EventSounds.w("Missing sounds for %s: %s", id, String.join((CharSequence)", ", tmp));
                } else {
                    externalFiles.put(squish, found);
                    soundNamesForPlugin.add(squish);
                }
            });
            if (!soundNamesForPlugin.isEmpty()) {
                pluginSounds.put((String)id, soundNamesForPlugin);
            }
        });
    }

    public static Map<String, SoundType> getForPlugin(PluginContainer plugin) {
        HashMap<String, SoundType> map = new HashMap<String, SoundType>();
        ((Set)pluginSounds.getOrDefault(plugin.getId(), new HashSet())).stream().map(s -> {
            int i = s.lastIndexOf(46);
            return new String[]{s.substring(i + 1), "es.plugin." + s};
        }).forEach(s -> map.put(s[0], SoundType.of((String)s[1])));
        return map;
    }

    public static void registerSound() {
        externalFiles.forEach((name, files) -> {
            String[] f = files.toArray(new String[0]);
            EventSoundRegistry.registerSound("plugin", name, "master", f);
        });
    }

    static void copyToResourcePack(ZipOutputStream zos) {
        pluginSounds.forEach((id, names) -> {
            HashSet assets = new HashSet();
            for (String name : names) {
                assets.addAll(externalFiles.getOrDefault(name, new HashSet()));
            }
            for (String name : assets) {
                ((PluginContainer)Sponge.getPluginManager().getPlugin(id).get()).getAsset(name).ifPresent(a -> {
                    try {
                        String path = "assets/minecraft/sounds/custom/es/plugin/" + id + "/" + name.replace('\\', '/').toLowerCase();
                        EventSounds.l("Zipping %s:%s to %s", id, name, path);
                        ZipEntry outEntry = new ZipEntry(path);
                        zos.putNextEntry(outEntry);
                        zos.write(a.readBytes());
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }
}

