/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.sounds;

import com.google.common.collect.ImmutableSet;
import com.itwookie.utils.Expiring;
import de.dosmike.sponge.EventSounds.EventSounds;
import de.dosmike.sponge.EventSounds.config.SoundCollector;
import de.dosmike.sponge.EventSounds.events.PlaySoundEvent;
import de.dosmike.sponge.EventSounds.sounds.BiFitness;
import de.dosmike.sponge.EventSounds.sounds.NamedCounters;
import de.dosmike.sponge.EventSounds.sounds.Playable;
import de.dosmike.sponge.EventSounds.sounds.Refrigerator;
import de.dosmike.sponge.EventSounds.sounds.SoundDefinition;
import de.dosmike.sponge.EventSounds.sounds.SoundOptions;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.entity.damage.DamageType;

public class EventSoundRegistry {
    public static final String EVENT_JOIN = "join";
    public static final String EVENT_CHAT = "chat";
    public static final String EVENT_KILLSTREAK = "killstreak";
    public static final String EVENT_MULTIKILL = "multikill";
    public static final String EVENT_COMBOBREAKER = "combobreaker";
    public static final String EVENT_DEATH = "death";
    public static final String EVENT_PLUGIN = "plugin";
    private static final Set<String> Events = new ImmutableSet.Builder().add((Object)"join").add((Object)"chat").add((Object)"killstreak").add((Object)"multikill").add((Object)"combobreaker").add((Object)"death").build();
    private static Map<String, SoundOptions> event_options = new HashMap<String, SoundOptions>();
    private static Map<String, Map<BiFitness<Integer, Player, Object>, Playable>> event_sounds = new HashMap<String, Map<BiFitness<Integer, Player, Object>, Playable>>();
    private static Map<String, Refrigerator> event_cooldowns = new HashMap<String, Refrigerator>();
    private static NamedCounters<UUID> quake_killstreaks = new NamedCounters();
    private static Map<UUID, Expiring<Integer>> quake_multikills = new HashMap<UUID, Expiring<Integer>>();
    private static Set<String> saySoundTriggers = new TreeSet(Comparator.naturalOrder());
    private static Set<SoundDefinition> sounds = new HashSet<SoundDefinition>();

    public static Collection<String> getStandardEvents() {
        return Events;
    }

    public static Collection<String> getAllEvents() {
        return new HashSet<String>(event_sounds.keySet());
    }

    private static int getMultiKillCount(UUID userid) {
        int timeout = (int)(event_options.get(EVENT_MULTIKILL).getCooldownClient() * 1000.0);
        int multi = 1;
        Expiring<Integer> count = quake_multikills.get(userid);
        if (count != null && count.isAlive()) {
            multi = count.get() + 1;
        }
        quake_multikills.put(userid, Expiring.expireIn(multi, timeout));
        return multi;
    }

    public static Collection<String> listSaySounds() {
        return saySoundTriggers;
    }

    public static void triggerJoin(Player player) {
        SoundOptions options = event_options.get(EVENT_JOIN);
        Map<BiFitness<Integer, Player, Object>, Playable> sounds = event_sounds.get(EVENT_JOIN);
        Refrigerator fridge = event_cooldowns.get(EVENT_JOIN);
        if (!fridge.test(player)) {
            return;
        }
        Optional<Playable> sound = sounds.entrySet().stream().map(e -> Entry.of(e.getValue(), ((BiFitness)e.getKey()).test(player, null))).filter(e -> (Integer)e.getValue() >= 0).max((o1, o2) -> {
            int testCompare = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (testCompare == 0) {
                return Integer.compare(((Playable)o1.getKey()).getPriority(), ((Playable)o2.getKey()).getPriority());
            }
            return testCompare;
        }).map(Entry::getKey);
        if (!sound.isPresent()) {
            return;
        }
        PlaySoundEvent event = new PlaySoundEvent(player, null, sound.get());
        try (CauseStackManager.StackFrame ignore = Sponge.getCauseStackManager().pushCauseFrame();){
            if (Sponge.getEventManager().post((Event)event)) {
                return;
            }
        }
        EventSounds.l("Delay: %d", options.getDelayMs());
        if (options.getDelayMs() > 0) {
            EventSounds.getExecutor().schedule(() -> {
                EventSounds.l("Play %s to %s", ((Playable)sound.get()).getSound().getRegistryName(), player.getName());
                ((Playable)sound.get()).play(player, null);
            }, (long)options.getDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            sound.get().play(player, null);
        }
        fridge.put(player);
    }

    public static void triggerChat(Player player, String message) {
        SoundOptions options = event_options.get(EVENT_CHAT);
        Map<BiFitness<Integer, Player, Object>, Playable> sounds = event_sounds.get(EVENT_CHAT);
        Refrigerator fridge = event_cooldowns.get(EVENT_CHAT);
        if (!fridge.test(player)) {
            return;
        }
        Optional<Playable> sound = sounds.entrySet().stream().map(e -> Entry.of(e.getValue(), ((BiFitness)e.getKey()).test(player, message))).filter(e -> (Integer)e.getValue() >= 0).max((o1, o2) -> {
            int testCompare = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (testCompare == 0) {
                return Integer.compare(((Playable)o1.getKey()).getPriority(), ((Playable)o2.getKey()).getPriority());
            }
            return testCompare;
        }).map(Entry::getKey);
        if (!sound.isPresent()) {
            return;
        }
        PlaySoundEvent event = new PlaySoundEvent(player, null, sound.get());
        try (CauseStackManager.StackFrame ignore = Sponge.getCauseStackManager().pushCauseFrame();){
            if (Sponge.getEventManager().post((Event)event)) {
                return;
            }
        }
        if (options.getDelayMs() > 0) {
            EventSounds.getExecutor().schedule(() -> ((Playable)sound.get()).play(player, null), (long)options.getDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            sound.get().play(player, null);
        }
        fridge.put(player);
    }

    public static void triggerQuake(Player player, Player victim) {
        Optional<Playable> sound;
        int multi;
        Optional<Playable> sound2;
        Playable target = null;
        SoundOptions targetOptions = null;
        HashSet<Refrigerator> relatedCooldowns = new HashSet<Refrigerator>();
        int victimKills = quake_killstreaks.getValue(victim.getUniqueId());
        int sourceKills = quake_killstreaks.inrement(player.getUniqueId());
        if (event_cooldowns.get(EVENT_COMBOBREAKER).test(player) && (sound2 = event_sounds.get(EVENT_COMBOBREAKER).entrySet().stream().map(e -> Entry.of(e.getValue(), ((BiFitness)e.getKey()).test(player, victimKills))).filter(e -> (Integer)e.getValue() >= 0).max((o1, o2) -> {
            int testCompare = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (testCompare == 0) {
                return Integer.compare(((Playable)o1.getKey()).getPriority(), ((Playable)o2.getKey()).getPriority());
            }
            return testCompare;
        }).map(Entry::getKey)).isPresent()) {
            target = sound2.get();
            targetOptions = event_options.get(EVENT_COMBOBREAKER);
            relatedCooldowns.add(event_cooldowns.get(EVENT_COMBOBREAKER));
        }
        if ((multi = EventSoundRegistry.getMultiKillCount(player.getUniqueId())) > 1 && (sound = event_sounds.get(EVENT_MULTIKILL).entrySet().stream().map(e -> Entry.of(e.getValue(), ((BiFitness)e.getKey()).test(player, multi))).filter(e -> (Integer)e.getValue() >= 0).max((o1, o2) -> {
            int testCompare = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (testCompare == 0) {
                return Integer.compare(((Playable)o1.getKey()).getPriority(), ((Playable)o2.getKey()).getPriority());
            }
            return testCompare;
        }).map(Entry::getKey)).isPresent() && target == null) {
            target = sound.get();
            targetOptions = event_options.get(EVENT_MULTIKILL);
        }
        if (event_cooldowns.get(EVENT_KILLSTREAK).test(player) && (sound = event_sounds.get(EVENT_KILLSTREAK).entrySet().stream().map(e -> Entry.of(e.getValue(), ((BiFitness)e.getKey()).test(player, sourceKills))).filter(e -> (Integer)e.getValue() >= 0).max((o1, o2) -> {
            int testCompare = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (testCompare == 0) {
                return Integer.compare(((Playable)o1.getKey()).getPriority(), ((Playable)o2.getKey()).getPriority());
            }
            return testCompare;
        }).map(Entry::getKey)).isPresent()) {
            if (target == null) {
                target = sound.get();
                targetOptions = event_options.get(EVENT_KILLSTREAK);
            }
            relatedCooldowns.add(event_cooldowns.get(EVENT_KILLSTREAK));
        }
        if (target != null) {
            PlaySoundEvent event = new PlaySoundEvent(player, victim, target);
            try (CauseStackManager.StackFrame ignore = Sponge.getCauseStackManager().pushCauseFrame();){
                if (Sponge.getEventManager().post((Event)event)) {
                    return;
                }
            }
            for (Refrigerator cd : relatedCooldowns) {
                cd.put(player);
            }
            Playable fsound = target;
            if (targetOptions.getDelayMs() > 0) {
                EventSounds.getExecutor().schedule(() -> fsound.play(player, victim), (long)targetOptions.getDelayMs(), TimeUnit.MILLISECONDS);
            } else {
                target.play(player, victim);
            }
        }
    }

    public static void triggerDeath(Player player, Object reason) {
        SoundOptions options = event_options.get(EVENT_DEATH);
        Map<BiFitness<Integer, Player, Object>, Playable> sounds = event_sounds.get(EVENT_JOIN);
        Refrigerator fridge = event_cooldowns.get(EVENT_JOIN);
        if (!fridge.test(player)) {
            return;
        }
        Optional<Playable> sound = sounds.entrySet().stream().map(e -> Entry.of(e.getValue(), ((BiFitness)e.getKey()).test(player, reason))).filter(e -> (Integer)e.getValue() >= 0).max((o1, o2) -> {
            int testCompare = Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
            if (testCompare == 0) {
                return Integer.compare(((Playable)o1.getKey()).getPriority(), ((Playable)o2.getKey()).getPriority());
            }
            return testCompare;
        }).map(Entry::getKey);
        if (!sound.isPresent()) {
            return;
        }
        PlaySoundEvent event = new PlaySoundEvent(player, null, sound.get());
        try (CauseStackManager.StackFrame ignore = Sponge.getCauseStackManager().pushCauseFrame();){
            if (Sponge.getEventManager().post((Event)event)) {
                return;
            }
        }
        if (options.getDelayMs() > 0) {
            EventSounds.getExecutor().schedule(() -> ((Playable)sound.get()).play(player, null), (long)options.getDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            sound.get().play(player, null);
        }
        fridge.put(player);
    }

    public static void resetPlayer(Player player) {
        quake_killstreaks.reset(player.getUniqueId());
        quake_multikills.remove(player.getUniqueId());
    }

    public static void resetAll() {
        event_options.clear();
        event_sounds.clear();
        event_cooldowns.clear();
        for (String event : Events) {
            event_options.put(event, SoundOptions.getDefault());
            event_sounds.put(event, new HashMap());
            event_cooldowns.put(event, new Refrigerator(0L, 0L));
        }
        quake_multikills.clear();
        quake_killstreaks = new NamedCounters();
        saySoundTriggers.clear();
        sounds.clear();
    }

    public static void parseConfigurationNode(String event, ConfigurationNode cfgEvent) {
        if (!event.matches("[a-z]+")) {
            throw new IllegalArgumentException("Event names have to be all lowercase letters (a-z)");
        }
        SoundOptions p_options = SoundOptions.getDefault();
        HashMap<BiFitness<Integer, Player, Object>, Playable> p_sounds = new HashMap<BiFitness<Integer, Player, Object>, Playable>();
        for (Map.Entry e : cfgEvent.getChildrenMap().entrySet()) {
            String key = (String)e.getKey();
            if ("_options".equalsIgnoreCase(key)) {
                p_options = SoundOptions.parseConfigurationNode((ConfigurationNode)e.getValue());
                continue;
            }
            if (EventSounds.logVerbose()) {
                EventSounds.l("Parsing group %s %s", event, e.getKey());
            }
            Playable p_playable = Playable.builder().fromConfigurationNode((ConfigurationNode)e.getValue()).build(event, key);
            BiFitness<Integer, Player, Object> p_predicate = EventSoundRegistry.parsePredicate(event, (ConfigurationNode)e.getValue());
            p_sounds.put(p_predicate, p_playable);
        }
        event_options.put(event, p_options);
        event_sounds.put(event, p_sounds);
        event_cooldowns.put(event, new Refrigerator((long)(p_options.getCooldownGlobal() * 1000.0), (long)(p_options.getCooldownClient() * 1000.0)));
    }

    private static BiFitness<Integer, Player, Object> parsePredicate(String event, ConfigurationNode node) {
        if (EVENT_JOIN.equalsIgnoreCase(event)) {
            String uuid = node.getNode(new Object[]{"userid"}).getString();
            String permission = node.getNode(new Object[]{"permission"}).getString();
            UUID userid = null;
            if (uuid != null) {
                try {
                    userid = UUID.fromString(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (userid != null && permission != null && !permission.isEmpty()) {
                UUID val = userid;
                return (k, v) -> k.getUniqueId().equals(val) && k.hasPermission(permission) ? 3 : -1;
            }
            if (userid != null) {
                UUID val = userid;
                return (k, v) -> k.getUniqueId().equals(val) ? 2 : -1;
            }
            if (permission != null && !permission.isEmpty()) {
                return (k, v) -> k.hasPermission(permission) ? 1 : -1;
            }
            return (k, v) -> 0;
        }
        if (EVENT_CHAT.equalsIgnoreCase(event)) {
            String[] text = (String[])node.getNode(new Object[]{"text"}).getChildrenList().stream().map(ConfigurationNode::getString).filter(s -> !s.contains(" ")).toArray(String[]::new);
            String uuid = node.getNode(new Object[]{"userid"}).getString();
            String permission = node.getNode(new Object[]{"permission"}).getString();
            if (text == null || text.length == 0) {
                return (k, v) -> -1;
            }
            for (String word : text) {
                saySoundTriggers.add(word);
            }
            UUID userid = null;
            if (uuid != null) {
                try {
                    userid = UUID.fromString(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (userid != null && permission != null && !permission.isEmpty()) {
                UUID val = userid;
                return (k, v) -> EventSoundRegistry.containsString(text, v) && k.getUniqueId().equals(val) && k.hasPermission(permission) ? 3 : -1;
            }
            if (userid != null) {
                UUID val = userid;
                return (k, v) -> EventSoundRegistry.containsString(text, v) && k.getUniqueId().equals(val) ? 2 : -1;
            }
            if (permission != null && !permission.isEmpty()) {
                return (k, v) -> EventSoundRegistry.containsString(text, v) && k.hasPermission(permission) ? 1 : -1;
            }
            return (k, v) -> EventSoundRegistry.containsString(text, v) ? 0 : -1;
        }
        if (EVENT_KILLSTREAK.equalsIgnoreCase(event) || EVENT_MULTIKILL.equalsIgnoreCase(event) || EVENT_COMBOBREAKER.equalsIgnoreCase(event)) {
            Integer kills = node.getNode(new Object[]{"kills"}).getInt();
            String uuid = node.getNode(new Object[]{"userid"}).getString();
            String permission = node.getNode(new Object[]{"permission"}).getString();
            if (kills < 0) {
                return (k, v) -> -1;
            }
            UUID userid = null;
            if (uuid != null) {
                try {
                    userid = UUID.fromString(uuid);
                }
                catch (IllegalArgumentException val) {
                    // empty catch block
                }
            }
            if (userid != null && permission != null && !permission.isEmpty()) {
                UUID val = userid;
                return (k, v) -> (kills == 0 || kills == v) && k.getUniqueId().equals(val) && k.hasPermission(permission) ? (kills > 0 ? 13 : 3) : -1;
            }
            if (userid != null) {
                UUID val = userid;
                return (k, v) -> (kills == 0 || kills == v) && k.getUniqueId().equals(val) ? (kills > 0 ? 12 : 2) : -1;
            }
            if (permission != null && !permission.isEmpty()) {
                return (k, v) -> (kills == 0 || kills == v) && k.hasPermission(permission) ? (kills > 0 ? 11 : 1) : -1;
            }
            return (k, v) -> kills == 0 || kills == v ? (kills > 0 ? 10 : 0) : -1;
        }
        if (EVENT_DEATH.equalsIgnoreCase(event)) {
            String[] cause = (String[])node.getNode(new Object[]{"cause"}).getChildrenList().stream().map(ConfigurationNode::getString).toArray(String[]::new);
            String uuid = node.getNode(new Object[]{"userid"}).getString();
            String permission = node.getNode(new Object[]{"permission"}).getString();
            if (cause == null) {
                return (k, v) -> -1;
            }
            UUID userid = null;
            if (uuid != null) {
                try {
                    userid = UUID.fromString(uuid);
                }
                catch (IllegalArgumentException val) {
                    // empty catch block
                }
            }
            if (userid != null && permission != null && !permission.isEmpty()) {
                UUID val = userid;
                return (k, v) -> {
                    int base = 0;
                    if (cause.length > 0) {
                        base += v == null || EventSoundRegistry.containsString(cause, v instanceof Living ? ((Living)v).getType().getId() : ((DamageType)v).getName()) ? 10 : -10;
                    }
                    return base < 0 ? -1 : (k.getUniqueId().equals(val) && k.hasPermission(permission) ? 3 + base : -1);
                };
            }
            if (userid != null) {
                UUID val = userid;
                return (k, v) -> {
                    int base = 0;
                    if (cause.length > 0) {
                        base += v == null || EventSoundRegistry.containsString(cause, v instanceof Living ? ((Living)v).getType().getId() : ((DamageType)v).getName()) ? 10 : -10;
                    }
                    return base < 0 ? -1 : (k.getUniqueId().equals(val) ? 2 + base : -1);
                };
            }
            if (permission != null && !permission.isEmpty()) {
                return (k, v) -> {
                    int base = 0;
                    if (cause.length > 0) {
                        base += v == null || EventSoundRegistry.containsString(cause, v instanceof Living ? ((Living)v).getType().getId() : ((DamageType)v).getName()) ? 10 : -10;
                    }
                    return base < 0 ? -1 : (k.hasPermission(permission) ? 1 + base : -1);
                };
            }
            return (k, v) -> {
                int base = 0;
                if (cause.length > 0) {
                    base += v == null || EventSoundRegistry.containsString(cause, v instanceof Living ? ((Living)v).getType().getId() : ((DamageType)v).getName()) ? 10 : -10;
                }
                return base < 0 ? -1 : base;
            };
        }
        return (k, v) -> 0;
    }

    private static boolean containsString(String[] array, Object other) {
        if (!(other instanceof String)) {
            return false;
        }
        for (String s : array) {
            if (!s.equalsIgnoreCase((String)other)) continue;
            return true;
        }
        return false;
    }

    public static Set<SoundDefinition> getSoundDefinitions() {
        return ImmutableSet.builder().addAll(sounds).build();
    }

    public static SoundDefinition registerSound(@NotNull String event, @NotNull String name, @NotNull String category, String ... files) {
        if (!event.matches("[a-z]+")) {
            throw new IllegalArgumentException("Event names have to be all lowercase letters (a-z)");
        }
        boolean isPrivileged = Thread.currentThread().getStackTrace()[2].getClassName().equals(SoundCollector.class.getName());
        Pattern regex = isPrivileged ? Pattern.compile("[a-z][\\w-]{0,63}\\.[A-Za-z][A-Za-z0-9]{0,63}") : Pattern.compile("[A-Za-z][A-Za-z0-9]{0,63}");
        if (!regex.matcher(name).matches()) {
            throw new RuntimeException("Names have to start with a letter and can only contain letters and digits (invalid: " + name + ")");
        }
        if (!isPrivileged) {
            for (String f : files) {
                File test = new File("./assets/eventsounds/", f);
                if (test.exists() && test.isFile()) continue;
                throw new RuntimeException("File " + test.getAbsoluteFile() + " for sound " + name + " is missing");
            }
        }
        String regName = String.format("es.%s.%s", event.toLowerCase(), name).toLowerCase();
        SoundDefinition definition = new SoundDefinition(regName, category, files);
        sounds.add(definition);
        return definition;
    }

    public static class Entry<K, V>
    implements Map.Entry<K, V> {
        K k;
        V v;

        public Entry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V value) {
            V o = this.v;
            this.v = value;
            return o;
        }

        public static <L, R> Entry<L, R> of(L k, R v) {
            return new Entry<L, R>(k, v);
        }
    }
}

