/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.sounds;

import de.dosmike.sponge.EventSounds.config.PlaytimeManager;
import de.dosmike.sponge.EventSounds.sounds.EventSoundRegistry;
import de.dosmike.sponge.EventSounds.sounds.SoundDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.title.Title;

public class Playable {
    private String[] message;
    private PlayTarget messageTarget;
    private PlayTarget soundTarget;
    private SoundDefinition sound;
    private int priority;

    public PlayTarget getMessageTarget() {
        return this.messageTarget;
    }

    public PlayTarget getSoundTarget() {
        return this.soundTarget;
    }

    public SoundDefinition getSound() {
        return this.sound;
    }

    public int getPriority() {
        return this.priority;
    }

    private Text resolveMessage(String message, Player player, @Nullable Player victim) {
        message = message.replace("%player%", player.getName()).replace("%victim%", victim == null ? "<ERROR>" : victim.getName());
        return TextSerializers.FORMATTING_CODE.deserialize(message);
    }

    private void sendMessage(Player player, Player victim) {
        Text subtitleText;
        Text titleText = this.message.length > 0 && !this.message[0].isEmpty() ? this.resolveMessage(this.message[0], player, victim) : Text.EMPTY;
        Text text = subtitleText = this.message.length > 1 && !this.message[1].isEmpty() ? this.resolveMessage(this.message[1], player, victim) : Text.EMPTY;
        if (titleText.isEmpty() && subtitleText.isEmpty()) {
            return;
        }
        if (!this.messageTarget.equals((Object)PlayTarget.NONE)) {
            player.sendTitle(Title.builder().title(titleText).subtitle(subtitleText).fadeIn(Integer.valueOf(0)).stay(Integer.valueOf(60)).fadeOut(Integer.valueOf(20)).build());
        }
        HashSet<Player> targets = new HashSet<Player>();
        if (this.messageTarget.equals((Object)PlayTarget.BOTH) && victim != null) {
            targets.add(victim);
        } else if (this.messageTarget.equals((Object)PlayTarget.WORLD)) {
            targets.addAll(player.getWorld().getPlayers());
        } else if (this.messageTarget.equals((Object)PlayTarget.ALL)) {
            targets.addAll(Sponge.getServer().getOnlinePlayers());
        }
        targets.remove(player);
        if (targets.size() > 0) {
            Title title = Title.builder().title(titleText).subtitle(subtitleText).fadeIn(Integer.valueOf(0)).stay(Integer.valueOf(60)).fadeOut(Integer.valueOf(20)).build();
            targets.forEach(target -> target.sendTitle(title));
        }
    }

    private void playForPlayer(Player player) {
        player.playSound(this.sound.getSound(), this.sound.getCategory(), player.getPosition(), Double.MAX_VALUE, 1.0, 1.0);
    }

    private void playSound(Player player, Player victim) {
        HashSet<Player> players = new HashSet<Player>();
        if (this.soundTarget != PlayTarget.NONE) {
            players.add(player);
        }
        if (this.soundTarget == PlayTarget.BOTH && victim != null) {
            players.add(victim);
            this.playForPlayer(victim);
        } else if (this.soundTarget == PlayTarget.WORLD) {
            players.addAll(player.getWorld().getPlayers());
        } else if (this.soundTarget == PlayTarget.ALL) {
            players.addAll(Sponge.getServer().getOnlinePlayers());
        }
        players.forEach(this::playForPlayer);
    }

    void play(@NotNull Player player, @Nullable Player victim) {
        PlaytimeManager.stopAndPlay(this.getSound(), player);
        this.sendMessage(player, victim);
        this.playSound(player, victim);
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ String[] access$002(Playable x0, String[] x1) {
        x0.message = x1;
        return x1;
    }

    public static class Builder {
        private String[] b_title;
        private String[] b_files;
        private int b_priority;
        private PlayTarget b_targetTitle;
        private PlayTarget b_targetSound;

        protected Builder() {
        }

        public Builder fromConfigurationNode(ConfigurationNode node) {
            this.b_files = (String[])node.getNode(new Object[]{"sounds"}).getChildrenList().stream().map(ConfigurationNode::getString).toArray(String[]::new);
            this.b_targetTitle = PlayTarget.getOrElse(node.getNode(new Object[]{"titleTarget"}).getString("?"), PlayTarget.NONE);
            this.b_targetSound = PlayTarget.getOrElse(node.getNode(new Object[]{"soundTarget"}).getString("?"), PlayTarget.ALL);
            List tmp = node.getNode(new Object[]{"title"}).getChildrenList().stream().map(ConfigurationNode::getString).collect(Collectors.toList());
            this.b_title = new String[]{"", ""};
            if (tmp.size() > 0) {
                this.b_title[0] = (String)tmp.get(0);
            }
            if (tmp.size() > 1) {
                this.b_title[1] = (String)tmp.get(1);
            }
            this.b_priority = node.getNode(new Object[]{"priority"}).getInt(-1);
            return this;
        }

        public Playable build(String event, String name) {
            Playable playable = new Playable();
            Playable.access$002(playable, this.b_title);
            playable.messageTarget = this.b_targetTitle;
            playable.soundTarget = this.b_targetSound;
            playable.priority = this.b_priority;
            playable.sound = EventSoundRegistry.registerSound(event, name, "master", this.b_files);
            return playable;
        }
    }

    public static enum PlayTarget {
        NONE,
        SOURCE,
        BOTH,
        WORLD,
        ALL;


        public static PlayTarget getOrElse(String key, PlayTarget other) {
            for (PlayTarget target : PlayTarget.values()) {
                if (!target.name().equalsIgnoreCase(key)) continue;
                return target;
            }
            return other;
        }
    }
}

