/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.sounds;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.dosmike.sponge.EventSounds.EventSounds;
import java.util.Arrays;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;

public class SoundDefinition {
    private String name;
    private SoundCategory category;
    private String[] files;
    private boolean external;

    SoundDefinition(String registryName, String category, String ... files) {
        this.name = registryName.toLowerCase();
        try {
            String tmp = category.indexOf(58) < 0 ? "minecraft:" + category : category;
            this.category = (SoundCategory)Sponge.getRegistry().getType(SoundCategory.class, tmp).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Sound Category " + category + " not found!");
        }
        this.files = files;
        this.external = registryName.split("\\.").length > 3;
    }

    public SoundType getSound() {
        return SoundType.of((String)this.name);
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public String getRegistryName() {
        return this.name;
    }

    public String getName() {
        int i = this.name.lastIndexOf(46);
        if (i < 0) {
            EventSounds.w("regName: " + this.name, new Object[0]);
        }
        return this.name.substring(Math.max(0, i + 1));
    }

    public boolean isExternal() {
        return this.external;
    }

    public String[] getFiles() {
        return this.files;
    }

    public JsonObject toJson() {
        JsonArray jfiles = new JsonArray();
        if (!this.external) {
            for (String s : this.files) {
                jfiles.add("custom/es/server/" + (s.endsWith(".ogg") ? s.substring(0, s.length() - 4) : s).toLowerCase());
            }
        } else {
            String pluginID = this.name.split("\\.")[2];
            for (String s : this.files) {
                jfiles.add("custom/es/plugin/" + pluginID + "/" + (s.endsWith(".ogg") ? s.substring(0, s.length() - 4) : s).toLowerCase());
            }
        }
        JsonObject jentry = new JsonObject();
        jentry.add("category", (JsonElement)new JsonPrimitive(this.category.getName().toLowerCase()));
        jentry.add("sounds", (JsonElement)jfiles);
        return jentry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundDefinition that = (SoundDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.category, that.category) && Arrays.equals(this.files, that.files);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.category);
        result = 31 * result + Arrays.hashCode(this.files);
        return result;
    }
}

