/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.EventSounds.sounds;

import ninja.leaping.configurate.ConfigurationNode;

public class SoundOptions {
    private static final String OPTION_COOLDOWN_CLIENT = "cooldown_client";
    private static final String OPTION_COOLDOWN_GLOBAL = "cooldown_global";
    private static final String OPTION_PLAYER_VS_MOBS = "pvm";
    private static final String OPTION_TRIGGER_DELAY = "delay";
    private int delayMs;
    private double cooldownGlobal;
    private double cooldownClient;
    private boolean pvm;
    private static final SoundOptions DEFAULT = new SoundOptions();

    private SoundOptions() {
    }

    public static SoundOptions parseConfigurationNode(ConfigurationNode node) {
        SoundOptions result = new SoundOptions();
        result.cooldownClient = node.getNode(new Object[]{OPTION_COOLDOWN_CLIENT}).getDouble(0.0);
        result.cooldownGlobal = node.getNode(new Object[]{OPTION_COOLDOWN_GLOBAL}).getDouble(0.0);
        result.delayMs = (int)(node.getNode(new Object[]{OPTION_TRIGGER_DELAY}).getDouble(0.0) * 1000.0);
        result.pvm = node.getNode(new Object[]{OPTION_PLAYER_VS_MOBS}).getBoolean(false);
        return result;
    }

    public static SoundOptions getDefault() {
        return DEFAULT;
    }

    public int getDelayMs() {
        return this.delayMs;
    }

    public double getCooldownGlobal() {
        return this.cooldownGlobal;
    }

    public double getCooldownClient() {
        return this.cooldownClient;
    }

    public boolean getPvmEnabled() {
        return this.pvm;
    }

    static {
        SoundOptions.DEFAULT.cooldownClient = 0.0;
        SoundOptions.DEFAULT.cooldownGlobal = 0.0;
        SoundOptions.DEFAULT.delayMs = 0;
        SoundOptions.DEFAULT.pvm = false;
    }
}

