/*
 * Decompiled with CFR 0.152.
 */
package shadow.dosmike.ftp.vshop.it.sauronsoftware.ftp4j;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public abstract class FTPConnector {
    protected int connectionTimeout = 10;
    protected int readTimeout = 10;
    protected int closeTimeout = 10;
    private boolean useSuggestedAddressForDataConnections;
    private Socket connectingCommunicationChannelSocket;

    protected FTPConnector(boolean useSuggestedAddressForDataConnectionsDefValue) {
        String sysprop = System.getProperty("ftp4j.passiveDataTransfer.useSuggestedAddress");
        this.useSuggestedAddressForDataConnections = "true".equalsIgnoreCase(sysprop) || "yes".equalsIgnoreCase(sysprop) || "1".equals(sysprop) ? true : ("false".equalsIgnoreCase(sysprop) || "no".equalsIgnoreCase(sysprop) || "0".equals(sysprop) ? false : useSuggestedAddressForDataConnectionsDefValue);
    }

    protected FTPConnector() {
        this(false);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setUseSuggestedAddressForDataConnections(boolean value) {
        this.useSuggestedAddressForDataConnections = value;
    }

    boolean getUseSuggestedAddressForDataConnections() {
        return this.useSuggestedAddressForDataConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket tcpConnectForCommunicationChannel(String host, int port) throws IOException {
        try {
            this.connectingCommunicationChannelSocket = new Socket();
            this.connectingCommunicationChannelSocket.setKeepAlive(true);
            this.connectingCommunicationChannelSocket.setSoTimeout(this.readTimeout * 1000);
            this.connectingCommunicationChannelSocket.setSoLinger(true, this.closeTimeout);
            this.connectingCommunicationChannelSocket.connect(new InetSocketAddress(host, port), this.connectionTimeout * 1000);
            Socket socket = this.connectingCommunicationChannelSocket;
            Object var5_4 = null;
            this.connectingCommunicationChannelSocket = null;
            return socket;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.connectingCommunicationChannelSocket = null;
            throw throwable;
        }
    }

    protected Socket tcpConnectForDataTransferChannel(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.readTimeout * 1000);
        socket.setSoLinger(true, this.closeTimeout);
        socket.setReceiveBufferSize(524288);
        socket.setSendBufferSize(524288);
        socket.connect(new InetSocketAddress(host, port), this.connectionTimeout * 1000);
        return socket;
    }

    public void abortConnectForCommunicationChannel() {
        if (this.connectingCommunicationChannelSocket != null) {
            try {
                this.connectingCommunicationChannelSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public abstract Socket connectForCommunicationChannel(String var1, int var2) throws IOException;

    public abstract Socket connectForDataTransferChannel(String var1, int var2) throws IOException;
}

