/*
 * Decompiled with CFR 0.152.
 */
package shadow.dosmike.versionchecker.eventsounds;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.plugin.meta.PluginDependency;

public class VersionChecker {
    private static final Version versionCheckerVersion = new Version("1.2");
    private static Set<String> allowedVersionChecking = new HashSet<String>();

    public static Version getVersionCheckerVersion() {
        return versionCheckerVersion;
    }

    public static void setVersionCheckingEnabled(String pluginID, boolean enabled) {
        if (enabled) {
            allowedVersionChecking.add(pluginID);
        } else {
            allowedVersionChecking.remove(pluginID);
        }
    }

    public static boolean isVersionCheckingAllowed(String pluginId) {
        return allowedVersionChecking.contains(pluginId);
    }

    public static void conformAuto(Object instance, Path configDir, String configName) {
        configDir.toFile().mkdirs();
        PluginContainer plugin = (PluginContainer)Sponge.getPluginManager().fromInstance(instance).orElseThrow(() -> new IllegalArgumentException("Passed onject is not a plugin"));
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(configDir.resolve(configName))).build();
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults());
            if (root.getNode(new Object[]{"enabled"}).isVirtual()) {
                root = loader.createEmptyNode(ConfigurationOptions.defaults());
                CommentedConfigurationNode node = root.getNode(new Object[]{"enabled"});
                node.setComment("It's strongly recommended to enable automatic version checking,\nThis will also inform you about changes in dependencies.\nSet this value to true to allow this Plugin to check for Updates on Ore");
                node.setValue((Object)false);
                loader.save((ConfigurationNode)root);
                VersionChecker.setVersionCheckingEnabled(plugin.getId(), false);
            } else {
                VersionChecker.setVersionCheckingEnabled(plugin.getId(), root.getNode(new Object[]{"enabled"}).getBoolean(false));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Task.builder().name("VersionChecker").async().execute(() -> VersionChecker.checkPluginVersion(plugin)).submit(instance);
    }

    public static void checkVersion(Object instance) {
        PluginContainer plugin = (PluginContainer)Sponge.getPluginManager().fromInstance(instance).orElseThrow(() -> new IllegalArgumentException("Passed onject is not a plugin"));
        VersionChecker.checkPluginVersion(plugin);
    }

    public static void checkPluginVersion(PluginContainer plugin) {
        plugin.getLogger().info("Searching for updates...");
        if (allowedVersionChecking.contains(plugin.getId())) {
            VersionChecker._checkPluginVersion(plugin);
        } else {
            plugin.getLogger().warn("The automatic Version Checker for " + plugin.getName() + "(" + plugin.getId() + ") is disabled!");
            plugin.getLogger().warn("It is strongly recommended to activate the Version Checker to keep your server secure and up to date!");
        }
    }

    private static HttpsURLConnection _connectTo(PluginContainer forPlugin, String method, String url, String session) throws IOException {
        URL apiURL = new URL(url);
        if (System.getProperty("VerboseVersionChecker", "false").equalsIgnoreCase("true")) {
            forPlugin.getLogger().info("[VersionChecker] requesting " + apiURL.toString());
        }
        HttpsURLConnection connection = (HttpsURLConnection)apiURL.openConnection();
        connection.setRequestMethod(method);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("User-Agent", "Version Checker (" + versionCheckerVersion.toString() + " by DosMike)/Plugin " + forPlugin.getName() + "(" + forPlugin.getId() + " " + forPlugin.getVersion() + ")");
        connection.setRequestProperty("Accept-Encoding", "identity");
        if (session != null) {
            connection.setRequestProperty("Authorization", "OreApi session=" + session);
        }
        if (connection.getResponseCode() != 200) {
            if (System.getProperty("VerboseVersionChecker", "false").equalsIgnoreCase("true")) {
                Logger l = forPlugin.getLogger();
                l.info("[VersionChecker] Response " + connection.getResponseCode() + " " + connection.getResponseMessage());
                l.info("[VersionChecker] received headers:");
                for (Map.Entry<String, List<String>> i : connection.getHeaderFields().entrySet()) {
                    l.info("[VersionChecker] " + i.getKey() + ": '" + String.join((CharSequence)"', '", (Iterable<? extends CharSequence>)i.getValue()));
                }
            }
            throw new RuntimeException();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject _fetchJson(HttpsURLConnection connection) throws IOException {
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new InputStreamReader(connection.getInputStream()));
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(reader).getAsJsonObject();
            return jsonObject;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void _checkPluginVersion(PluginContainer plugin) {
        block7: {
            Version currentVersion = new Version((String)plugin.getVersion().get());
            try {
                JsonObject response = VersionChecker._fetchJson(VersionChecker._connectTo(plugin, "POST", "https://ore.spongepowered.org/api/v2/authenticate", null));
                if (!response.has("session")) {
                    throw new IllegalStateException("Could not create OreApi/v2 session");
                }
                String session = response.get("session").getAsString();
                response = VersionChecker._fetchJson(VersionChecker._connectTo(plugin, "GET", "https://ore.spongepowered.org/api/v2/projects/" + plugin.getId(), session));
                if (!response.has("promoted_versions") || response.get("promoted_versions").isJsonNull()) {
                    throw new IllegalStateException("Target has no promoted versions");
                }
                JsonArray promoted_version_list = response.getAsJsonArray("promoted_versions");
                if (promoted_version_list.size() == 0) {
                    throw new IllegalStateException("Target has no promoted versions");
                }
                JsonObject latest = promoted_version_list.get(0).getAsJsonObject();
                String stringVersion = latest.get("version").getAsString();
                Version recommendedVersion = new Version(stringVersion);
                if (recommendedVersion.compareTo(currentVersion) > 0) {
                    String[] updateText;
                    plugin.getLogger().warn("Update Found: " + plugin.getName() + "(" + plugin.getId() + ") Version " + recommendedVersion.toString() + " is available on Ore!");
                    response = VersionChecker._fetchJson(VersionChecker._connectTo(plugin, "GET", "https://ore.spongepowered.org/api/v2/projects/" + plugin.getId() + "/versions/" + stringVersion, session));
                    for (String line : updateText = response.get("description").getAsString().split("(?:\\r)?\\n")) {
                        plugin.getLogger().warn("  " + line);
                    }
                    VersionChecker._checkPluginDependencies(plugin, response.get("dependencies").getAsJsonArray());
                }
            }
            catch (Exception e) {
                plugin.getLogger().warn("VersionChecker for " + plugin.getId() + " could not connect to ORE");
                if (!System.getProperty("VerboseVersionChecker", "false").equalsIgnoreCase("true")) break block7;
                e.printStackTrace();
            }
        }
    }

    private static void _checkPluginDependencies(PluginContainer plugin, JsonArray dependencies) {
        HashMap<String, Version> newDeps = new HashMap<String, Version>();
        HashSet<String> ignore = new HashSet<String>();
        for (int i = 0; i < dependencies.size(); ++i) {
            Version version;
            JsonObject obj = dependencies.get(i).getAsJsonObject();
            String pluginId = obj.get("plugin_id").getAsString();
            String versionString = obj.get("version").getAsString();
            try {
                if (versionString.startsWith("[") || versionString.startsWith("(")) {
                    String[] versionBounds = versionString.substring(1).split(",");
                    version = new Version(versionBounds[0]);
                } else {
                    version = new Version(versionString);
                }
            }
            catch (IllegalArgumentException e) {
                ignore.add(pluginId);
                continue;
            }
            newDeps.put(pluginId, version);
        }
        for (String pluginId : newDeps.keySet()) {
            Optional dep = Sponge.getPluginManager().getPlugin(pluginId);
            if (!dep.isPresent()) {
                plugin.getLogger().warn("> New Dependency: " + pluginId + " version " + ((Version)newDeps.get(pluginId)).toString());
                continue;
            }
            try {
                Version depCurrentVersion = new Version((String)((PluginContainer)dep.get()).getVersion().get());
                if (depCurrentVersion.compareTo((Version)newDeps.get(pluginId)) >= 0) continue;
                plugin.getLogger().warn("> Requires Dependency Update: " + pluginId + " to version " + ((Version)newDeps.get(pluginId)).toString());
            }
            catch (Exception e) {
                if (!System.getProperty("VerboseVersionChecker", "false").equalsIgnoreCase("true")) continue;
                plugin.getLogger().error("Error checking dependency " + pluginId);
                e.printStackTrace();
            }
        }
        for (PluginDependency dep : plugin.getDependencies()) {
            if (newDeps.containsKey(dep.getId()) || ignore.contains(dep.getId())) continue;
            plugin.getLogger().warn("> Old Dependency: " + dep.getId() + " no longer required in " + plugin.getId() + " version " + plugin.getVersion());
        }
    }

    public static class Version
    implements Comparable<Version> {
        private int[] n;
        private String s;
        private static final Pattern versionPattern = Pattern.compile("(?:[Vv]?\\s*)?(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?)?(?:[-_]([a-zA-Z]+)?[-_]?(\\d+)?)?");

        public Version(String version) {
            Matcher m = versionPattern.matcher(version);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid version string: " + version);
            }
            String major = m.group(1);
            String minor = m.group(2);
            String build = m.group(3);
            String revis = m.group(4);
            String stage = m.group(5);
            String patch = m.group(6);
            this.n = new int[]{Integer.parseInt(major), minor == null ? -1 : Integer.parseInt(minor), build == null ? -1 : Integer.parseInt(build), revis == null ? -1 : Integer.parseInt(revis), patch == null ? -1 : Integer.parseInt(patch)};
            this.s = stage == null ? "" : stage;
        }

        public int getMajor() {
            return this.n[0];
        }

        public int getMinor() {
            return this.n[1];
        }

        public int getBuild() {
            return this.n[2];
        }

        public int getRevision() {
            return this.n[3];
        }

        public int getPatch() {
            return this.n[4];
        }

        public String getStage() {
            return this.s;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.n[0]);
            if (this.n[1] >= 0) {
                sb.append('.');
                sb.append(this.n[1]);
            } else if (this.n[2] > 0 || this.n[3] > 0) {
                sb.append(".0");
            }
            if (this.n[2] >= 0) {
                sb.append('.');
                sb.append(this.n[2]);
            } else if (this.n[3] > 0) {
                sb.append(".0");
            }
            if (this.n[3] >= 0) {
                sb.append('.');
                sb.append(this.n[3]);
            }
            if (this.n[4] >= 0 || !this.s.isEmpty()) {
                sb.append('-');
                if (!this.s.isEmpty()) {
                    sb.append(this.s);
                }
                if (this.n[4] >= 0) {
                    sb.append(this.n[4]);
                }
            }
            return sb.toString();
        }

        public int hashCode() {
            return Objects.hash(this.n, this.s);
        }

        @Override
        public int compareTo(Version o) {
            int c = Integer.compare(this.n[0], o.n[0]);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.n[1], o.n[1]);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.n[2], o.n[2]);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.n[3], o.n[3]);
            if (c != 0) {
                return c;
            }
            c = this.s.compareTo(o.s);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.n[4], o.n[4]);
            if (c != 0) {
                return c;
            }
            return 0;
        }
    }
}

