/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames;

import com.google.inject.Inject;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPluginConfig;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.executor.DemoCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.listener.PlayerDeathListener;
import io.github.m0pt0pmatt.survivalgames.listener.PlayerOpenedChestListener;
import io.github.m0pt0pmatt.survivalgames.listener.SurvivalGameEventListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.SpongeExecutorService;

@Plugin(id="survival-games", name="Survival Games", version="1.2.0", description="Survival Games for Sponge.", url="https://github.com/mattysweeps/SurvivalGames")
public class SurvivalGamesPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger(SurvivalGamesPlugin.class);
    public static SpongeExecutorService SYNC_EXECUTOR;
    public static SpongeExecutorService ASYNC_EXECUTOR;
    public static SurvivalGamesPlugin PLUGIN;
    public static Path CONFIG_DIRECTORY;
    @Inject
    @ConfigDir(sharedRoot=true)
    private Path sharedRootConfig;
    private SurvivalGamesPluginConfig config;

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        PLUGIN = this;
        Sponge.getEventManager().registerListeners((Object)this, (Object)PlayerDeathListener.getInstance());
        Sponge.getEventManager().registerListeners((Object)this, (Object)SurvivalGameEventListener.getInstance());
        Sponge.getEventManager().registerListeners((Object)this, (Object)PlayerOpenedChestListener.getInstance());
        RootCommand rootCommand = RootCommand.getInstance();
        this.registerCommandTree(rootCommand);
        SYNC_EXECUTOR = Sponge.getScheduler().createSyncExecutor((Object)this);
        ASYNC_EXECUTOR = Sponge.getScheduler().createAsyncExecutor((Object)this);
        this.setupConfigDirectory();
        this.loadConfig();
        this.checkStartDemo();
        LOGGER.info("Survival Games Plugin Enabled.");
    }

    @Listener
    public void onServerStop(GameStoppingServerEvent event) {
        LOGGER.info("Survival Games Plugin Disabled.");
    }

    private void registerCommandTree(SurvivalGamesCommand survivalGamesCommand) {
        Sponge.getCommandManager().register((Object)this, Util.toCommandCallable(survivalGamesCommand), survivalGamesCommand.getAliases());
    }

    private void setupConfigDirectory() {
        File configDirectory = new File(this.sharedRootConfig.toFile(), "survival-games");
        if (!configDirectory.exists() && !configDirectory.mkdir()) {
            LOGGER.error("Could not create config directory!");
        }
        CONFIG_DIRECTORY = this.sharedRootConfig.resolve("survival-games");
    }

    private void loadConfig() {
        try {
            File file = CONFIG_DIRECTORY.resolve("plugin.yml").toFile();
            if (file.exists()) {
                HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file.toPath())).build();
                CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults());
                ObjectMapper.BoundInstance i = SurvivalGamesPluginConfig.OBJECT_MAPPER.bindToNew();
                this.config = (SurvivalGamesPluginConfig)i.populate((ConfigurationNode)node);
            } else {
                this.config = new SurvivalGamesPluginConfig();
            }
        }
        catch (IOException | RuntimeException | ObjectMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkStartDemo() {
        Optional<Boolean> autoRun = this.config.getAutoStartDemo();
        if (!autoRun.isPresent()) {
            return;
        }
        if (!autoRun.get().booleanValue()) {
            return;
        }
        Optional source = Sponge.getServer().getConsole().getCommandSource();
        if (!source.isPresent()) {
            throw new RuntimeException("Console command source was missing");
        }
        LOGGER.info("Automatically running the demo command");
        CommandContext context = new CommandContext();
        try {
            DemoCommand.getInstance().execute((CommandSource)source.get(), context);
        }
        catch (CommandException e) {
            throw new RuntimeException(e);
        }
    }
}

