/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames;

import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public final class Util {
    private Util() {
    }

    static CommandCallable toCommandCallable(SurvivalGamesCommand command) {
        CommandSpec.Builder builder = CommandSpec.builder();
        builder.executor((CommandExecutor)command);
        if (command.getChildren().size() > 0) {
            builder.children(command.getChildren().stream().collect(Collectors.toMap(SurvivalGamesCommand::getAliases, Util::toCommandCallable)));
        } else {
            builder.arguments(command.getArguments());
        }
        return builder.build();
    }

    public static <T> T getOrThrow(Optional<T> optional, Object name) throws CommandException {
        return optional.orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{TextColors.DARK_RED, "No value found", ": ", TextColors.BLUE, name})));
    }

    public static <T> T getOrThrow(Optional<T> optional, Object name, Object value) throws CommandException {
        return optional.orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{TextColors.DARK_RED, "No ", TextColors.BLUE, name, ": ", TextColors.BLUE, value})));
    }

    public static Object getOrThrow(CommandContext args, Text key) throws CommandException {
        return args.getOne(key).orElseThrow(() -> new CommandException(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Argument not found", ": ", TextColors.BLUE, key})));
    }

    public static void sendSuccess(CommandSource source, Object message) {
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, message}));
    }

    public static void sendSuccess(CommandSource source, Object message, Object object) {
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, message, ": ", TextColors.BLUE, object}));
    }

    public static void sendError(CommandSource source, String message) {
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, message}));
    }

    public static void sendError(CommandSource source, Object message, Object object) {
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, message, ": ", TextColors.BLUE, object}));
    }

    public static Text gamePrefix(SurvivalGame survivalGame) {
        return Text.of((Object[])new Object[]{TextColors.YELLOW, "[ssg:", survivalGame.getName(), "] "});
    }
}

