/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.element;

import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.SelectorCommandElement;

public class ConfigFileCommandElement
extends SelectorCommandElement {
    private static final CommandElement INSTANCE = new ConfigFileCommandElement();

    private ConfigFileCommandElement() {
        super(CommandKeys.FILE_PATH);
    }

    @Nonnull
    protected Iterable<String> getChoices(@Nonnull CommandSource source) {
        File[] files = SurvivalGamesPlugin.CONFIG_DIRECTORY.toFile().listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(File::getName).collect(Collectors.toList());
    }

    @Nonnull
    protected Object getValue(@Nonnull String choice) throws IllegalArgumentException {
        return SurvivalGamesPlugin.CONFIG_DIRECTORY.resolve(choice);
    }

    public static CommandElement getInstance() {
        return INSTANCE;
    }
}

