/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.element;

import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.data.GameConfig;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRepository;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.SelectorCommandElement;

public class MobSpawnAreaCommandElement
extends SelectorCommandElement {
    private static final CommandElement INSTANCE = new MobSpawnAreaCommandElement();

    private MobSpawnAreaCommandElement() {
        super(CommandKeys.MOB_SPAWN_AREA);
    }

    @Nonnull
    protected Iterable<String> getChoices(@Nonnull CommandSource source) {
        return SurvivalGameCommandElement.getInstance().getCurrentSurvivalGameName().map(SurvivalGameRepository::get).map(o -> o.map(SurvivalGame::getConfig).map(GameConfig::getMobSpawnAreas).orElse(Collections.emptyList())).map(list -> list.stream().map(MobSpawnArea::getId).map(UUID::toString).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Nonnull
    protected Object getValue(@Nonnull String choice) throws IllegalArgumentException {
        UUID id = UUID.fromString(choice);
        Optional<MobSpawnArea> mobSpawnArea = SurvivalGameCommandElement.getInstance().getCurrentSurvivalGameName().map(SurvivalGameRepository::get).map(o -> o.map(SurvivalGame::getConfig).map(GameConfig::getMobSpawnAreas).orElse(Collections.emptyList())).orElse(Collections.emptyList()).stream().filter(m -> m.getId().equals(id)).findAny();
        if (mobSpawnArea.isPresent()) {
            return mobSpawnArea.get();
        }
        throw new IllegalArgumentException();
    }

    public static CommandElement getInstance() {
        return INSTANCE;
    }
}

