/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.element;

import com.google.common.collect.ImmutableList;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.SelectorCommandElement;
import org.spongepowered.api.text.selector.Selector;

public class SurvivalGameCommandElement
extends SelectorCommandElement {
    private static final SurvivalGameCommandElement INSTANCE = new SurvivalGameCommandElement();
    private static String currentSurvivalGame;

    private SurvivalGameCommandElement() {
        super(CommandKeys.SURVIVAL_GAME);
    }

    @Nonnull
    protected Iterable<String> getChoices(@Nonnull CommandSource source) {
        return SurvivalGameRepository.values().stream().map(SurvivalGame::getName).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> complete(@Nonnull CommandSource src, CommandArgs args, CommandContext context) {
        Optional nextArg = args.nextIfPresent();
        List choices = nextArg.map(Selector::complete).orElseGet(ImmutableList::of);
        if (choices.isEmpty()) {
            choices = super.complete(src, args, context);
        }
        currentSurvivalGame = choices.size() == 1 ? (String)choices.get(0) : null;
        return choices;
    }

    @Nonnull
    protected Object getValue(@Nonnull String choice) throws IllegalArgumentException {
        Optional<SurvivalGame> survivalGame = SurvivalGameRepository.get(choice);
        if (survivalGame.isPresent()) {
            return survivalGame.get();
        }
        throw new IllegalArgumentException();
    }

    Optional<String> getCurrentSurvivalGameName() {
        return Optional.ofNullable(currentSurvivalGame);
    }

    public static SurvivalGameCommandElement getInstance() {
        return INSTANCE;
    }
}

