/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public abstract class BaseCommand
implements SurvivalGamesCommand {
    private final List<String> aliases;
    private final CommandElement arguments;
    private final SurvivalGamesCommand parentCommand;

    protected BaseCommand(SurvivalGamesCommand parentCommand, String name, CommandElement arguments) {
        this.parentCommand = parentCommand;
        this.aliases = Collections.singletonList(Preconditions.checkNotNull((Object)name, (Object)"name"));
        this.arguments = (CommandElement)Preconditions.checkNotNull((Object)arguments, (Object)"arguments");
    }

    @Nonnull
    public abstract CommandResult executeCommand(@Nonnull CommandSource var1, @Nonnull CommandContext var2) throws CommandException;

    @Override
    public boolean testPermission(CommandSource source) {
        return this.getPermission() == null || source.hasPermission(this.getPermission()) || Optional.ofNullable(this.parentCommand).map(p -> p.testPermission(source)).orElse(false) != false;
    }

    @Nonnull
    public final CommandResult execute(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        if (!this.testPermission(src)) {
            throw new CommandException((Text)Text.of((String)"You do not have permission to run this command"));
        }
        return this.executeCommand(src, args);
    }

    @Override
    public final List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public final CommandElement getArguments() {
        return this.arguments;
    }

    @Override
    public String getPermission() {
        if (this.parentCommand == null) {
            return this.aliases.get(0);
        }
        return this.parentCommand.getPermission() + "." + this.aliases.get(0);
    }
}

