/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public abstract class BlockRayCommand
extends LeafCommand {
    private final BiConsumer<SurvivalGame, Location<World>> setter;
    private final Text message;

    protected BlockRayCommand(SurvivalGamesCommand parentCommand, String name, BiConsumer<SurvivalGame, Location<World>> setter, Text message) {
        super(parentCommand, name, GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), GenericArguments.optional((CommandElement)GenericArguments.vector3d((Text)CommandKeys.VECTOR))}));
        this.setter = (BiConsumer)Preconditions.checkNotNull(setter, (Object)"setter");
        this.message = (Text)Preconditions.checkNotNull((Object)message, (Object)"message");
    }

    @Override
    @Nonnull
    public final CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        Location location;
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        if (args.hasAny(CommandKeys.VECTOR)) {
            String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
            World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD);
            location = world.getLocation((Vector3d)Util.getOrThrow(args, CommandKeys.VECTOR));
        } else {
            location = this.getLocation(src);
        }
        try {
            this.setter.accept(survivalGame, location);
        }
        catch (RuntimeException e) {
            throw new CommandException((Text)Text.of((String)("Error: " + e.getMessage())), (Throwable)e);
        }
        Util.sendSuccess(src, this.message, location.getBlockPosition());
        return CommandResult.success();
    }

    protected Location<World> getLocation(CommandSource commandSource) throws CommandException {
        if (!(commandSource instanceof Player)) {
            throw new CommandException((Text)Text.of((String)"Only players can execute this command"));
        }
        BlockRay blockRay = BlockRay.from((Entity)((Entity)commandSource)).stopFilter(BlockRay.continueAfterFilter((Predicate)BlockRay.onlyAirFilter(), (int)1)).build();
        return ((BlockRayHit)blockRay.end().orElseThrow(() -> new CommandException((Text)Text.of((String)"Block Ray Didn't Hit")))).getLocation();
    }
}

