/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.event.GameCreatedEvent;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRepository;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;

public class CreateGameCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new CreateGameCommand();

    private CreateGameCommand() {
        super(RootCommand.getInstance(), "create", GenericArguments.string((Text)CommandKeys.SURVIVAL_GAME_NAME));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        String survivalGameName = (String)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME_NAME);
        if (SurvivalGameRepository.contains(survivalGameName)) {
            Util.sendError(src, "Game of the same name already exists", survivalGameName);
            return CommandResult.empty();
        }
        SurvivalGame survivalGame = new SurvivalGame(survivalGameName);
        SurvivalGameRepository.put(survivalGameName, survivalGame);
        Util.sendSuccess(src, "Created game", survivalGameName);
        Sponge.getEventManager().post((Event)new GameCreatedEvent(survivalGame));
        return CommandResult.success();
    }

    public static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

