/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRepository;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;

public class DeleteGameCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new DeleteGameCommand();

    private DeleteGameCommand() {
        super(RootCommand.getInstance(), "delete", (CommandElement)SurvivalGameCommandElement.getInstance());
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        SurvivalGameRepository.remove(survivalGame.getName());
        Util.sendSuccess(src, "Deleted game", survivalGame.getName());
        return CommandResult.success();
    }

    public static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

