/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.LoadConfigCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.ScheduleCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.set.SetBlocksCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRepository;
import io.github.m0pt0pmatt.survivalgames.thread.ProgressBuilder;
import io.github.m0pt0pmatt.survivalgames.thread.UnzipRunnable;
import io.github.m0pt0pmatt.survivalgames.thread.UrlDownloadRunnable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.WorldProperties;

public class DemoCommand
extends LeafCommand {
    private static final DemoCommand INSTANCE = new DemoCommand();
    private static final String DEMO_MAP_OBJECT = "ssg-demo-map_v4.zip";
    private static final String DEMO_MAP_WORLD_NAME = "ssg-demo-map";
    private static final String S3_BUCKET = "https://s3.amazonaws.com/com.cloudcraftnetwork.survivalgames.maps/";

    private DemoCommand() {
        super(RootCommand.getInstance(), "demo", GenericArguments.none());
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        URL url;
        try {
            url = new URL("https://s3.amazonaws.com/com.cloudcraftnetwork.survivalgames.maps/ssg-demo-map_v4.zip");
        }
        catch (MalformedURLException e) {
            throw new CommandException((Text)Text.of((String)"Bad url"), (Throwable)e);
        }
        UrlDownloadRunnable urlDownloadRunnable = new UrlDownloadRunnable(url, DEMO_MAP_OBJECT, 25657717L);
        Duration timeout = Duration.of(5L, ChronoUnit.MINUTES);
        ProgressBuilder.builder(src, (Executor)SurvivalGamesPlugin.SYNC_EXECUTOR, (Executor)SurvivalGamesPlugin.ASYNC_EXECUTOR).runSync(this::deleteExistingWorld, "Deleting Old World", (TemporalAmount)timeout).runAsync(urlDownloadRunnable, "Downloading World", (TemporalAmount)timeout).runAsync(this::unzipWorld, "Unzipping World", (TemporalAmount)timeout).runSync(this::loadWorld, "Loading World", (TemporalAmount)timeout).runSync(this::downloadConfig, "Downloading Config", (TemporalAmount)timeout).runSync(() -> this.loadConfig(src), "Loading Config", (TemporalAmount)timeout).runSync(() -> this.setBlocks(src), "Setting Blocks", (TemporalAmount)timeout).runAsync(this::downloadSchedule, "Downloading Schedule", (TemporalAmount)timeout).runSync(() -> this.scheduleGame(src), "Scheduling Game", (TemporalAmount)timeout).runSync(() -> Util.sendSuccess(src, "Demo ready! Join with /ssg join demo"), "", (TemporalAmount)timeout).start();
        return CommandResult.success();
    }

    private void deleteExistingWorld() {
        Optional worldProperties;
        Optional world = Sponge.getServer().getWorld(DEMO_MAP_WORLD_NAME);
        if (world.isPresent()) {
            World w = (World)world.get();
            if (!Sponge.getServer().unloadWorld(w)) {
                throw new RuntimeException("Could not unload demo world");
            }
        }
        if ((worldProperties = Sponge.getServer().getWorldProperties(DEMO_MAP_WORLD_NAME)).isPresent()) {
            WorldProperties wp = (WorldProperties)worldProperties.get();
            CompletableFuture future = Sponge.getServer().deleteWorld(wp);
            try {
                if (!((Boolean)future.get(60L, TimeUnit.SECONDS)).booleanValue()) {
                    throw new RuntimeException("Could not delete demo world");
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not delete demo world");
            }
        }
    }

    private void unzipWorld() {
        File existing = new File(Sponge.getServer().getDefaultWorldName(), DEMO_MAP_WORLD_NAME);
        if (existing.exists()) {
            try {
                MoreFiles.deleteRecursively((Path)existing.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        new UnzipRunnable(DEMO_MAP_OBJECT, Sponge.getServer().getDefaultWorldName()).run();
    }

    private void loadWorld() {
        try {
            WorldProperties props = Sponge.getServer().createWorldProperties(DEMO_MAP_WORLD_NAME, WorldArchetype.builder().dimension(DimensionTypes.OVERWORLD).enabled(true).pvp(true).build(UUID.randomUUID().toString(), DEMO_MAP_WORLD_NAME));
            if (!Sponge.getServer().loadWorld(props).isPresent()) {
                throw new RuntimeException("Could not load world, check logs");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void downloadConfig() {
        try {
            ReadableByteChannel readableByteChannel = Channels.newChannel(new URL("https://s3.amazonaws.com/com.cloudcraftnetwork.survivalgames.maps/demo.yml").openStream());
            FileOutputStream fileOutputStream = new FileOutputStream("config" + File.separator + "survival-games" + File.separator + "demo.yml");
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to download config", e);
        }
    }

    private void loadConfig(CommandSource src) {
        CommandContext loadContext = new CommandContext();
        loadContext.putArg(CommandKeys.SURVIVAL_GAME_NAME, (Object)"demo");
        loadContext.putArg(CommandKeys.FILE_PATH, (Object)new File("config" + File.separator + "survival-games" + File.separator + "demo.yml").toPath());
        try {
            LoadConfigCommand.getInstance().execute(src, loadContext);
        }
        catch (CommandException e) {
            throw new RuntimeException(e);
        }
    }

    private void setBlocks(CommandSource src) {
        CommandContext context = new CommandContext();
        context.putArg(CommandKeys.SURVIVAL_GAME, (Object)SurvivalGameRepository.get("demo").orElseThrow(() -> new RuntimeException("Demo map didn't exist")));
        try {
            SetBlocksCommand.getInstance().execute(src, context);
        }
        catch (CommandException e) {
            throw new RuntimeException(e);
        }
    }

    private void downloadSchedule() {
        try {
            ReadableByteChannel readableByteChannel = Channels.newChannel(new URL("https://s3.amazonaws.com/com.cloudcraftnetwork.survivalgames.maps/demo-schedule.yml").openStream());
            FileOutputStream fileOutputStream = new FileOutputStream("config" + File.separator + "survival-games" + File.separator + "demo-schedule.yml");
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to download config", e);
        }
    }

    private void scheduleGame(CommandSource src) {
        CommandContext context = new CommandContext();
        context.putArg(CommandKeys.SURVIVAL_GAME, (Object)SurvivalGameRepository.get("demo").orElseThrow(() -> new RuntimeException("Demo map didn't exist")));
        context.putArg(CommandKeys.FILE_PATH, (Object)new File("config" + File.separator + "survival-games" + File.separator + "demo-schedule.yml").toPath());
        try {
            ScheduleCommand.getInstance().execute(src, context);
        }
        catch (CommandException e) {
            throw new RuntimeException(e);
        }
    }

    public static DemoCommand getInstance() {
        return INSTANCE;
    }
}

